/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.relation;

import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.RowExpressionVisitor;
import com.facebook.presto.spi.type.Type;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.concurrent.Immutable;

@Immutable
public class SpecialFormExpression
extends RowExpression {
    private final Form form;
    private final Type returnType;
    private final List<RowExpression> arguments;

    public SpecialFormExpression(Form form, Type returnType, RowExpression ... arguments) {
        this(form, returnType, Collections.unmodifiableList(Arrays.asList(arguments)));
    }

    @JsonCreator
    public SpecialFormExpression(@JsonProperty(value="form") Form form, @JsonProperty(value="returnType") Type returnType, @JsonProperty(value="arguments") List<RowExpression> arguments) {
        this.form = Objects.requireNonNull(form, "form is null");
        this.returnType = Objects.requireNonNull(returnType, "returnType is null");
        this.arguments = Objects.requireNonNull(arguments, "arguments is null");
    }

    @JsonProperty
    public Form getForm() {
        return this.form;
    }

    @Override
    @JsonProperty(value="returnType")
    public Type getType() {
        return this.returnType;
    }

    @JsonProperty
    public List<RowExpression> getArguments() {
        return this.arguments;
    }

    @Override
    public String toString() {
        return this.form.name() + "(" + String.join((CharSequence)", ", this.arguments.stream().map(RowExpression::toString).collect(Collectors.toList())) + ")";
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.form, this.arguments});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SpecialFormExpression other = (SpecialFormExpression)obj;
        return this.form == other.form && Objects.equals(this.arguments, other.arguments);
    }

    @Override
    public <R, C> R accept(RowExpressionVisitor<R, C> visitor, C context) {
        return visitor.visitSpecialForm(this, context);
    }

    public static enum Form {
        IF,
        NULL_IF,
        SWITCH,
        WHEN,
        IS_NULL,
        COALESCE,
        IN,
        AND,
        OR,
        DEREFERENCE,
        ROW_CONSTRUCTOR,
        BIND;

    }
}

