/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.statistics;

import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.statistics.ColumnStatistics;
import com.facebook.presto.spi.statistics.Estimate;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public final class TableStatistics {
    private static final TableStatistics EMPTY = TableStatistics.builder().build();
    private final Estimate rowCount;
    private final Map<ColumnHandle, ColumnStatistics> columnStatistics;

    public static TableStatistics empty() {
        return EMPTY;
    }

    public TableStatistics(Estimate rowCount, Map<ColumnHandle, ColumnStatistics> columnStatistics) {
        this.rowCount = Objects.requireNonNull(rowCount, "rowCount can not be null");
        if (!rowCount.isUnknown() && rowCount.getValue() < 0.0) {
            throw new IllegalArgumentException(String.format("rowCount must be greater than or equal to 0: %s", rowCount.getValue()));
        }
        this.columnStatistics = Collections.unmodifiableMap(Objects.requireNonNull(columnStatistics, "columnStatistics can not be null"));
    }

    @JsonProperty
    public Estimate getRowCount() {
        return this.rowCount;
    }

    @JsonProperty
    public Map<ColumnHandle, ColumnStatistics> getColumnStatistics() {
        return this.columnStatistics;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableStatistics that = (TableStatistics)o;
        return Objects.equals(this.rowCount, that.rowCount) && Objects.equals(this.columnStatistics, that.columnStatistics);
    }

    public int hashCode() {
        return Objects.hash(this.rowCount, this.columnStatistics);
    }

    public String toString() {
        return "TableStatistics{rowCount=" + this.rowCount + ", columnStatistics=" + this.columnStatistics + '}';
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Estimate rowCount = Estimate.unknown();
        private Map<ColumnHandle, ColumnStatistics> columnStatisticsMap = new LinkedHashMap<ColumnHandle, ColumnStatistics>();

        public Builder setRowCount(Estimate rowCount) {
            this.rowCount = Objects.requireNonNull(rowCount, "rowCount can not be null");
            return this;
        }

        public Builder setColumnStatistics(ColumnHandle columnHandle, ColumnStatistics columnStatistics) {
            Objects.requireNonNull(columnHandle, "columnHandle can not be null");
            Objects.requireNonNull(columnStatistics, "columnStatistics can not be null");
            this.columnStatisticsMap.put(columnHandle, columnStatistics);
            return this;
        }

        public TableStatistics build() {
            return new TableStatistics(this.rowCount, this.columnStatisticsMap);
        }
    }
}

