/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.type;

import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.AbstractIntType;
import com.facebook.presto.spi.type.TypeSignature;

public final class IntegerType
extends AbstractIntType {
    public static final IntegerType INTEGER = new IntegerType();

    private IntegerType() {
        super(TypeSignature.parseTypeSignature("integer"));
    }

    @Override
    public Object getObjectValue(ConnectorSession session, Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        return block.getInt(position);
    }

    @Override
    public final void writeLong(BlockBuilder blockBuilder, long value) {
        if (value > Integer.MAX_VALUE) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("Value %d exceeds MAX_INT", value));
        }
        if (value < Integer.MIN_VALUE) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("Value %d is less than MIN_INT", value));
        }
        blockBuilder.writeInt((int)value).closeEntry();
    }

    @Override
    public boolean equals(Object other) {
        return other == INTEGER;
    }

    @Override
    public int hashCode() {
        return this.getClass().hashCode();
    }
}

