/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.type;

import com.facebook.presto.spi.type.TimeZoneKey;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import java.util.Optional;

public final class SqlTimestamp {
    public static final String JSON_FORMAT = "uuuu-MM-dd HH:mm:ss.SSS";
    public static final DateTimeFormatter JSON_FORMATTER = DateTimeFormatter.ofPattern("uuuu-MM-dd HH:mm:ss.SSS");
    private final long millis;
    private final Optional<TimeZoneKey> sessionTimeZoneKey;

    public SqlTimestamp(long millis) {
        this.millis = millis;
        this.sessionTimeZoneKey = Optional.empty();
    }

    @Deprecated
    public SqlTimestamp(long millisUtc, TimeZoneKey sessionTimeZoneKey) {
        this.millis = millisUtc;
        this.sessionTimeZoneKey = Optional.of(sessionTimeZoneKey);
    }

    public long getMillis() {
        SqlTimestamp.checkState(!this.isLegacyTimestamp(), "getMillis() can be called in new timestamp semantics only");
        return this.millis;
    }

    @Deprecated
    public long getMillisUtc() {
        SqlTimestamp.checkState(this.isLegacyTimestamp(), "getMillisUtc() can be called in legacy timestamp semantics only");
        return this.millis;
    }

    @Deprecated
    public Optional<TimeZoneKey> getSessionTimeZoneKey() {
        return this.sessionTimeZoneKey;
    }

    @Deprecated
    public boolean isLegacyTimestamp() {
        return this.sessionTimeZoneKey.isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.millis, this.sessionTimeZoneKey);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SqlTimestamp other = (SqlTimestamp)obj;
        return Objects.equals(this.millis, other.millis) && Objects.equals(this.sessionTimeZoneKey, other.sessionTimeZoneKey);
    }

    @JsonValue
    public String toString() {
        if (this.isLegacyTimestamp()) {
            return Instant.ofEpochMilli(this.millis).atZone(ZoneId.of(this.sessionTimeZoneKey.get().getId())).format(JSON_FORMATTER);
        }
        return Instant.ofEpochMilli(this.millis).atZone(ZoneId.of(TimeZoneKey.UTC_KEY.getId())).format(JSON_FORMATTER);
    }

    private static void checkState(boolean condition, String message) {
        if (!condition) {
            throw new IllegalStateException(message);
        }
    }
}

