/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.presto.hive.HiveFileContext;
import com.facebook.presto.memory.context.AggregatedMemoryContext;
import com.facebook.presto.orc.CachingOrcDataSource;
import com.facebook.presto.orc.DiskRange;
import com.facebook.presto.orc.FilterFunction;
import com.facebook.presto.orc.OrcBatchRecordReader;
import com.facebook.presto.orc.OrcCorruptionException;
import com.facebook.presto.orc.OrcDataSource;
import com.facebook.presto.orc.OrcDecompressor;
import com.facebook.presto.orc.OrcEncoding;
import com.facebook.presto.orc.OrcPredicate;
import com.facebook.presto.orc.OrcReaderOptions;
import com.facebook.presto.orc.OrcSelectiveRecordReader;
import com.facebook.presto.orc.OrcWriteValidation;
import com.facebook.presto.orc.StorageStripeMetadataSource;
import com.facebook.presto.orc.StripeMetadataSource;
import com.facebook.presto.orc.TupleDomainFilter;
import com.facebook.presto.orc.cache.OrcFileTailSource;
import com.facebook.presto.orc.cache.StorageOrcFileTailSource;
import com.facebook.presto.orc.metadata.CompressionKind;
import com.facebook.presto.orc.metadata.ExceptionWrappingMetadataReader;
import com.facebook.presto.orc.metadata.Footer;
import com.facebook.presto.orc.metadata.Metadata;
import com.facebook.presto.orc.metadata.OrcFileTail;
import com.facebook.presto.orc.metadata.PostScript;
import com.facebook.presto.orc.stream.OrcInputStream;
import com.facebook.presto.spi.Subfield;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.Type;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.FixedLengthSliceInput;
import io.airlift.units.DataSize;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import org.joda.time.DateTimeZone;

public class OrcReader {
    public static final int MAX_BATCH_SIZE = 1024;
    public static final int INITIAL_BATCH_SIZE = 1;
    public static final int BATCH_SIZE_GROWTH_FACTOR = 2;
    private final OrcDataSource orcDataSource;
    private final ExceptionWrappingMetadataReader metadataReader;
    private final PostScript.HiveWriterVersion hiveWriterVersion;
    private final int bufferSize;
    private final CompressionKind compressionKind;
    private final Optional<OrcDecompressor> decompressor;
    private final Footer footer;
    private final Metadata metadata;
    private final Optional<OrcWriteValidation> writeValidation;
    private final StripeMetadataSource stripeMetadataSource;
    private final OrcReaderOptions orcReaderOptions;
    private final HiveFileContext hiveFileContext;

    public OrcReader(OrcDataSource orcDataSource, OrcEncoding orcEncoding, OrcFileTailSource orcFileTailSource, StripeMetadataSource stripeMetadataSource, OrcReaderOptions orcReaderOptions, HiveFileContext hiveFileContext) throws IOException {
        this(orcDataSource, orcEncoding, orcFileTailSource, stripeMetadataSource, Optional.empty(), orcReaderOptions, hiveFileContext);
    }

    OrcReader(OrcDataSource orcDataSource, OrcEncoding orcEncoding, OrcFileTailSource orcFileTailSource, StripeMetadataSource stripeMetadataSource, Optional<OrcWriteValidation> writeValidation, OrcReaderOptions orcReaderOptions, HiveFileContext hiveFileContext) throws IOException {
        this.orcReaderOptions = Objects.requireNonNull(orcReaderOptions, "orcReaderOptions is null");
        this.orcDataSource = orcDataSource = OrcReader.wrapWithCacheIfTiny(orcDataSource, orcReaderOptions.getTinyStripeThreshold());
        Objects.requireNonNull(orcEncoding, "orcEncoding is null");
        this.metadataReader = new ExceptionWrappingMetadataReader(orcDataSource.getId(), orcEncoding.createMetadataReader());
        this.writeValidation = Objects.requireNonNull(writeValidation, "writeValidation is null");
        this.stripeMetadataSource = Objects.requireNonNull(stripeMetadataSource, "stripeMetadataSource is null");
        OrcFileTail orcFileTail = orcFileTailSource.getOrcFileTail(orcDataSource, this.metadataReader, writeValidation, hiveFileContext);
        this.bufferSize = orcFileTail.getBufferSize();
        this.compressionKind = orcFileTail.getCompressionKind();
        this.decompressor = OrcDecompressor.createOrcDecompressor(orcDataSource.getId(), this.compressionKind, this.bufferSize, orcReaderOptions.isOrcZstdJniDecompressionEnabled());
        this.hiveWriterVersion = orcFileTail.getHiveWriterVersion();
        try (OrcInputStream footerInputStream = new OrcInputStream(orcDataSource.getId(), (FixedLengthSliceInput)orcFileTail.getFooterSlice().getInput(), this.decompressor, AggregatedMemoryContext.newSimpleAggregatedMemoryContext(), orcFileTail.getFooterSize());){
            this.footer = this.metadataReader.readFooter(this.hiveWriterVersion, footerInputStream);
        }
        if (this.footer.getTypes().size() == 0) {
            throw new OrcCorruptionException(orcDataSource.getId(), "File has no columns");
        }
        var10_10 = null;
        try (OrcInputStream metadataInputStream = new OrcInputStream(orcDataSource.getId(), (FixedLengthSliceInput)orcFileTail.getMetadataSlice().getInput(), this.decompressor, AggregatedMemoryContext.newSimpleAggregatedMemoryContext(), orcFileTail.getMetadataSize());){
            this.metadata = this.metadataReader.readMetadata(this.hiveWriterVersion, metadataInputStream);
        }
        catch (Throwable throwable) {
            var10_10 = throwable;
            throw throwable;
        }
        OrcReader.validateWrite(writeValidation, orcDataSource, validation -> validation.getColumnNames().equals(this.footer.getTypes().get(0).getFieldNames()), "Unexpected column names", new Object[0]);
        OrcReader.validateWrite(writeValidation, orcDataSource, validation -> validation.getRowGroupMaxRowCount() == this.footer.getRowsInRowGroup(), "Unexpected rows in group", new Object[0]);
        if (writeValidation.isPresent()) {
            writeValidation.get().validateMetadata(orcDataSource.getId(), this.footer.getUserMetadata());
            writeValidation.get().validateFileStatistics(orcDataSource.getId(), this.footer.getFileStats());
            writeValidation.get().validateStripeStatistics(orcDataSource.getId(), this.footer.getStripes(), this.metadata.getStripeStatsList());
        }
        this.hiveFileContext = Objects.requireNonNull(hiveFileContext, "hiveFileContext is null");
    }

    public List<String> getColumnNames() {
        return this.footer.getTypes().get(0).getFieldNames();
    }

    public Footer getFooter() {
        return this.footer;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public CompressionKind getCompressionKind() {
        return this.compressionKind;
    }

    public OrcBatchRecordReader createBatchRecordReader(Map<Integer, Type> includedColumns, OrcPredicate predicate, DateTimeZone hiveStorageTimeZone, AggregatedMemoryContext systemMemoryUsage, int initialBatchSize, HiveFileContext hiveFileContext) throws OrcCorruptionException {
        return this.createBatchRecordReader(includedColumns, predicate, 0L, this.orcDataSource.getSize(), hiveStorageTimeZone, systemMemoryUsage, initialBatchSize, hiveFileContext);
    }

    public OrcBatchRecordReader createBatchRecordReader(Map<Integer, Type> includedColumns, OrcPredicate predicate, long offset, long length, DateTimeZone hiveStorageTimeZone, AggregatedMemoryContext systemMemoryUsage, int initialBatchSize, HiveFileContext hiveFileContext) throws OrcCorruptionException {
        return new OrcBatchRecordReader(Objects.requireNonNull(includedColumns, "includedColumns is null"), Objects.requireNonNull(predicate, "predicate is null"), this.footer.getNumberOfRows(), this.footer.getStripes(), this.footer.getFileStats(), this.metadata.getStripeStatsList(), this.orcDataSource, offset, length, this.footer.getTypes(), this.decompressor, this.footer.getRowsInRowGroup(), Objects.requireNonNull(hiveStorageTimeZone, "hiveStorageTimeZone is null"), this.hiveWriterVersion, this.metadataReader, this.orcReaderOptions.getMaxMergeDistance(), this.orcReaderOptions.getTinyStripeThreshold(), this.orcReaderOptions.getMaxBlockSize(), this.footer.getUserMetadata(), systemMemoryUsage.newAggregatedMemoryContext(), this.writeValidation, initialBatchSize, this.stripeMetadataSource, hiveFileContext);
    }

    public OrcSelectiveRecordReader createSelectiveRecordReader(Map<Integer, Type> includedColumns, List<Integer> outputColumns, Map<Integer, Map<Subfield, TupleDomainFilter>> filters, List<FilterFunction> filterFunctions, Map<Integer, Integer> filterFunctionInputs, Map<Integer, List<Subfield>> requiredSubfields, Map<Integer, Object> constantValues, Map<Integer, Function<Block, Block>> coercers, OrcPredicate predicate, long offset, long length, DateTimeZone hiveStorageTimeZone, boolean legacyMapSubscript, AggregatedMemoryContext systemMemoryUsage, Optional<OrcWriteValidation> writeValidation, int initialBatchSize, HiveFileContext hiveFileContext) {
        return new OrcSelectiveRecordReader(includedColumns, outputColumns, filters, filterFunctions, filterFunctionInputs, requiredSubfields, constantValues, coercers, predicate, this.footer.getNumberOfRows(), this.footer.getStripes(), this.footer.getFileStats(), this.metadata.getStripeStatsList(), this.orcDataSource, offset, length, this.footer.getTypes(), this.decompressor, this.footer.getRowsInRowGroup(), hiveStorageTimeZone, legacyMapSubscript, this.hiveWriterVersion, this.metadataReader, this.orcReaderOptions.getMaxMergeDistance(), this.orcReaderOptions.getTinyStripeThreshold(), this.orcReaderOptions.getMaxBlockSize(), this.footer.getUserMetadata(), systemMemoryUsage.newAggregatedMemoryContext(), writeValidation, initialBatchSize, this.stripeMetadataSource, hiveFileContext);
    }

    private static OrcDataSource wrapWithCacheIfTiny(OrcDataSource dataSource, DataSize maxCacheSize) {
        if (dataSource instanceof CachingOrcDataSource) {
            return dataSource;
        }
        if (dataSource.getSize() > maxCacheSize.toBytes()) {
            return dataSource;
        }
        DiskRange diskRange = new DiskRange(0L, Math.toIntExact(dataSource.getSize()));
        return new CachingOrcDataSource(dataSource, desiredOffset -> diskRange);
    }

    static void validateFile(OrcWriteValidation writeValidation, OrcDataSource input, List<Type> types, DateTimeZone hiveStorageTimeZone, OrcEncoding orcEncoding, OrcReaderOptions orcReaderOptions) throws OrcCorruptionException {
        ImmutableMap.Builder readTypes = ImmutableMap.builder();
        for (int columnIndex = 0; columnIndex < types.size(); ++columnIndex) {
            readTypes.put((Object)columnIndex, (Object)types.get(columnIndex));
        }
        try {
            OrcReader orcReader = new OrcReader(input, orcEncoding, new StorageOrcFileTailSource(), new StorageStripeMetadataSource(), Optional.of(writeValidation), orcReaderOptions, HiveFileContext.DEFAULT_HIVE_FILE_CONTEXT);
            try (OrcBatchRecordReader orcRecordReader = orcReader.createBatchRecordReader((Map<Integer, Type>)readTypes.build(), OrcPredicate.TRUE, hiveStorageTimeZone, AggregatedMemoryContext.newSimpleAggregatedMemoryContext(), 1, HiveFileContext.DEFAULT_HIVE_FILE_CONTEXT);){
                while (orcRecordReader.nextBatch() >= 0) {
                }
            }
        }
        catch (IOException e) {
            throw new OrcCorruptionException(e, input.getId(), "Validation failed", new Object[0]);
        }
    }

    public static void validateWrite(Optional<OrcWriteValidation> writeValidation, OrcDataSource orcDataSource, Predicate<OrcWriteValidation> test, String messageFormat, Object ... args) throws OrcCorruptionException {
        if (writeValidation.isPresent() && !test.test(writeValidation.get())) {
            throw new OrcCorruptionException(orcDataSource.getId(), "Write validation failed: " + messageFormat, args);
        }
    }
}

