/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.reader;

import com.facebook.presto.memory.context.LocalMemoryContext;
import com.facebook.presto.orc.StreamDescriptor;
import com.facebook.presto.orc.TupleDomainFilter;
import com.facebook.presto.orc.reader.AbstractDecimalSelectiveStreamReader;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.Int128ArrayBlock;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.UnscaledDecimal128Arithmetic;
import io.airlift.slice.Slice;
import io.airlift.slice.UnsafeSlice;
import java.io.IOException;
import java.util.Optional;

public class LongDecimalSelectiveStreamReader
extends AbstractDecimalSelectiveStreamReader {
    public LongDecimalSelectiveStreamReader(StreamDescriptor streamDescriptor, Optional<TupleDomainFilter> filter, Optional<Type> outputType, LocalMemoryContext systemMemoryContext) {
        super(streamDescriptor, filter, outputType, systemMemoryContext, 2);
    }

    @Override
    protected int readNoFilter(int[] positions, int positionCount) throws IOException {
        Slice decimal = UnscaledDecimal128Arithmetic.unscaledDecimal();
        Slice rescaledDecimal = UnscaledDecimal128Arithmetic.unscaledDecimal();
        int streamPosition = 0;
        for (int i = 0; i < positionCount; ++i) {
            int position = positions[i];
            if (position > streamPosition) {
                this.skip(position - streamPosition);
                streamPosition = position;
            }
            if (this.presentStream != null && !this.presentStream.nextBit()) {
                this.nulls[i] = true;
            } else {
                int scale = (int)this.scaleStream.next();
                this.dataStream.nextLongDecimal(decimal);
                UnscaledDecimal128Arithmetic.rescale((Slice)decimal, (int)(this.scale - scale), (Slice)rescaledDecimal);
                this.values[2 * i] = UnsafeSlice.getLongUnchecked((Slice)rescaledDecimal, (int)0);
                this.values[2 * i + 1] = UnsafeSlice.getLongUnchecked((Slice)rescaledDecimal, (int)8);
                if (this.presentStream != null) {
                    this.nulls[i] = false;
                }
            }
            ++streamPosition;
        }
        this.outputPositionCount = positionCount;
        return streamPosition;
    }

    @Override
    protected int readWithFilter(int[] positions, int positionCount) throws IOException {
        int streamPosition = 0;
        this.outputPositionCount = 0;
        Slice decimal = UnscaledDecimal128Arithmetic.unscaledDecimal();
        Slice rescaledDecimal = UnscaledDecimal128Arithmetic.unscaledDecimal();
        for (int i = 0; i < positionCount; ++i) {
            int position = positions[i];
            if (position > streamPosition) {
                this.skip(position - streamPosition);
                streamPosition = position;
            }
            if (this.presentStream != null && !this.presentStream.nextBit()) {
                if (this.nonDeterministicFilter && this.filter.testNull() || this.nullsAllowed) {
                    if (this.outputRequired) {
                        this.nulls[this.outputPositionCount] = true;
                    }
                    this.outputPositions[this.outputPositionCount] = position;
                    ++this.outputPositionCount;
                }
            } else {
                int scale = (int)this.scaleStream.next();
                this.dataStream.nextLongDecimal(decimal);
                UnscaledDecimal128Arithmetic.rescale((Slice)decimal, (int)(this.scale - scale), (Slice)rescaledDecimal);
                long low = UnsafeSlice.getLongUnchecked((Slice)rescaledDecimal, (int)0);
                long high = UnsafeSlice.getLongUnchecked((Slice)rescaledDecimal, (int)8);
                if (this.filter.testDecimal(low, high)) {
                    if (this.outputRequired) {
                        this.values[2 * this.outputPositionCount] = low;
                        this.values[2 * this.outputPositionCount + 1] = high;
                        if (this.nullsAllowed && this.presentStream != null) {
                            this.nulls[this.outputPositionCount] = false;
                        }
                    }
                    this.outputPositions[this.outputPositionCount] = position;
                    ++this.outputPositionCount;
                }
            }
            ++streamPosition;
            if (this.filter == null) continue;
            this.outputPositionCount -= this.filter.getPrecedingPositionsToFail();
            int succeedingPositionsToFail = this.filter.getSucceedingPositionsToFail();
            if (succeedingPositionsToFail <= 0) continue;
            int positionsToSkip = 0;
            for (int j = 0; j < succeedingPositionsToFail; ++j) {
                int nextPosition = positions[++i];
                positionsToSkip += 1 + nextPosition - streamPosition;
                streamPosition = nextPosition + 1;
            }
            this.skip(positionsToSkip);
        }
        return streamPosition;
    }

    @Override
    protected void copyValues(int[] positions, int positionsCount, long[] valuesCopy, boolean[] nullsCopy) {
        int positionIndex = 0;
        int nextPosition = positions[positionIndex];
        for (int i = 0; i < this.outputPositionCount; ++i) {
            if (this.outputPositions[i] < nextPosition) continue;
            assert (this.outputPositions[i] == nextPosition);
            valuesCopy[2 * positionIndex] = this.values[2 * i];
            valuesCopy[2 * positionIndex + 1] = this.values[2 * i + 1];
            if (nullsCopy != null) {
                nullsCopy[positionIndex] = this.nulls[i];
            }
            if (++positionIndex >= positionsCount) break;
            nextPosition = positions[positionIndex];
        }
    }

    @Override
    protected void compactValues(int[] positions, int positionCount, boolean compactNulls) {
        int positionIndex = 0;
        int nextPosition = positions[positionIndex];
        for (int i = 0; i < this.outputPositionCount; ++i) {
            if (this.outputPositions[i] < nextPosition) continue;
            assert (this.outputPositions[i] == nextPosition);
            this.values[2 * positionIndex] = this.values[2 * i];
            this.values[2 * positionIndex + 1] = this.values[2 * i + 1];
            if (compactNulls) {
                this.nulls[positionIndex] = this.nulls[i];
            }
            this.outputPositions[positionIndex] = nextPosition;
            if (++positionIndex >= positionCount) break;
            nextPosition = positions[positionIndex];
        }
        this.outputPositionCount = positionCount;
    }

    @Override
    protected Block makeBlock(int positionCount, boolean includeNulls, boolean[] nulls, long[] values) {
        return new Int128ArrayBlock(positionCount, Optional.ofNullable((boolean[])(includeNulls ? nulls : null)), values);
    }
}

