/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.reader;

import com.facebook.presto.memory.context.LocalMemoryContext;
import com.facebook.presto.orc.StreamDescriptor;
import com.facebook.presto.orc.TupleDomainFilter;
import com.facebook.presto.orc.metadata.ColumnEncoding;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.reader.AbstractLongSelectiveStreamReader;
import com.facebook.presto.orc.reader.SelectiveStreamReaders;
import com.facebook.presto.orc.stream.BooleanInputStream;
import com.facebook.presto.orc.stream.InputStreamSource;
import com.facebook.presto.orc.stream.InputStreamSources;
import com.facebook.presto.orc.stream.LongInputStream;
import com.facebook.presto.orc.stream.MissingInputStreamSource;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockLease;
import com.facebook.presto.spi.block.ClosingBlockLease;
import com.facebook.presto.spi.block.RunLengthEncodedBlock;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import io.airlift.slice.SizeOf;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.openjdk.jol.info.ClassLayout;

public class LongDirectSelectiveStreamReader
extends AbstractLongSelectiveStreamReader {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(LongDirectSelectiveStreamReader.class).instanceSize();
    private final StreamDescriptor streamDescriptor;
    @Nullable
    private final TupleDomainFilter filter;
    private final boolean nonDeterministicFilter;
    private final boolean nullsAllowed;
    private InputStreamSource<BooleanInputStream> presentStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
    @Nullable
    private BooleanInputStream presentStream;
    private InputStreamSource<LongInputStream> dataStreamSource = MissingInputStreamSource.missingStreamSource(LongInputStream.class);
    @Nullable
    private LongInputStream dataStream;
    private boolean rowGroupOpen;
    private int readOffset;
    private boolean allNulls;
    private LocalMemoryContext systemMemoryContext;

    public LongDirectSelectiveStreamReader(StreamDescriptor streamDescriptor, Optional<TupleDomainFilter> filter, Optional<Type> outputType, LocalMemoryContext systemMemoryContext) {
        super(outputType);
        Objects.requireNonNull(filter, "filter is null");
        Preconditions.checkArgument((filter.isPresent() || this.outputRequired ? 1 : 0) != 0, (Object)"filter must be present if output is not required");
        this.streamDescriptor = Objects.requireNonNull(streamDescriptor, "streamDescriptor is null");
        this.filter = filter.orElse(null);
        this.systemMemoryContext = Objects.requireNonNull(systemMemoryContext, "systemMemoryContext is null");
        this.nonDeterministicFilter = this.filter != null && !this.filter.isDeterministic();
        this.nullsAllowed = this.filter == null || this.nonDeterministicFilter || this.filter.testNull();
    }

    @Override
    public int read(int offset, int[] positions, int positionCount) throws IOException {
        Preconditions.checkArgument((positionCount > 0 ? 1 : 0) != 0, (Object)"positionCount must be greater than zero");
        if (!this.rowGroupOpen) {
            this.openRowGroup();
        }
        this.prepareNextRead(positionCount, this.nullsAllowed && this.presentStream != null);
        this.allNulls = false;
        this.outputPositions = SelectiveStreamReaders.initializeOutputPositions(this.outputPositions, positions, positionCount);
        this.systemMemoryContext.setBytes(this.getRetainedSizeInBytes());
        if (this.readOffset < offset) {
            this.skip(offset - this.readOffset);
        }
        this.outputPositionCount = 0;
        int streamPosition = this.dataStream == null && this.presentStream != null ? this.readAllNulls(positions, positionCount) : (this.filter == null ? this.readNoFilter(positions, positionCount) : this.readWithFilter(positions, positionCount));
        this.readOffset = offset + streamPosition;
        return this.outputPositionCount;
    }

    private int readAllNulls(int[] positions, int positionCount) throws IOException {
        this.presentStream.skip(positions[positionCount - 1]);
        if (this.nonDeterministicFilter) {
            this.outputPositionCount = 0;
            for (int i = 0; i < positionCount; ++i) {
                if (this.filter.testNull()) {
                    ++this.outputPositionCount;
                    continue;
                }
                this.outputPositionCount -= this.filter.getPrecedingPositionsToFail();
                i += this.filter.getSucceedingPositionsToFail();
            }
        } else {
            this.outputPositionCount = this.nullsAllowed ? positionCount : 0;
        }
        this.allNulls = true;
        return positions[positionCount - 1] + 1;
    }

    private int readNoFilter(int[] positions, int positionCount) throws IOException {
        if (positions[positionCount - 1] == positionCount - 1) {
            if (this.presentStream != null) {
                int nullCount = this.presentStream.getUnsetBits(positionCount, this.nulls);
                if (nullCount == positionCount) {
                    this.allNulls = true;
                } else {
                    for (int i = 0; i < positionCount; ++i) {
                        this.values[i] = this.nulls[i] ? 0L : this.dataStream.next();
                    }
                }
            } else {
                for (int i = 0; i < positionCount; ++i) {
                    this.values[i] = this.dataStream.next();
                }
            }
            this.outputPositionCount = positionCount;
            return positionCount;
        }
        int streamPosition = 0;
        for (int i = 0; i < positionCount; ++i) {
            int position = positions[i];
            if (position > streamPosition) {
                this.skip(position - streamPosition);
                streamPosition = position;
            }
            if (this.presentStream != null && !this.presentStream.nextBit()) {
                this.nulls[i] = true;
                this.values[i] = 0L;
            } else {
                this.values[i] = this.dataStream.next();
                if (this.presentStream != null) {
                    this.nulls[i] = false;
                }
            }
            ++streamPosition;
        }
        this.outputPositionCount = positionCount;
        return streamPosition;
    }

    private int readWithFilter(int[] positions, int positionCount) throws IOException {
        if (positions[positionCount - 1] == positionCount - 1 && this.presentStream == null && !this.outputRequired && !this.filter.isPositionalFilter()) {
            for (int i = 0; i < positionCount; ++i) {
                long value = this.dataStream.next();
                if (!this.filter.testLong(value)) continue;
                this.outputPositions[this.outputPositionCount] = positions[i];
                ++this.outputPositionCount;
            }
            return positionCount;
        }
        int streamPosition = 0;
        for (int i = 0; i < positionCount; ++i) {
            int position = positions[i];
            if (position > streamPosition) {
                this.skip(position - streamPosition);
                streamPosition = position;
            }
            if (this.presentStream != null && !this.presentStream.nextBit()) {
                if (this.nonDeterministicFilter && this.filter.testNull() || this.nullsAllowed) {
                    if (this.outputRequired) {
                        this.nulls[this.outputPositionCount] = true;
                        this.values[this.outputPositionCount] = 0L;
                    }
                    this.outputPositions[this.outputPositionCount] = position;
                    ++this.outputPositionCount;
                }
            } else {
                long value = this.dataStream.next();
                if (this.filter.testLong(value)) {
                    if (this.outputRequired) {
                        this.values[this.outputPositionCount] = value;
                        if (this.nullsAllowed && this.presentStream != null) {
                            this.nulls[this.outputPositionCount] = false;
                        }
                    }
                    this.outputPositions[this.outputPositionCount] = position;
                    ++this.outputPositionCount;
                }
            }
            ++streamPosition;
            this.outputPositionCount -= this.filter.getPrecedingPositionsToFail();
            int succeedingPositionsToFail = this.filter.getSucceedingPositionsToFail();
            if (succeedingPositionsToFail <= 0) continue;
            int positionsToSkip = 0;
            for (int j = 0; j < succeedingPositionsToFail; ++j) {
                int nextPosition = positions[++i];
                positionsToSkip += 1 + nextPosition - streamPosition;
                streamPosition = nextPosition + 1;
            }
            this.skip(positionsToSkip);
        }
        return streamPosition;
    }

    private void skip(int items) throws IOException {
        if (this.dataStream == null) {
            this.presentStream.skip(items);
        } else if (this.presentStream != null) {
            int dataToSkip = this.presentStream.countBitsSet(items);
            this.dataStream.skip(dataToSkip);
        } else {
            this.dataStream.skip(items);
        }
    }

    private void openRowGroup() throws IOException {
        this.presentStream = this.presentStreamSource.openStream();
        this.dataStream = this.dataStreamSource.openStream();
        this.rowGroupOpen = true;
    }

    @Override
    public Block getBlock(int[] positions, int positionCount) {
        Preconditions.checkArgument((this.outputPositionCount > 0 ? 1 : 0) != 0, (Object)"outputPositionCount must be greater than zero");
        Preconditions.checkState((boolean)this.outputRequired, (Object)"This stream reader doesn't produce output");
        Preconditions.checkState((positionCount <= this.outputPositionCount ? 1 : 0) != 0, (Object)"Not enough values");
        if (this.allNulls) {
            return new RunLengthEncodedBlock(this.outputType.createBlockBuilder(null, 1).appendNull().build(), positionCount);
        }
        return this.buildOutputBlock(positions, positionCount, this.nullsAllowed && this.presentStream != null);
    }

    @Override
    public BlockLease getBlockView(int[] positions, int positionCount) {
        Preconditions.checkArgument((this.outputPositionCount > 0 ? 1 : 0) != 0, (Object)"outputPositionCount must be greater than zero");
        Preconditions.checkState((boolean)this.outputRequired, (Object)"This stream reader doesn't produce output");
        Preconditions.checkState((positionCount <= this.outputPositionCount ? 1 : 0) != 0, (Object)"Not enough values");
        if (this.allNulls) {
            return ClosingBlockLease.newLease((Block)new RunLengthEncodedBlock(this.outputType.createBlockBuilder(null, 1).appendNull().build(), positionCount), (ClosingBlockLease.Closer[])new ClosingBlockLease.Closer[0]);
        }
        return this.buildOutputBlockView(positions, positionCount, this.nullsAllowed && this.presentStream != null);
    }

    @Override
    public void startStripe(InputStreamSources dictionaryStreamSources, List<ColumnEncoding> encoding) {
        this.presentStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
        this.dataStreamSource = MissingInputStreamSource.missingStreamSource(LongInputStream.class);
        this.readOffset = 0;
        this.presentStream = null;
        this.dataStream = null;
        this.rowGroupOpen = false;
    }

    @Override
    public void startRowGroup(InputStreamSources dataStreamSources) {
        this.presentStreamSource = dataStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.PRESENT, BooleanInputStream.class);
        this.dataStreamSource = dataStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.DATA, LongInputStream.class);
        this.readOffset = 0;
        this.presentStream = null;
        this.dataStream = null;
        this.rowGroupOpen = false;
    }

    @Override
    public void close() {
        this.systemMemoryContext.close();
    }

    @Override
    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.sizeOf((long[])this.values) + SizeOf.sizeOf((boolean[])this.nulls) + SizeOf.sizeOf((int[])this.outputPositions);
    }
}

