/*
 * Decompiled with CFR 0.152.
 */
package xerial.core.log;

import java.lang.management.ManagementFactory;
import javax.management.InstanceAlreadyExistsException;
import javax.management.JMX;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Symbol;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.mutable.StringBuilder;
import scala.collection.mutable.WeakHashMap;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import sun.management.ConnectorAddressLink;
import xerial.core.log.ConsoleLogWriter;
import xerial.core.log.LogLevel;
import xerial.core.log.LogLevel$;
import xerial.core.log.LogWriter;
import xerial.core.log.LoggerConfig;
import xerial.core.log.LoggerConfigImpl;

public final class LoggerFactory$ {
    public static final LoggerFactory$ MODULE$;
    private LogLevel defaultLogLevel;
    private final String rootLoggerName;
    private final ConsoleLogWriter rootLogger;
    private final WeakHashMap<String, LogWriter> loggerHolder;
    private final ObjectName configMBeanName;

    static {
        new LoggerFactory$();
    }

    public LogLevel defaultLogLevel() {
        return this.defaultLogLevel;
    }

    public void defaultLogLevel_$eq(LogLevel x$1) {
        this.defaultLogLevel = x$1;
    }

    private String rootLoggerName() {
        return this.rootLoggerName;
    }

    public ConsoleLogWriter rootLogger() {
        return this.rootLogger;
    }

    private WeakHashMap<String, LogWriter> loggerHolder() {
        return this.loggerHolder;
    }

    public LogWriter apply(Class<?> cl) {
        return this.getLogger(cl.getName());
    }

    public LogWriter apply(String name) {
        return this.getLogger(name);
    }

    public LogWriter apply(LogWriter logger, Symbol symbol) {
        return this.getLogger(new StringBuilder().append((Object)logger.name()).append((Object)":").append((Object)symbol.name()).toString());
    }

    public LogWriter apply(Class<?> cl, Symbol symbol) {
        return this.apply(this.apply(cl), symbol);
    }

    public LogLevel getDefaultLogLevel(String loggerName) {
        Seq l = (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{loggerName, this.leafName(loggerName)}))).$plus$plus((GenTraversableOnce)this.parents$1(loggerName), Seq$.MODULE$.canBuildFrom());
        Option ll = ((TraversableLike)((TraversableLike)l.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String x) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"loglevel:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{x}));
            }
        }, Seq$.MODULE$.canBuildFrom())).flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Iterable<String> apply(String k) {
                return Option$.MODULE$.option2Iterable(LoggerFactory$.MODULE$.xerial$core$log$LoggerFactory$$property$1(k).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(String prop) {
                        return prop;
                    }
                }));
            }
        }, Seq$.MODULE$.canBuildFrom())).headOption();
        return (LogLevel)ll.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final LogLevel apply(String x$2) {
                return LogLevel$.MODULE$.apply(x$2);
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final LogLevel apply() {
                return LoggerFactory$.MODULE$.defaultLogLevel();
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private LogWriter getLogger(String name) {
        Object object;
        LogWriter logWriter;
        if (name.isEmpty()) {
            logWriter = this.rootLogger();
            return logWriter;
        }
        LoggerFactory$ loggerFactory$ = this;
        synchronized (loggerFactory$) {
            LogLevel dl = this.getDefaultLogLevel(name);
            object = this.loggerHolder().getOrElseUpdate((Object)name, (Function0)new Serializable(name, dl){
                public static final long serialVersionUID = 0L;
                private final String name$1;
                private final LogLevel dl$1;

                public final ConsoleLogWriter apply() {
                    return new ConsoleLogWriter(this.name$1, this.dl$1);
                }
                {
                    this.name$1 = name$1;
                    this.dl$1 = dl$1;
                }
            });
        }
        logWriter = (LogWriter)object;
        return logWriter;
    }

    public String leafName(String name) {
        return (String)Predef$.MODULE$.refArrayOps((Object[])name.split("[\\.]")).last();
    }

    private ObjectName configMBeanName() {
        return this.configMBeanName;
    }

    public void setLogLevelJMX(String loggerName, String logLevel) {
        LoggerConfig lc = JMX.newMBeanProxy(ManagementFactory.getPlatformMBeanServer(), this.configMBeanName(), LoggerConfig.class, true);
        lc.setLogLevel(loggerName, logLevel);
    }

    public void setLogLevelJMX(MBeanServerConnection server, String loggerName, String logLevel) {
        LoggerConfig lc = JMX.newMBeanProxy(server, this.configMBeanName(), LoggerConfig.class, true);
        lc.setLogLevel(loggerName, logLevel);
        this.rootLogger().debug((Function0<Object>)new Serializable(loggerName, logLevel){
            public static final long serialVersionUID = 0L;
            private final String loggerName$2;
            private final String logLevel$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Set the loglevel of ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.loggerName$2, this.logLevel$1}));
            }
            {
                this.loggerName$2 = loggerName$2;
                this.logLevel$1 = logLevel$1;
            }
        });
    }

    public void setDefaultLogLevelJMX(MBeanServerConnection server, String logLevel) {
        LoggerConfig lc = JMX.newMBeanProxy(server, this.configMBeanName(), LoggerConfig.class, true);
        lc.setDefaultLogLevel(logLevel);
        this.rootLogger().debug((Function0<Object>)new Serializable(logLevel){
            public static final long serialVersionUID = 0L;
            private final String logLevel$2;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Set the default loglevel to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.logLevel$2}));
            }
            {
                this.logLevel$2 = logLevel$2;
            }
        });
    }

    public Option<String> getJMXServerAddress(int pid) {
        return Option$.MODULE$.apply((Object)ConnectorAddressLink.importFrom((int)pid));
    }

    /*
     * WARNING - void declaration
     */
    private Option<MBeanServerConnection> getJMXServer(int pid) {
        void var3_3;
        this.rootLogger().info((Function0<Object>)new Serializable(pid){
            public static final long serialVersionUID = 0L;
            private final int pid$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Searching for JMX server pid:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.pid$1)}));
            }
            {
                this.pid$1 = pid$1;
            }
        });
        Option<String> addr = this.getJMXServerAddress(pid);
        Option server = addr.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JMXConnector apply(String a) {
                return JMXConnectorFactory.connect(new JMXServiceURL(a));
            }
        }).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final MBeanServerConnection apply(JMXConnector x$3) {
                return x$3.getMBeanServerConnection();
            }
        });
        if (server.isEmpty()) {
            this.rootLogger().warn((Function0<Object>)new Serializable(pid){
                public static final long serialVersionUID = 0L;
                private final int pid$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No JMX server (pid:", ") is found"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.pid$1)}));
                }
                {
                    this.pid$1 = pid$1;
                }
            });
        } else {
            this.rootLogger().info((Function0<Object>)new Serializable(pid){
                public static final long serialVersionUID = 0L;
                private final int pid$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found a JMX server (pid:", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.pid$1)}));
                }
                {
                    this.pid$1 = pid$1;
                }
            });
            this.rootLogger().debug((Function0<Object>)new Serializable(addr){
                public static final long serialVersionUID = 0L;
                private final Option addr$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Server address: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.addr$1.get()}));
                }
                {
                    this.addr$1 = addr$1;
                }
            });
        }
        return var3_3;
    }

    public void setLogLevel(int pid, String loggerName, String logLevel) {
        this.getJMXServer(pid).foreach((Function1)new Serializable(loggerName, logLevel){
            public static final long serialVersionUID = 0L;
            private final String loggerName$3;
            private final String logLevel$3;

            public final void apply(MBeanServerConnection server) {
                LoggerFactory$.MODULE$.setLogLevelJMX(server, this.loggerName$3, this.logLevel$3);
            }
            {
                this.loggerName$3 = loggerName$3;
                this.logLevel$3 = logLevel$3;
            }
        });
    }

    public void setDefaultLogLevel(int pid, String logLevel) {
        this.getJMXServer(pid).foreach((Function1)new Serializable(logLevel){
            public static final long serialVersionUID = 0L;
            private final String logLevel$4;

            public final void apply(MBeanServerConnection server) {
                LoggerFactory$.MODULE$.setDefaultLogLevelJMX(server, this.logLevel$4);
            }
            {
                this.logLevel$4 = logLevel$4;
            }
        });
    }

    public void setDefaultLogLevel(LogLevel logLevel) {
        System.setProperty("loglevel", logLevel.name());
        this.defaultLogLevel_$eq(logLevel);
        this.rootLogger().debug((Function0<Object>)new Serializable(logLevel){
            public static final long serialVersionUID = 0L;
            private final LogLevel logLevel$5;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Set the default log level to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.logLevel$5}));
            }
            {
                this.logLevel$5 = logLevel$5;
            }
        });
    }

    public LogLevel getDefaultLogLevel() {
        return this.defaultLogLevel();
    }

    public final Option xerial$core$log$LoggerFactory$$property$1(String key) {
        return Option$.MODULE$.apply((Object)System.getProperty(key));
    }

    private final Seq parents$1(String loggerName$1) {
        String[] c = loggerName$1.split("\\.");
        IndexedSeq p = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), c.length).map((Function1)new Serializable(c){
            public static final long serialVersionUID = 0L;
            private final String[] c$1;

            public final String apply(int i) {
                return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.c$1).take(i)).mkString(".");
            }
            {
                this.c$1 = c$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        return (Seq)p.reverse();
    }

    private final Option property$2(String key) {
        return Option$.MODULE$.apply((Object)System.getProperty(key));
    }

    private LoggerFactory$() {
        Object object;
        MODULE$ = this;
        this.defaultLogLevel = LogLevel$.MODULE$.apply(System.getProperty("loglevel", "info"));
        this.rootLoggerName = "root";
        this.rootLogger = new ConsoleLogWriter(this.rootLoggerName(), this.defaultLogLevel());
        this.loggerHolder = new WeakHashMap();
        this.configMBeanName = new ObjectName("xerial.core.util:type=LoggerConfig");
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        try {
            object = server.isRegistered(this.configMBeanName()) ? BoxedUnit.UNIT : server.registerMBean(new LoggerConfigImpl(), this.configMBeanName());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            object = BoxedUnit.UNIT;
        }
        catch (InstanceAlreadyExistsException instanceAlreadyExistsException) {
            object = BoxedUnit.UNIT;
        }
    }
}

