/*
 * Decompiled with CFR 0.152.
 */
package xerial.core.util;

import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Field;
import java.util.Map;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Symbol;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.collection.mutable.WeakHashMap;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.sys.process.Process$;
import scala.sys.process.ProcessLogger$;
import scala.util.matching.Regex;
import xerial.core.log.LogLevel;
import xerial.core.log.LogWriter;
import xerial.core.log.Logger;
import xerial.core.log.Logger$class;
import xerial.core.util.CommandLineTokenizer$;
import xerial.core.util.OS$;
import xerial.core.util.OSType;
import xerial.core.util.Shell$;

public final class Shell$
implements Logger {
    public static final Shell$ MODULE$;
    private final WeakHashMap<String, Option<String>> cmdPathCache;

    static {
        new Shell$();
    }

    @Override
    public void log(LogLevel logLevel, Function0<Object> message) {
        Logger$class.log((Logger)this, logLevel, message);
    }

    @Override
    public LogWriter getLogger(Symbol tag) {
        return Logger$class.getLogger((Logger)this, tag);
    }

    @Override
    public LogWriter getLogger(String tag) {
        return Logger$class.getLogger((Logger)this, tag);
    }

    @Override
    public <U> void log(String tag, Function1<LogWriter, U> f) {
        Logger$class.log((Logger)this, tag, f);
    }

    @Override
    public void fatal(Function0<Object> message) {
        Logger$class.fatal(this, message);
    }

    @Override
    public void error(Function0<Object> message) {
        Logger$class.error(this, message);
    }

    @Override
    public void warn(Function0<Object> message) {
        Logger$class.warn(this, message);
    }

    @Override
    public void info(Function0<Object> message) {
        Logger$class.info(this, message);
    }

    @Override
    public void debug(Function0<Object> message) {
        Logger$class.debug(this, message);
    }

    @Override
    public void trace(Function0<Object> message) {
        Logger$class.trace(this, message);
    }

    private <U> U access(Field f, Function0<U> body) {
        boolean a = f.isAccessible();
        try {
            if (!a) {
                f.setAccessible(true);
            }
            return (U)body.apply();
        }
        finally {
            if (!a) {
                f.setAccessible(a);
            }
        }
    }

    public int kill(int pid, String signal) {
        Process p = this.launchProcess(new StringOps(Predef$.MODULE$.augmentString("kill -%s %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{signal, BoxesRunTime.boxToInteger((int)pid)})));
        p.waitFor();
        int exitCode = p.exitValue();
        this.debug((Function0<Object>)new Serializable(pid, exitCode){
            public static final long serialVersionUID = 0L;
            private final int pid$1;
            private final int exitCode$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"killed process ", " with exit code ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.pid$1), BoxesRunTime.boxToInteger((int)this.exitCode$1)}));
            }
            {
                this.pid$1 = pid$1;
                this.exitCode$1 = exitCode$1;
            }
        });
        return exitCode;
    }

    public String kill$default$2() {
        return "TERM";
    }

    public int killTree(int pid, String signal) {
        int arg$1 = pid;
        this.exec(new StringOps(Predef$.MODULE$.augmentString("kill -STOP %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)arg$1)})));
        ProcessBuilder pb = this.prepareProcessBuilder(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ps -o pid --no-headers --ppid ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)pid)})), true);
        Process$.MODULE$.apply(pb).lines_$bang().foreach((Function1)new Serializable(signal){
            public static final long serialVersionUID = 0L;
            private final String signal$1;

            public final int apply(String line) {
                int childPID = new StringOps(Predef$.MODULE$.augmentString(line.trim())).toInt();
                return Shell$.MODULE$.killTree(childPID, this.signal$1);
            }
            {
                this.signal$1 = signal$1;
            }
        });
        this.exec(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"kill -", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{signal, BoxesRunTime.boxToInteger((int)pid)})));
        return this.exec(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"kill -CONT ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)pid)})));
    }

    public String killTree$default$2() {
        return "TERM";
    }

    public String escape(String s) {
        Regex r = new StringOps(Predef$.MODULE$.augmentString("([^\\\\])(\\\")")).r();
        StringBuilder b = new StringBuilder();
        IntRef cursor = new IntRef(0);
        r.findAllIn((CharSequence)s).matchData().foreach((Function1)new Serializable(s, b, cursor){
            public static final long serialVersionUID = 0L;
            private final String s$1;
            private final StringBuilder b$1;
            private final IntRef cursor$1;

            public final void apply(Regex.Match m) {
                this.b$1.append(this.s$1.substring(this.cursor$1.elem, m.start()));
                this.b$1.append(m.group(2));
                this.cursor$1.elem = m.end();
            }
            {
                this.s$1 = s$1;
                this.b$1 = b$1;
                this.cursor$1 = cursor$1;
            }
        });
        b.append(s.substring(cursor.elem));
        return b.result();
    }

    public String unescape(String s) {
        Regex r = new StringOps(Predef$.MODULE$.augmentString("(\\\\)([\\\\/\\\\\"bfnrt])")).r();
        StringBuilder b = new StringBuilder();
        IntRef cursor = new IntRef(0);
        r.findAllIn((CharSequence)s).matchData().foreach((Function1)new Serializable(s, b, cursor){
            public static final long serialVersionUID = 0L;
            private final String s$2;
            private final StringBuilder b$2;
            private final IntRef cursor$2;

            public final void apply(Regex.Match m) {
                this.b$2.append(this.s$2.substring(this.cursor$2.elem, m.start()));
                this.b$2.append(m.group(2));
                this.cursor$2.elem = m.end();
            }
            {
                this.s$2 = s$2;
                this.b$2 = b$2;
                this.cursor$2 = cursor$2;
            }
        });
        b.append(s.substring(cursor.elem));
        return b.result();
    }

    public void launchRemoteDaemon(String host, String cmdLine) {
        this.execRemote(host, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " < /dev/null > /dev/null &"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{cmdLine})));
    }

    public int getProcessIDOfCurrentJVM() {
        RuntimeMXBean r = ManagementFactory.getRuntimeMXBean();
        String n = r.getName();
        return BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.refArrayOps((Object[])n.split("@")).headOption().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(String x$1) {
                return new StringOps(Predef$.MODULE$.augmentString(x$1)).toInt();
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return -1;
            }
        }));
    }

    public int getProcessID(Process p) {
        int n;
        try {
            int pid;
            Field f = p.getClass().getDeclaredField("pid");
            n = pid = BoxesRunTime.unboxToInt(this.access(f, (Function0)new Serializable(p, f){
                public static final long serialVersionUID = 0L;
                private final Process p$2;
                private final Field f$1;

                public final int apply() {
                    return this.apply$mcI$sp();
                }

                public int apply$mcI$sp() {
                    return BoxesRunTime.unboxToInt((Object)this.f$1.get(this.p$2));
                }
                {
                    this.p$2 = p$2;
                    this.f$1 = f$1;
                }
            }));
        }
        catch (Throwable throwable) {
            n = -1;
        }
        return n;
    }

    public Process launchJava(String args) {
        Option<String> javaCmd = this.findJavaCommand(this.findJavaCommand$default$1());
        if (javaCmd.isEmpty()) {
            throw new IllegalStateException("No JVM is found. Set JAVA_HOME environmental variable");
        }
        String cmdLine = new StringOps(Predef$.MODULE$.augmentString("%s %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{javaCmd.get(), args}));
        return this.launchProcess(cmdLine);
    }

    /*
     * WARNING - void declaration
     */
    public int exec(String cmdLine) {
        void var3_3;
        ProcessBuilder pb = this.prepareProcessBuilder(cmdLine, true);
        int exitCode = Process$.MODULE$.apply(pb).$bang(ProcessLogger$.MODULE$.apply((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(String out) {
                Shell$.MODULE$.info((Function0<Object>)new Serializable(this, out){
                    public static final long serialVersionUID = 0L;
                    private final String out$1;

                    public final String apply() {
                        return this.out$1;
                    }
                    {
                        this.out$1 = out$1;
                    }
                });
            }
        }));
        this.debug((Function0<Object>)new Serializable(cmdLine, exitCode){
            public static final long serialVersionUID = 0L;
            private final String cmdLine$2;
            private final int exitCode$2;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"exec command ", " with exitCode:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.cmdLine$2, BoxesRunTime.boxToInteger((int)this.exitCode$2)}));
            }
            {
                this.cmdLine$2 = cmdLine$2;
                this.exitCode$2 = exitCode$2;
            }
        });
        return (int)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public Process launchProcess(String cmdLine) {
        void var3_3;
        ProcessBuilder pb = this.prepareProcessBuilder(cmdLine, true);
        Process p = pb.start();
        this.debug((Function0<Object>)new Serializable(pb, p){
            public static final long serialVersionUID = 0L;
            private final ProcessBuilder pb$1;
            private final Process p$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"exec command [pid:", "] ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)Shell$.MODULE$.getProcessID(this.p$1)), JavaConversions$.MODULE$.asScalaBuffer(this.pb$1.command()).mkString(" ")}));
            }
            {
                this.pb$1 = pb$1;
                this.p$1 = p$1;
            }
        });
        return var3_3;
    }

    public int execRemote(String hostname, String cmdLine) {
        ProcessBuilder pb = this.prepareProcessBuilderFromSeq((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ssh", hostname, this.quote(cmdLine)}))), true);
        int exitCode = Process$.MODULE$.apply(pb).$bang(ProcessLogger$.MODULE$.apply((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(String out) {
                Shell$.MODULE$.info((Function0<Object>)new Serializable(this, out){
                    public static final long serialVersionUID = 0L;
                    private final String out$2;

                    public final String apply() {
                        return this.out$2;
                    }
                    {
                        this.out$2 = out$2;
                    }
                });
            }
        }));
        this.debug((Function0<Object>)new Serializable(cmdLine, exitCode){
            public static final long serialVersionUID = 0L;
            private final String cmdLine$3;
            private final int exitCode$3;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"exec command ", " with exitCode:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.cmdLine$3, BoxesRunTime.boxToInteger((int)this.exitCode$3)}));
            }
            {
                this.cmdLine$3 = cmdLine$3;
                this.exitCode$3 = exitCode$3;
            }
        });
        return exitCode;
    }

    private String quote(String s) {
        return s.replaceAll("\\\"", "\\\\\"");
    }

    public ProcessBuilder prepareProcessBuilder(String cmdLine, boolean inheritIO) {
        this.trace((Function0<Object>)new Serializable(cmdLine){
            public static final long serialVersionUID = 0L;
            private final String cmdLine$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cmdLine: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.cmdLine$1}));
            }
            {
                this.cmdLine$1 = cmdLine$1;
            }
        });
        String[] tokens2 = (String[])((Object[])new String[]{this.getCommand("sh"), "-c", OS$.MODULE$.isWindows() ? this.quote(cmdLine) : cmdLine});
        return this.prepareProcessBuilderFromSeq((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])tokens2), inheritIO);
    }

    /*
     * WARNING - void declaration
     */
    public ProcessBuilder prepareProcessBuilderFromSeq(Seq<String> tokens2, boolean inheritIO) {
        void var3_3;
        this.trace((Function0<Object>)new Serializable(tokens2){
            public static final long serialVersionUID = 0L;
            private final Seq tokens$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"command line tokens: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tokens$1.mkString(", ")}));
            }
            {
                this.tokens$1 = tokens$1;
            }
        });
        ProcessBuilder pb = new ProcessBuilder((String[])tokens2.toArray(ClassTag$.MODULE$.apply(String.class)));
        Object object = inheritIO ? pb.inheritIO() : BoxedUnit.UNIT;
        scala.collection.immutable.Map env = this.getEnv();
        if (OS$.MODULE$.isWindows()) {
            env = env.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"CYGWIN"), (Object)"notty"));
        }
        Map<String, String> envMap = pb.environment();
        env.foreach((Function1)new Serializable(envMap){
            public static final long serialVersionUID = 0L;
            private final Map envMap$1;

            public final String apply(Tuple2<String, String> e) {
                return (String)this.envMap$1.put(e._1(), e._2());
            }
            {
                this.envMap$1 = envMap$1;
            }
        });
        return var3_3;
    }

    public scala.collection.immutable.Map<String, String> getEnv() {
        return JavaConversions$.MODULE$.mapAsScalaMap(System.getenv()).toMap(Predef$.MODULE$.conforms());
    }

    public scala.sys.process.Process launchCmdExe(String cmdLine) {
        String c = new StringOps(Predef$.MODULE$.augmentString("%s /c \"%s\"")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.getCommand("cmd"), cmdLine}));
        this.debug((Function0<Object>)new Serializable(c){
            public static final long serialVersionUID = 0L;
            private final String c$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"exec command: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.c$1}));
            }
            {
                this.c$1 = c$1;
            }
        });
        return Process$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])CommandLineTokenizer$.MODULE$.tokenize(c)), (Option)None$.MODULE$, this.getEnv().toSeq()).run();
    }

    private WeakHashMap<String, Option<String>> cmdPathCache() {
        return this.cmdPathCache;
    }

    public String getCommand(String name) {
        Option<String> option = this.findCommand(name);
        if (option instanceof Some) {
            String cmd;
            Some some = (Some)option;
            String string = cmd = (String)some.x();
            return string;
        }
        None$ none$ = None$.MODULE$;
        Option<String> option2 = option;
        if (!(none$ != null ? !none$.equals(option2) : option2 != null)) {
            throw new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString("CommandTrait not found: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})));
        }
        throw new MatchError(option);
    }

    public Option<String> findSh() {
        return this.findCommand("sh");
    }

    /*
     * WARNING - void declaration
     */
    public String[] getExecPath() {
        void var1_3;
        String string = System.getenv("PATH");
        String string2 = string == null ? "" : string.toString();
        String[] path = string2.split("[;:]");
        return var1_3;
    }

    public String progName(String p) {
        return OS$.MODULE$.isWindows() ? new StringBuilder().append((Object)p).append((Object)".exe").toString() : p;
    }

    public Option<String> findCommand(String name) {
        return (Option)this.cmdPathCache().getOrElseUpdate((Object)name, (Function0)new Serializable(name){
            public static final long serialVersionUID = 0L;
            public final String name$1;

            /*
             * WARNING - void declaration
             */
            public final Option<String> apply() {
                void var3_3;
                String[] path = OS$.MODULE$.isWindows() ? (String[])Predef$.MODULE$.refArrayOps((Object[])Shell$.MODULE$.getExecPath()).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c:/cygwin/bin"})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))) : Shell$.MODULE$.getExecPath();
                String prog = Shell$.MODULE$.progName(this.name$1);
                Option exe = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])path).map((Function1)new Serializable(this, prog){
                    public static final long serialVersionUID = 0L;
                    private final String prog$1;

                    public final File apply(String x$2) {
                        return new File(x$2, this.prog$1);
                    }
                    {
                        this.prog$1 = prog$1;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(File.class)))).find((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(File x$3) {
                        return x$3.exists();
                    }
                }).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(File x$4) {
                        return x$4.getAbsolutePath();
                    }
                });
                Shell$.MODULE$.trace((Function0<Object>)new Serializable(this, exe){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.findCommand.1 $outer;
                    private final Option exe$1;

                    public final String apply() {
                        return this.exe$1.isDefined() ? new StringOps(Predef$.MODULE$.augmentString("%s is found at %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.name$1, this.exe$1.get()})) : new StringOps(Predef$.MODULE$.augmentString("%s is not found")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.name$1}));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.exe$1 = exe$1;
                    }
                });
                return var3_3;
            }
            {
                this.name$1 = name$1;
            }
        });
    }

    public Option<String> sysProp(String key) {
        return Option$.MODULE$.apply((Object)System.getProperty(key));
    }

    public Option<String> env(String key) {
        return Option$.MODULE$.apply((Object)System.getenv(key));
    }

    /*
     * WARNING - void declaration
     */
    public Option<String> findJavaHome() {
        void var2_2;
        Option e = this.env("JAVA_HOME").orElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Option<String> apply() {
                return Shell$.MODULE$.sysProp("java.home");
            }
        });
        Option p = e.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String x$5) {
                return Shell$.MODULE$.xerial$core$util$Shell$$resolveCygpath$1(x$5);
            }
        });
        this.debug((Function0<Object>)new Serializable(p){
            public static final long serialVersionUID = 0L;
            private final Option p$3;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found JAVA_HOME=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.p$3.get()}));
            }
            {
                this.p$3 = p$3;
            }
        });
        return var2_2;
    }

    public Option<String> findJavaCommand(String javaCmdName) {
        return (Option)this.cmdPathCache().getOrElseUpdate((Object)javaCmdName, (Function0)new Serializable(javaCmdName){
            public static final long serialVersionUID = 0L;
            private final String javaCmdName$1;

            public final Option<String> apply() {
                return Shell$.MODULE$.xerial$core$util$Shell$$search$1(this.javaCmdName$1);
            }
            {
                this.javaCmdName$1 = javaCmdName$1;
            }
        });
    }

    public String findJavaCommand$default$1() {
        return "java";
    }

    private Object readResolve() {
        return MODULE$;
    }

    public final String xerial$core$util$Shell$$resolveCygpath$1(String p) {
        Option m;
        return OS$.MODULE$.isWindows() ? ((m = new StringOps(Predef$.MODULE$.augmentString("/cygdrive/(\\w)(/.*)")).r().findFirstMatchIn((CharSequence)p)).isDefined() ? new StringOps(Predef$.MODULE$.augmentString("%s:%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((Regex.MatchData)m.get()).group(1), ((Regex.MatchData)m.get()).group(2)})) : p) : p;
    }

    private final String javaBin$1(String java_home, String javaCmdName$1) {
        return new StringBuilder().append((Object)java_home).append((Object)"/bin/").append((Object)this.progName(javaCmdName$1)).toString();
    }

    public final boolean xerial$core$util$Shell$$hasJavaCommand$1(String java_home, String javaCmdName$1) {
        File java_path = new File(this.javaBin$1(java_home, javaCmdName$1));
        return java_path.exists();
    }

    private final String[] listJDKIn$1(String path, String javaCmdName$1) {
        return (String[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])new File(path).listFiles()).filter((Function1)new Serializable(javaCmdName$1){
            public static final long serialVersionUID = 0L;
            private final String javaCmdName$1;

            public final boolean apply(File x) {
                return x.isDirectory() && (x.getName().startsWith("jdk") || x.getName().startsWith("jre")) && Shell$.MODULE$.xerial$core$util$Shell$$hasJavaCommand$1(x.getAbsolutePath(), this.javaCmdName$1);
            }
            {
                this.javaCmdName$1 = javaCmdName$1;
            }
        })).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(File x$6) {
                return x$6.getAbsolutePath();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
    }

    private final Option latestJDK$1(String[] jdkPath) {
        None$ none$;
        if (Predef$.MODULE$.refArrayOps((Object[])jdkPath).isEmpty()) {
            none$ = None$.MODULE$;
        } else {
            String[] sorted = (String[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])jdkPath).sorted((Ordering)Ordering.String$.MODULE$)).reverse();
            none$ = new Some((Object)sorted[0]);
        }
        return none$;
    }

    public final Option xerial$core$util$Shell$$search$1(String javaCmdName$1) {
        Option option;
        block7: {
            Option option2;
            block10: {
                Some some;
                block9: {
                    block8: {
                        Option java_home;
                        Option option3;
                        block6: {
                            Object object;
                            block5: {
                                Option e = this.findJavaHome();
                                option = e;
                                if (!(option instanceof Some)) break block5;
                                option3 = e;
                                break block6;
                            }
                            None$ none$ = None$.MODULE$;
                            Option option4 = option;
                            if (none$ != null ? !none$.equals(option4) : option4 != null) break block7;
                            this.debug((Function0<Object>)new Serializable(){
                                public static final long serialVersionUID = 0L;

                                public final String apply() {
                                    return "No java command found. Searching for JDK...";
                                }
                            });
                            OSType oSType = OS$.MODULE$.getType();
                            OSType oSType2 = OSType.Windows;
                            OSType oSType3 = oSType;
                            if (!(oSType2 != null ? !((Object)((Object)oSType2)).equals((Object)oSType3) : oSType3 != null)) {
                                object = this.latestJDK$1(this.listJDKIn$1("c:/Program Files/Java", javaCmdName$1));
                            } else {
                                Seq l;
                                OSType oSType4 = OSType.Mac;
                                OSType oSType5 = oSType;
                                object = !(oSType4 != null ? !((Object)((Object)oSType4)).equals((Object)oSType5) : oSType5 != null) ? ((l = (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"/System/Library/Frameworkds/JavaVM.framework/Home", "/System/Library/Frameworkds/JavaVM.framework/Versions/CurrentJDK/Home"}))).filter((Function1)new Serializable(javaCmdName$1){
                                    public static final long serialVersionUID = 0L;
                                    private final String javaCmdName$1;

                                    public final boolean apply(String java_home) {
                                        return Shell$.MODULE$.xerial$core$util$Shell$$hasJavaCommand$1(java_home, this.javaCmdName$1);
                                    }
                                    {
                                        this.javaCmdName$1 = javaCmdName$1;
                                    }
                                })).isEmpty() ? None$.MODULE$ : new Some(l.apply(0))) : None$.MODULE$;
                            }
                            option3 = object;
                        }
                        option2 = java_home = option3;
                        if (!(option2 instanceof Some)) break block8;
                        Some some2 = (Some)option2;
                        String x = (String)some2.x();
                        some = new Some((Object)this.javaBin$1(x, javaCmdName$1).trim());
                        break block9;
                    }
                    None$ none$ = None$.MODULE$;
                    Option option5 = option2;
                    if (none$ != null ? !none$.equals(option5) : option5 != null) break block10;
                    String javaPath = Process$.MODULE$.apply(new StringOps(Predef$.MODULE$.augmentString("which %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{javaCmdName$1}))).$bang$bang().trim();
                    some = javaPath.isEmpty() ? None$.MODULE$ : new Some((Object)javaPath);
                }
                Some ret = some;
                return ret;
            }
            throw new MatchError(option2);
        }
        throw new MatchError(option);
    }

    private Shell$() {
        MODULE$ = this;
        Logger$class.$init$(this);
        this.cmdPathCache = new WeakHashMap();
    }
}

