/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.Session;
import com.facebook.presto.execution.NodeTaskMap;
import com.facebook.presto.execution.QueryStateMachine;
import com.facebook.presto.execution.RemoteTask;
import com.facebook.presto.execution.RemoteTaskFactory;
import com.facebook.presto.execution.StateMachine;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.execution.TaskState;
import com.facebook.presto.execution.TaskStatus;
import com.facebook.presto.execution.buffer.OutputBuffers;
import com.facebook.presto.execution.scheduler.TableWriteInfo;
import com.facebook.presto.metadata.InternalNode;
import com.facebook.presto.metadata.Split;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.sql.planner.PlanFragment;
import com.google.common.collect.Multimap;
import java.util.Objects;

public class TrackingRemoteTaskFactory
implements RemoteTaskFactory {
    private final RemoteTaskFactory remoteTaskFactory;
    private final QueryStateMachine stateMachine;

    public TrackingRemoteTaskFactory(RemoteTaskFactory remoteTaskFactory, QueryStateMachine stateMachine) {
        this.remoteTaskFactory = Objects.requireNonNull(remoteTaskFactory, "remoteTaskFactory is null");
        this.stateMachine = Objects.requireNonNull(stateMachine, "stateMachine is null");
    }

    @Override
    public RemoteTask createRemoteTask(Session session, TaskId taskId, InternalNode node, PlanFragment fragment, Multimap<PlanNodeId, Split> initialSplits, OutputBuffers outputBuffers, NodeTaskMap.PartitionedSplitCountTracker partitionedSplitCountTracker, boolean summarizeTaskInfo, TableWriteInfo tableWriteInfo) {
        RemoteTask task = this.remoteTaskFactory.createRemoteTask(session, taskId, node, fragment, initialSplits, outputBuffers, partitionedSplitCountTracker, summarizeTaskInfo, tableWriteInfo);
        task.addStateChangeListener(new UpdateQueryStats(this.stateMachine));
        return task;
    }

    private static final class UpdateQueryStats
    implements StateMachine.StateChangeListener<TaskStatus> {
        private final QueryStateMachine stateMachine;
        private long previousUserMemory;
        private long previousSystemMemory;
        private TaskState state;

        public UpdateQueryStats(QueryStateMachine stateMachine) {
            this.stateMachine = stateMachine;
            this.state = TaskState.PLANNED;
        }

        @Override
        public synchronized void stateChanged(TaskStatus newStatus) {
            long currentUserMemory = newStatus.getMemoryReservation().toBytes();
            long currentSystemMemory = newStatus.getSystemMemoryReservation().toBytes();
            long currentTotalMemory = currentUserMemory + currentSystemMemory;
            long deltaUserMemoryInBytes = currentUserMemory - this.previousUserMemory;
            long deltaTotalMemoryInBytes = currentTotalMemory - (this.previousUserMemory + this.previousSystemMemory);
            this.previousUserMemory = currentUserMemory;
            this.previousSystemMemory = currentSystemMemory;
            this.stateMachine.updateMemoryUsage(deltaUserMemoryInBytes, deltaTotalMemoryInBytes, currentUserMemory, currentTotalMemory);
            if (this.state == TaskState.PLANNED && newStatus.getState() == TaskState.RUNNING) {
                this.stateMachine.incrementCurrentRunningTaskCount();
            } else if (this.state == TaskState.RUNNING && newStatus.getState().isDone()) {
                this.stateMachine.decrementCurrentRunningTaskCount();
            }
            this.state = newStatus.getState();
        }
    }
}

