/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.executor;

import com.facebook.airlift.concurrent.SetThreadName;
import com.facebook.airlift.concurrent.ThreadPoolExecutorMBean;
import com.facebook.airlift.concurrent.Threads;
import com.facebook.airlift.log.Logger;
import com.facebook.airlift.stats.CounterStat;
import com.facebook.airlift.stats.TimeDistribution;
import com.facebook.airlift.stats.TimeStat;
import com.facebook.presto.execution.SplitRunner;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.execution.TaskManagerConfig;
import com.facebook.presto.execution.executor.MultilevelSplitQueue;
import com.facebook.presto.execution.executor.PrioritizedSplitRunner;
import com.facebook.presto.execution.executor.TaskHandle;
import com.facebook.presto.execution.executor.TaskPriorityTracker;
import com.facebook.presto.server.ServerConfig;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.util.MoreMath;
import com.facebook.presto.version.EmbedVersion;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Ticker;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.units.Duration;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.function.DoubleSupplier;
import java.util.function.Function;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import javax.inject.Inject;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

@ThreadSafe
public class TaskExecutor {
    private static final Logger log = Logger.get(TaskExecutor.class);
    private static final Duration LONG_SPLIT_WARNING_THRESHOLD = new Duration(600.0, TimeUnit.SECONDS);
    private static final AtomicLong NEXT_RUNNER_ID = new AtomicLong();
    private final ExecutorService executor;
    private final ThreadPoolExecutorMBean executorMBean;
    private final int runnerThreads;
    private final int minimumNumberOfDrivers;
    private final int guaranteedNumberOfDriversPerTask;
    private final int maximumNumberOfDriversPerTask;
    private final EmbedVersion embedVersion;
    private final Ticker ticker;
    private final ScheduledExecutorService splitMonitorExecutor = Executors.newSingleThreadScheduledExecutor(Threads.daemonThreadsNamed((String)"TaskExecutor"));
    private final SortedSet<RunningSplitInfo> runningSplitInfos = new ConcurrentSkipListSet<RunningSplitInfo>();
    @GuardedBy(value="this")
    private final List<TaskHandle> tasks;
    @GuardedBy(value="this")
    private final Set<PrioritizedSplitRunner> allSplits = new HashSet<PrioritizedSplitRunner>();
    @GuardedBy(value="this")
    private final Set<PrioritizedSplitRunner> intermediateSplits = new HashSet<PrioritizedSplitRunner>();
    private final MultilevelSplitQueue waitingSplits;
    private final Function<QueryId, TaskPriorityTracker> taskPriorityTrackerFactory;
    private final Set<PrioritizedSplitRunner> runningSplits = Sets.newConcurrentHashSet();
    private final Map<PrioritizedSplitRunner, Future<?>> blockedSplits = new ConcurrentHashMap();
    private final AtomicLongArray completedTasksPerLevel = new AtomicLongArray(5);
    private final AtomicLongArray completedSplitsPerLevel = new AtomicLongArray(5);
    private final TimeStat splitQueuedTime = new TimeStat(TimeUnit.NANOSECONDS);
    private final TimeStat splitWallTime = new TimeStat(TimeUnit.NANOSECONDS);
    private final TimeDistribution leafSplitWallTime = new TimeDistribution(TimeUnit.MICROSECONDS);
    private final TimeDistribution intermediateSplitWallTime = new TimeDistribution(TimeUnit.MICROSECONDS);
    private final TimeDistribution leafSplitScheduledTime = new TimeDistribution(TimeUnit.MICROSECONDS);
    private final TimeDistribution intermediateSplitScheduledTime = new TimeDistribution(TimeUnit.MICROSECONDS);
    private final TimeDistribution leafSplitWaitTime = new TimeDistribution(TimeUnit.MICROSECONDS);
    private final TimeDistribution intermediateSplitWaitTime = new TimeDistribution(TimeUnit.MICROSECONDS);
    private final TimeDistribution leafSplitCpuTime = new TimeDistribution(TimeUnit.MICROSECONDS);
    private final TimeDistribution intermediateSplitCpuTime = new TimeDistribution(TimeUnit.MICROSECONDS);
    private final CounterStat globalCpuTimeMicros = new CounterStat();
    private final CounterStat globalScheduledTimeMicros = new CounterStat();
    private final TimeStat blockedQuantaWallTime = new TimeStat(TimeUnit.MICROSECONDS);
    private final TimeStat unblockedQuantaWallTime = new TimeStat(TimeUnit.MICROSECONDS);
    private volatile boolean closed;

    @Inject
    public TaskExecutor(TaskManagerConfig config, EmbedVersion embedVersion, MultilevelSplitQueue splitQueue) {
        this(Objects.requireNonNull(config, "config is null").getMaxWorkerThreads(), config.getMinDrivers(), config.getMinDriversPerTask(), config.getMaxDriversPerTask(), config.getTaskPriorityTracking(), embedVersion, splitQueue, Ticker.systemTicker());
    }

    @VisibleForTesting
    public TaskExecutor(int runnerThreads, int minDrivers, int guaranteedNumberOfDriversPerTask, int maximumNumberOfDriversPerTask, TaskManagerConfig.TaskPriorityTracking taskPriorityTracking, Ticker ticker) {
        this(runnerThreads, minDrivers, guaranteedNumberOfDriversPerTask, maximumNumberOfDriversPerTask, taskPriorityTracking, new EmbedVersion(new ServerConfig()), new MultilevelSplitQueue(2.0), ticker);
    }

    @VisibleForTesting
    public TaskExecutor(int runnerThreads, int minDrivers, int guaranteedNumberOfDriversPerTask, int maximumNumberOfDriversPerTask, TaskManagerConfig.TaskPriorityTracking taskPriorityTracking, MultilevelSplitQueue splitQueue, Ticker ticker) {
        this(runnerThreads, minDrivers, guaranteedNumberOfDriversPerTask, maximumNumberOfDriversPerTask, taskPriorityTracking, new EmbedVersion(new ServerConfig()), splitQueue, ticker);
    }

    @VisibleForTesting
    public TaskExecutor(int runnerThreads, int minDrivers, int guaranteedNumberOfDriversPerTask, int maximumNumberOfDriversPerTask, TaskManagerConfig.TaskPriorityTracking taskPriorityTracking, EmbedVersion embedVersion, MultilevelSplitQueue splitQueue, Ticker ticker) {
        Function<QueryId, TaskPriorityTracker> taskPriorityTrackerFactory;
        Preconditions.checkArgument((runnerThreads > 0 ? 1 : 0) != 0, (Object)"runnerThreads must be at least 1");
        Preconditions.checkArgument((guaranteedNumberOfDriversPerTask > 0 ? 1 : 0) != 0, (Object)"guaranteedNumberOfDriversPerTask must be at least 1");
        Preconditions.checkArgument((maximumNumberOfDriversPerTask > 0 ? 1 : 0) != 0, (Object)"maximumNumberOfDriversPerTask must be at least 1");
        Preconditions.checkArgument((guaranteedNumberOfDriversPerTask <= maximumNumberOfDriversPerTask ? 1 : 0) != 0, (Object)"guaranteedNumberOfDriversPerTask cannot be greater than maximumNumberOfDriversPerTask");
        this.executor = Executors.newCachedThreadPool(Threads.threadsNamed((String)"task-processor-%s"));
        this.executorMBean = new ThreadPoolExecutorMBean((ThreadPoolExecutor)this.executor);
        this.runnerThreads = runnerThreads;
        this.embedVersion = Objects.requireNonNull(embedVersion, "embedVersion is null");
        this.ticker = Objects.requireNonNull(ticker, "ticker is null");
        this.minimumNumberOfDrivers = minDrivers;
        this.guaranteedNumberOfDriversPerTask = guaranteedNumberOfDriversPerTask;
        this.maximumNumberOfDriversPerTask = maximumNumberOfDriversPerTask;
        this.waitingSplits = Objects.requireNonNull(splitQueue, "splitQueue is null");
        switch (taskPriorityTracking) {
            case TASK_FAIR: {
                taskPriorityTrackerFactory = queryId -> new TaskPriorityTracker(splitQueue);
                break;
            }
            case QUERY_FAIR: {
                LoadingCache cache = CacheBuilder.newBuilder().weakValues().build(CacheLoader.from(queryId -> new TaskPriorityTracker(splitQueue)));
                taskPriorityTrackerFactory = arg_0 -> ((LoadingCache)cache).getUnchecked(arg_0);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected taskPriorityTracking: " + (Object)((Object)taskPriorityTracking));
            }
        }
        this.taskPriorityTrackerFactory = taskPriorityTrackerFactory;
        this.tasks = new LinkedList<TaskHandle>();
    }

    @PostConstruct
    public synchronized void start() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"TaskExecutor is closed");
        for (int i = 0; i < this.runnerThreads; ++i) {
            this.addRunnerThread();
        }
    }

    @PreDestroy
    public synchronized void stop() {
        this.closed = true;
        this.executor.shutdownNow();
        this.splitMonitorExecutor.shutdownNow();
    }

    public synchronized String toString() {
        return MoreObjects.toStringHelper((Object)this).add("runnerThreads", this.runnerThreads).add("allSplits", this.allSplits.size()).add("intermediateSplits", this.intermediateSplits.size()).add("waitingSplits", this.waitingSplits.size()).add("runningSplits", this.runningSplits.size()).add("blockedSplits", this.blockedSplits.size()).toString();
    }

    private synchronized void addRunnerThread() {
        try {
            this.executor.execute(this.embedVersion.embedVersion(new TaskRunner()));
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    public synchronized TaskHandle addTask(TaskId taskId, DoubleSupplier utilizationSupplier, int initialSplitConcurrency, Duration splitConcurrencyAdjustFrequency, OptionalInt maxDriversPerTask) {
        Objects.requireNonNull(taskId, "taskId is null");
        Objects.requireNonNull(utilizationSupplier, "utilizationSupplier is null");
        Preconditions.checkArgument((!maxDriversPerTask.isPresent() || maxDriversPerTask.getAsInt() <= this.maximumNumberOfDriversPerTask ? 1 : 0) != 0, (Object)"maxDriversPerTask cannot be greater than the configured value");
        log.debug("Task scheduled " + taskId);
        TaskHandle taskHandle = new TaskHandle(taskId, this.taskPriorityTrackerFactory.apply(taskId.getQueryId()), utilizationSupplier, initialSplitConcurrency, splitConcurrencyAdjustFrequency, maxDriversPerTask);
        this.tasks.add(taskHandle);
        return taskHandle;
    }

    public void removeTask(TaskHandle taskHandle) {
        try (SetThreadName ignored = new SetThreadName("Task-%s", new Object[]{taskHandle.getTaskId()});){
            this.doRemoveTask(taskHandle);
        }
        this.addNewEntrants();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRemoveTask(TaskHandle taskHandle) {
        List<PrioritizedSplitRunner> splits;
        TaskExecutor taskExecutor = this;
        synchronized (taskExecutor) {
            this.tasks.remove(taskHandle);
            splits = taskHandle.destroy();
            this.allSplits.removeAll(splits);
            this.intermediateSplits.removeAll(splits);
            this.blockedSplits.keySet().removeAll(splits);
            this.waitingSplits.removeAll(splits);
        }
        for (PrioritizedSplitRunner split : splits) {
            split.destroy();
        }
        long threadUsageNanos = taskHandle.getScheduledNanos();
        this.completedTasksPerLevel.incrementAndGet(MultilevelSplitQueue.computeLevel(threadUsageNanos));
        log.debug("Task finished or failed " + taskHandle.getTaskId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ListenableFuture<?>> enqueueSplits(TaskHandle taskHandle, boolean intermediate, List<? extends SplitRunner> taskSplits) {
        ArrayList<PrioritizedSplitRunner> splitsToDestroy = new ArrayList<PrioritizedSplitRunner>();
        ArrayList finishedFutures = new ArrayList(taskSplits.size());
        TaskExecutor taskExecutor = this;
        synchronized (taskExecutor) {
            for (SplitRunner splitRunner : taskSplits) {
                PrioritizedSplitRunner prioritizedSplitRunner = new PrioritizedSplitRunner(taskHandle, splitRunner, this.ticker, this.globalCpuTimeMicros, this.globalScheduledTimeMicros, this.blockedQuantaWallTime, this.unblockedQuantaWallTime);
                if (taskHandle.isDestroyed()) {
                    splitsToDestroy.add(prioritizedSplitRunner);
                } else if (intermediate) {
                    this.startIntermediateSplit(prioritizedSplitRunner);
                    taskHandle.recordIntermediateSplit(prioritizedSplitRunner);
                } else {
                    taskHandle.enqueueSplit(prioritizedSplitRunner);
                    this.scheduleTaskIfNecessary(taskHandle);
                    this.addNewEntrants();
                }
                finishedFutures.add(prioritizedSplitRunner.getFinishedFuture());
            }
        }
        for (PrioritizedSplitRunner split : splitsToDestroy) {
            split.destroy();
        }
        return finishedFutures;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void splitFinished(PrioritizedSplitRunner split) {
        this.completedSplitsPerLevel.incrementAndGet(split.getPriority().getLevel());
        TaskExecutor taskExecutor = this;
        synchronized (taskExecutor) {
            this.allSplits.remove(split);
            long wallNanos = System.nanoTime() - split.getCreatedNanos();
            this.splitWallTime.add(Duration.succinctNanos((long)wallNanos));
            if (this.intermediateSplits.remove(split)) {
                this.intermediateSplitWallTime.add(wallNanos);
                this.intermediateSplitScheduledTime.add(split.getScheduledNanos());
                this.intermediateSplitWaitTime.add(split.getWaitNanos());
                this.intermediateSplitCpuTime.add(split.getCpuTimeNanos());
            } else {
                this.leafSplitWallTime.add(wallNanos);
                this.leafSplitScheduledTime.add(split.getScheduledNanos());
                this.leafSplitWaitTime.add(split.getWaitNanos());
                this.leafSplitCpuTime.add(split.getCpuTimeNanos());
            }
            TaskHandle taskHandle = split.getTaskHandle();
            taskHandle.splitComplete(split);
            this.scheduleTaskIfNecessary(taskHandle);
            this.addNewEntrants();
        }
        split.destroy();
    }

    private synchronized void scheduleTaskIfNecessary(TaskHandle taskHandle) {
        PrioritizedSplitRunner split;
        double[] dArray = new double[]{this.guaranteedNumberOfDriversPerTask, taskHandle.getMaxDriversPerTask().orElse(Integer.MAX_VALUE)};
        if ((double)taskHandle.getRunningLeafSplits() < MoreMath.min(dArray) && (split = taskHandle.pollNextSplit()) != null) {
            this.startSplit(split);
            this.splitQueuedTime.add(Duration.nanosSince((long)split.getCreatedNanos()));
        }
    }

    private synchronized void addNewEntrants() {
        PrioritizedSplitRunner split;
        int running = this.allSplits.size() - this.intermediateSplits.size();
        for (int i = 0; i < this.minimumNumberOfDrivers - running && (split = this.pollNextSplitWorker()) != null; ++i) {
            this.splitQueuedTime.add(Duration.nanosSince((long)split.getCreatedNanos()));
            this.startSplit(split);
        }
    }

    private synchronized void startIntermediateSplit(PrioritizedSplitRunner split) {
        this.startSplit(split);
        this.intermediateSplits.add(split);
    }

    private synchronized void startSplit(PrioritizedSplitRunner split) {
        this.allSplits.add(split);
        this.waitingSplits.offer(split);
    }

    private synchronized PrioritizedSplitRunner pollNextSplitWorker() {
        Iterator<TaskHandle> iterator = this.tasks.iterator();
        while (iterator.hasNext()) {
            PrioritizedSplitRunner split;
            TaskHandle task = iterator.next();
            if (task.getRunningLeafSplits() >= task.getMaxDriversPerTask().orElse(this.maximumNumberOfDriversPerTask) || (split = task.pollNextSplit()) == null) continue;
            iterator.remove();
            this.tasks.add(task);
            return split;
        }
        return null;
    }

    @Managed
    public synchronized int getTasks() {
        return this.tasks.size();
    }

    @Managed
    public int getRunnerThreads() {
        return this.runnerThreads;
    }

    @Managed
    public int getMinimumNumberOfDrivers() {
        return this.minimumNumberOfDrivers;
    }

    @Managed
    public synchronized int getTotalSplits() {
        return this.allSplits.size();
    }

    @Managed
    public synchronized int getIntermediateSplits() {
        return this.intermediateSplits.size();
    }

    @Managed
    public int getWaitingSplits() {
        return this.waitingSplits.size();
    }

    @Managed
    public int getRunningSplits() {
        return this.runningSplits.size();
    }

    @Managed
    public int getBlockedSplits() {
        return this.blockedSplits.size();
    }

    @Managed
    public long getCompletedTasksLevel0() {
        return this.completedTasksPerLevel.get(0);
    }

    @Managed
    public long getCompletedTasksLevel1() {
        return this.completedTasksPerLevel.get(1);
    }

    @Managed
    public long getCompletedTasksLevel2() {
        return this.completedTasksPerLevel.get(2);
    }

    @Managed
    public long getCompletedTasksLevel3() {
        return this.completedTasksPerLevel.get(3);
    }

    @Managed
    public long getCompletedTasksLevel4() {
        return this.completedTasksPerLevel.get(4);
    }

    @Managed
    public long getCompletedSplitsLevel0() {
        return this.completedSplitsPerLevel.get(0);
    }

    @Managed
    public long getCompletedSplitsLevel1() {
        return this.completedSplitsPerLevel.get(1);
    }

    @Managed
    public long getCompletedSplitsLevel2() {
        return this.completedSplitsPerLevel.get(2);
    }

    @Managed
    public long getCompletedSplitsLevel3() {
        return this.completedSplitsPerLevel.get(3);
    }

    @Managed
    public long getCompletedSplitsLevel4() {
        return this.completedSplitsPerLevel.get(4);
    }

    @Managed
    public long getRunningTasksLevel0() {
        return this.getRunningTasksForLevel(0);
    }

    @Managed
    public long getRunningTasksLevel1() {
        return this.getRunningTasksForLevel(1);
    }

    @Managed
    public long getRunningTasksLevel2() {
        return this.getRunningTasksForLevel(2);
    }

    @Managed
    public long getRunningTasksLevel3() {
        return this.getRunningTasksForLevel(3);
    }

    @Managed
    public long getRunningTasksLevel4() {
        return this.getRunningTasksForLevel(4);
    }

    @Managed
    @Nested
    public TimeStat getSplitQueuedTime() {
        return this.splitQueuedTime;
    }

    @Managed
    @Nested
    public TimeStat getSplitWallTime() {
        return this.splitWallTime;
    }

    @Managed
    @Nested
    public TimeStat getBlockedQuantaWallTime() {
        return this.blockedQuantaWallTime;
    }

    @Managed
    @Nested
    public TimeStat getUnblockedQuantaWallTime() {
        return this.unblockedQuantaWallTime;
    }

    @Managed
    @Nested
    public TimeDistribution getLeafSplitScheduledTime() {
        return this.leafSplitScheduledTime;
    }

    @Managed
    @Nested
    public TimeDistribution getIntermediateSplitScheduledTime() {
        return this.intermediateSplitScheduledTime;
    }

    @Managed
    @Nested
    public TimeDistribution getLeafSplitWallTime() {
        return this.leafSplitWallTime;
    }

    @Managed
    @Nested
    public TimeDistribution getIntermediateSplitWallTime() {
        return this.intermediateSplitWallTime;
    }

    @Managed
    @Nested
    public TimeDistribution getLeafSplitWaitTime() {
        return this.leafSplitWaitTime;
    }

    @Managed
    @Nested
    public TimeDistribution getIntermediateSplitWaitTime() {
        return this.intermediateSplitWaitTime;
    }

    @Managed
    @Nested
    public TimeDistribution getLeafSplitCpuTime() {
        return this.leafSplitCpuTime;
    }

    @Managed
    @Nested
    public TimeDistribution getIntermediateSplitCpuTime() {
        return this.intermediateSplitCpuTime;
    }

    @Managed
    @Nested
    public CounterStat getGlobalScheduledTimeMicros() {
        return this.globalScheduledTimeMicros;
    }

    @Managed
    @Nested
    public CounterStat getGlobalCpuTimeMicros() {
        return this.globalCpuTimeMicros;
    }

    private synchronized int getRunningTasksForLevel(int level) {
        int count = 0;
        for (TaskHandle task : this.tasks) {
            if (task.getPriority().getLevel() != level) continue;
            ++count;
        }
        return count;
    }

    public String getMaxActiveSplitsInfo() {
        StringBuilder stackTrace = new StringBuilder();
        int maxActiveSplitCount = 0;
        String message = "%s splits have been continuously active for more than %s seconds\n";
        for (RunningSplitInfo splitInfo : this.runningSplitInfos) {
            Duration duration = Duration.succinctNanos((long)(this.ticker.read() - splitInfo.getStartTime()));
            if (duration.compareTo(LONG_SPLIT_WARNING_THRESHOLD) < 0) continue;
            ++maxActiveSplitCount;
            stackTrace.append("\n");
            stackTrace.append(String.format("\"%s\" tid=%s", splitInfo.getThreadId(), splitInfo.getThread().getId())).append("\n");
            for (StackTraceElement traceElement : splitInfo.getThread().getStackTrace()) {
                stackTrace.append("\tat ").append(traceElement).append("\n");
            }
        }
        return String.format(message, maxActiveSplitCount, LONG_SPLIT_WARNING_THRESHOLD).concat(stackTrace.toString());
    }

    @Managed
    public long getRunAwaySplitCount() {
        int count = 0;
        for (RunningSplitInfo splitInfo : this.runningSplitInfos) {
            Duration duration = Duration.succinctNanos((long)(this.ticker.read() - splitInfo.getStartTime()));
            if (duration.compareTo(LONG_SPLIT_WARNING_THRESHOLD) <= 0) continue;
            ++count;
        }
        return count;
    }

    @Managed(description="Task processor executor")
    @Nested
    public ThreadPoolExecutorMBean getProcessorExecutor() {
        return this.executorMBean;
    }

    static /* synthetic */ AtomicLong access$100() {
        return NEXT_RUNNER_ID;
    }

    private static class RunningSplitInfo
    implements Comparable<RunningSplitInfo> {
        private final long startTime;
        private final String threadId;
        private final Thread thread;
        private boolean printed;

        public RunningSplitInfo(long startTime, String threadId, Thread thread) {
            this.startTime = startTime;
            this.threadId = threadId;
            this.thread = thread;
            this.printed = false;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public String getThreadId() {
            return this.threadId;
        }

        public Thread getThread() {
            return this.thread;
        }

        public boolean isPrinted() {
            return this.printed;
        }

        public void setPrinted() {
            this.printed = true;
        }

        @Override
        public int compareTo(RunningSplitInfo o) {
            return ComparisonChain.start().compare(this.startTime, o.getStartTime()).compare((Comparable)((Object)this.threadId), (Comparable)((Object)o.getThreadId())).result();
        }
    }

    private class TaskRunner
    implements Runnable {
        private final long runnerId = TaskExecutor.access$100().getAndIncrement();

        private TaskRunner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try (SetThreadName runnerName = new SetThreadName("SplitRunner-%s", new Object[]{this.runnerId});){
                while (!TaskExecutor.this.closed) {
                    PrioritizedSplitRunner split;
                    if (Thread.currentThread().isInterrupted()) return;
                    try {
                        split = TaskExecutor.this.waitingSplits.take();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        if (runnerName != null) {
                            if (var2_2 != null) {
                                try {
                                    runnerName.close();
                                }
                                catch (Throwable throwable) {
                                    var2_2.addSuppressed(throwable);
                                }
                            } else {
                                runnerName.close();
                            }
                        }
                        if (TaskExecutor.this.closed) return;
                        TaskExecutor.this.addRunnerThread();
                        return;
                    }
                    String threadId = split.getTaskHandle().getTaskId() + "-" + split.getSplitId();
                    try {
                        SetThreadName splitName = new SetThreadName(threadId, new Object[0]);
                        Throwable throwable = null;
                        try {
                            ListenableFuture<?> blocked;
                            RunningSplitInfo splitInfo = new RunningSplitInfo(TaskExecutor.this.ticker.read(), threadId, Thread.currentThread());
                            TaskExecutor.this.runningSplitInfos.add(splitInfo);
                            TaskExecutor.this.runningSplits.add(split);
                            try {
                                blocked = split.process();
                            }
                            finally {
                                TaskExecutor.this.runningSplitInfos.remove(splitInfo);
                                TaskExecutor.this.runningSplits.remove(split);
                            }
                            if (split.isFinished()) {
                                log.debug("%s is finished", new Object[]{split.getInfo()});
                                TaskExecutor.this.splitFinished(split);
                                continue;
                            }
                            if (blocked.isDone()) {
                                TaskExecutor.this.waitingSplits.offer(split);
                                continue;
                            }
                            TaskExecutor.this.blockedSplits.put(split, blocked);
                            blocked.addListener(() -> {
                                TaskExecutor.this.blockedSplits.remove(split);
                                split.resetLevelPriority();
                                TaskExecutor.this.waitingSplits.offer(split);
                            }, (Executor)TaskExecutor.this.executor);
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (splitName == null) continue;
                            if (throwable != null) {
                                try {
                                    splitName.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            splitName.close();
                        }
                    }
                    catch (Throwable t) {
                        if (!split.isDestroyed()) {
                            if (t instanceof PrestoException) {
                                PrestoException e = (PrestoException)t;
                                log.error("Error processing %s: %s: %s", new Object[]{split.getInfo(), e.getErrorCode().getName(), e.getMessage()});
                            } else {
                                log.error(t, "Error processing %s", new Object[]{split.getInfo()});
                            }
                        }
                        TaskExecutor.this.splitFinished(split);
                    }
                }
                return;
            }
            finally {
                if (!TaskExecutor.this.closed) {
                    TaskExecutor.this.addRunnerThread();
                }
            }
        }
    }
}

