/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.resourceGroups;

import com.facebook.presto.execution.QueryManagerConfig;
import com.facebook.presto.spi.resourceGroups.ResourceGroup;
import com.facebook.presto.spi.resourceGroups.ResourceGroupConfigurationManager;
import com.facebook.presto.spi.resourceGroups.ResourceGroupId;
import com.facebook.presto.spi.resourceGroups.SelectionContext;
import com.facebook.presto.spi.resourceGroups.SelectionCriteria;
import com.google.common.base.Preconditions;
import java.util.Optional;
import javax.inject.Inject;

public class LegacyResourceGroupConfigurationManager
implements ResourceGroupConfigurationManager<VoidContext> {
    private static final ResourceGroupId GLOBAL = new ResourceGroupId("global");
    private final int hardConcurrencyLimit;
    private final int maxQueued;

    @Inject
    public LegacyResourceGroupConfigurationManager(QueryManagerConfig config) {
        this.hardConcurrencyLimit = config.getMaxConcurrentQueries();
        this.maxQueued = config.getMaxQueuedQueries();
    }

    public void configure(ResourceGroup group, SelectionContext<VoidContext> criteria) {
        Preconditions.checkArgument((boolean)group.getId().equals((Object)GLOBAL), (String)"Unexpected resource group: %s", (Object)group.getId());
        group.setMaxQueuedQueries(this.maxQueued);
        group.setHardConcurrencyLimit(this.hardConcurrencyLimit);
    }

    public Optional<SelectionContext<VoidContext>> match(SelectionCriteria criteria) {
        return Optional.of(new SelectionContext(GLOBAL, (Object)VoidContext.NONE));
    }

    static enum VoidContext {
        NONE;

    }
}

