/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.scheduler;

import com.facebook.airlift.concurrent.MoreFutures;
import com.facebook.airlift.concurrent.SetThreadName;
import com.facebook.airlift.http.client.HttpUriBuilder;
import com.facebook.airlift.stats.TimeStat;
import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.execution.BasicStageExecutionStats;
import com.facebook.presto.execution.LocationFactory;
import com.facebook.presto.execution.QueryState;
import com.facebook.presto.execution.QueryStateMachine;
import com.facebook.presto.execution.RemoteTask;
import com.facebook.presto.execution.RemoteTaskFactory;
import com.facebook.presto.execution.SqlStageExecution;
import com.facebook.presto.execution.StageExecutionInfo;
import com.facebook.presto.execution.StageExecutionState;
import com.facebook.presto.execution.StageId;
import com.facebook.presto.execution.StageInfo;
import com.facebook.presto.execution.buffer.OutputBuffers;
import com.facebook.presto.execution.scheduler.ExchangeLocationsConsumer;
import com.facebook.presto.execution.scheduler.ExecutionPolicy;
import com.facebook.presto.execution.scheduler.ExecutionSchedule;
import com.facebook.presto.execution.scheduler.ScheduleResult;
import com.facebook.presto.execution.scheduler.SectionExecutionFactory;
import com.facebook.presto.execution.scheduler.SplitSchedulerStats;
import com.facebook.presto.execution.scheduler.SqlQuerySchedulerInterface;
import com.facebook.presto.execution.scheduler.StageExecutionAndScheduler;
import com.facebook.presto.execution.scheduler.StreamingPlanSection;
import com.facebook.presto.execution.scheduler.StreamingSubPlan;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.sql.planner.PlanFragment;
import com.facebook.presto.sql.planner.SplitSourceFactory;
import com.facebook.presto.sql.planner.SubPlan;
import com.facebook.presto.sql.planner.plan.PlanFragmentId;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import com.google.common.graph.Traverser;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.units.Duration;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;

@Deprecated
public class LegacySqlQueryScheduler
implements SqlQuerySchedulerInterface {
    private final LocationFactory locationFactory;
    private final ExecutionPolicy executionPolicy;
    private final SplitSchedulerStats schedulerStats;
    private final QueryStateMachine queryStateMachine;
    private final SubPlan plan;
    private final StreamingPlanSection sectionedPlan;
    private final StageId rootStageId;
    private final boolean summarizeTaskInfo;
    private final int maxConcurrentMaterializations;
    private final Map<StageId, StageExecutionAndScheduler> stageExecutions;
    private final ExecutorService executor;
    private final AtomicBoolean started = new AtomicBoolean();
    private final AtomicBoolean scheduling = new AtomicBoolean();

    public static LegacySqlQueryScheduler createSqlQueryScheduler(LocationFactory locationFactory, ExecutionPolicy executionPolicy, ExecutorService queryExecutor, SplitSchedulerStats schedulerStats, SectionExecutionFactory sectionExecutionFactory, RemoteTaskFactory remoteTaskFactory, SplitSourceFactory splitSourceFactory, Session session, QueryStateMachine queryStateMachine, SubPlan plan, OutputBuffers rootOutputBuffers, boolean summarizeTaskInfo) {
        LegacySqlQueryScheduler sqlQueryScheduler = new LegacySqlQueryScheduler(locationFactory, executionPolicy, queryExecutor, schedulerStats, sectionExecutionFactory, remoteTaskFactory, splitSourceFactory, session, queryStateMachine, plan, summarizeTaskInfo, rootOutputBuffers);
        sqlQueryScheduler.initialize();
        return sqlQueryScheduler;
    }

    private LegacySqlQueryScheduler(LocationFactory locationFactory, ExecutionPolicy executionPolicy, ExecutorService queryExecutor, SplitSchedulerStats schedulerStats, SectionExecutionFactory sectionExecutionFactory, RemoteTaskFactory remoteTaskFactory, SplitSourceFactory splitSourceFactory, Session session, QueryStateMachine queryStateMachine, SubPlan plan, boolean summarizeTaskInfo, OutputBuffers rootOutputBuffers) {
        this.locationFactory = Objects.requireNonNull(locationFactory, "locationFactory is null");
        this.executionPolicy = Objects.requireNonNull(executionPolicy, "schedulerPolicyFactory is null");
        this.executor = queryExecutor;
        this.schedulerStats = Objects.requireNonNull(schedulerStats, "schedulerStats is null");
        this.queryStateMachine = Objects.requireNonNull(queryStateMachine, "queryStateMachine is null");
        this.plan = Objects.requireNonNull(plan, "plan is null");
        this.sectionedPlan = StreamingPlanSection.extractStreamingSections(plan);
        this.summarizeTaskInfo = summarizeTaskInfo;
        OutputBuffers.OutputBufferId rootBufferId = (OutputBuffers.OutputBufferId)Iterables.getOnlyElement(rootOutputBuffers.getBuffers().keySet());
        List<StageExecutionAndScheduler> stageExecutions = this.createStageExecutions(sectionExecutionFactory, (fragmentId, tasks, noMoreExchangeLocations) -> LegacySqlQueryScheduler.updateQueryOutputLocations(queryStateMachine, rootBufferId, tasks, noMoreExchangeLocations), this.sectionedPlan, Optional.of(new int[1]), rootOutputBuffers, remoteTaskFactory, splitSourceFactory, session);
        this.rootStageId = ((StageExecutionAndScheduler)Iterables.getLast(stageExecutions)).getStageExecution().getStageExecutionId().getStageId();
        this.stageExecutions = (Map)stageExecutions.stream().collect(ImmutableMap.toImmutableMap(execution -> execution.getStageExecution().getStageExecutionId().getStageId(), Function.identity()));
        this.maxConcurrentMaterializations = SystemSessionProperties.getMaxConcurrentMaterializations(session);
    }

    private void initialize() {
        SqlStageExecution rootStage = this.stageExecutions.get(this.rootStageId).getStageExecution();
        rootStage.addStateChangeListener(state -> {
            if (state == StageExecutionState.FINISHED) {
                this.queryStateMachine.transitionToFinishing();
            } else if (state == StageExecutionState.CANCELED) {
                this.queryStateMachine.transitionToCanceled();
            }
        });
        for (StageExecutionAndScheduler stageExecutionInfo : this.stageExecutions.values()) {
            SqlStageExecution stageExecution = stageExecutionInfo.getStageExecution();
            stageExecution.addStateChangeListener(state -> {
                if (this.queryStateMachine.isDone()) {
                    return;
                }
                if (state == StageExecutionState.FAILED) {
                    this.queryStateMachine.transitionToFailed(stageExecution.getStageExecutionInfo().getFailureCause().get().toException());
                } else if (state == StageExecutionState.ABORTED) {
                    this.queryStateMachine.transitionToFailed((Throwable)new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Query stage was aborted"));
                } else if (state == StageExecutionState.FINISHED) {
                    this.startScheduling();
                } else if (this.queryStateMachine.getQueryState() == QueryState.STARTING && stageExecution.hasTasks()) {
                    this.queryStateMachine.transitionToRunning();
                }
            });
            stageExecution.addFinalStageInfoListener(status -> this.queryStateMachine.updateQueryInfo(Optional.of(this.getStageInfo())));
        }
        this.queryStateMachine.addStateChangeListener(newState -> {
            if (newState.isDone()) {
                this.queryStateMachine.updateQueryInfo(Optional.of(this.getStageInfo()));
            }
        });
    }

    private static void updateQueryOutputLocations(QueryStateMachine queryStateMachine, OutputBuffers.OutputBufferId rootBufferId, Set<RemoteTask> tasks, boolean noMoreExchangeLocations) {
        Map bufferLocations = (Map)tasks.stream().collect(ImmutableMap.toImmutableMap(task -> LegacySqlQueryScheduler.getBufferLocation(task, rootBufferId), RemoteTask::getTaskId));
        queryStateMachine.updateOutputLocations(bufferLocations, noMoreExchangeLocations);
    }

    private static URI getBufferLocation(RemoteTask remoteTask, OutputBuffers.OutputBufferId rootBufferId) {
        URI location = remoteTask.getTaskStatus().getSelf();
        return HttpUriBuilder.uriBuilderFrom((URI)location).appendPath("results").appendPath(rootBufferId.toString()).build();
    }

    private List<StageExecutionAndScheduler> createStageExecutions(SectionExecutionFactory sectionExecutionFactory, ExchangeLocationsConsumer locationsConsumer, StreamingPlanSection section, Optional<int[]> bucketToPartition, OutputBuffers outputBuffers, RemoteTaskFactory remoteTaskFactory, SplitSourceFactory splitSourceFactory, Session session) {
        ImmutableList.Builder stages = ImmutableList.builder();
        for (StreamingPlanSection childSection : section.getChildren()) {
            ExchangeLocationsConsumer childLocationsConsumer = (fragmentId, tasks, noMoreExhchangeLocations) -> {};
            stages.addAll(this.createStageExecutions(sectionExecutionFactory, childLocationsConsumer, childSection, Optional.empty(), OutputBuffers.createDiscardingOutputBuffers(), remoteTaskFactory, splitSourceFactory, session));
        }
        List<StageExecutionAndScheduler> sectionStages = sectionExecutionFactory.createSectionExecutions(session, section, locationsConsumer, bucketToPartition, outputBuffers, this.summarizeTaskInfo, remoteTaskFactory, splitSourceFactory, 0).getSectionStages();
        stages.addAll(sectionStages);
        return stages.build();
    }

    @Override
    public void start() {
        if (this.started.compareAndSet(false, true)) {
            this.startScheduling();
        }
    }

    private void startScheduling() {
        Objects.requireNonNull(this.stageExecutions);
        if (this.scheduling.get()) {
            return;
        }
        this.executor.submit(this::schedule);
    }

    private void schedule() {
        if (!this.scheduling.compareAndSet(false, true)) {
            return;
        }
        ArrayList scheduledStageExecutions = new ArrayList();
        try {
            SetThreadName ignored = new SetThreadName("Query-%s", new Object[]{this.queryStateMachine.getQueryId()});
            Object object = null;
            try {
                HashSet<StageId> completedStages = new HashSet<StageId>();
                LinkedList<ExecutionSchedule> sectionExecutionSchedules = new LinkedList<ExecutionSchedule>();
                block34: while (!Thread.currentThread().isInterrupted()) {
                    sectionExecutionSchedules.removeIf(ExecutionSchedule::isFinished);
                    List<StreamingPlanSection> sectionsReadyForExecution = this.getSectionsReadyForExecution();
                    if (sectionsReadyForExecution.isEmpty() && sectionExecutionSchedules.isEmpty()) break;
                    List<List<StageExecutionAndScheduler>> sectionStageExecutions = this.getStageExecutions(sectionsReadyForExecution);
                    sectionStageExecutions.forEach(scheduledStageExecutions::addAll);
                    sectionStageExecutions.stream().map(executionInfos -> (ImmutableList)executionInfos.stream().collect(ImmutableList.toImmutableList())).map(this.executionPolicy::createExecutionSchedule).forEach(sectionExecutionSchedules::add);
                    while (sectionExecutionSchedules.stream().noneMatch(ExecutionSchedule::isFinished)) {
                        Object stageExecutionAndScheduler22;
                        ArrayList blockedStages = new ArrayList();
                        List executionsToSchedule = (List)sectionExecutionSchedules.stream().flatMap(schedule -> schedule.getStagesToSchedule().stream()).collect(ImmutableList.toImmutableList());
                        block36: for (Object stageExecutionAndScheduler22 : executionsToSchedule) {
                            SqlStageExecution sqlStageExecution = ((StageExecutionAndScheduler)stageExecutionAndScheduler22).getStageExecution();
                            StageId stageId = sqlStageExecution.getStageExecutionId().getStageId();
                            sqlStageExecution.beginScheduling();
                            ScheduleResult result = ((StageExecutionAndScheduler)stageExecutionAndScheduler22).getStageScheduler().schedule();
                            if (result.isFinished()) {
                                sqlStageExecution.schedulingComplete();
                            } else if (!result.getBlocked().isDone()) {
                                blockedStages.add(result.getBlocked());
                            }
                            ((StageExecutionAndScheduler)stageExecutionAndScheduler22).getStageLinkage().processScheduleResults(sqlStageExecution.getState(), result.getNewTasks());
                            this.schedulerStats.getSplitsScheduledPerIteration().add((long)result.getSplitsScheduled());
                            if (!result.getBlockedReason().isPresent()) continue;
                            switch (result.getBlockedReason().get()) {
                                case WRITER_SCALING: {
                                    continue block36;
                                }
                                case WAITING_FOR_SOURCE: {
                                    this.schedulerStats.getWaitingForSource().update(1L);
                                    continue block36;
                                }
                                case SPLIT_QUEUES_FULL: {
                                    this.schedulerStats.getSplitQueuesFull().update(1L);
                                    continue block36;
                                }
                                case MIXED_SPLIT_QUEUES_FULL_AND_WAITING_FOR_SOURCE: {
                                    this.schedulerStats.getMixedSplitQueuesFullAndWaitingForSource().update(1L);
                                    continue block36;
                                }
                                case NO_ACTIVE_DRIVER_GROUP: {
                                    this.schedulerStats.getNoActiveDriverGroup().update(1L);
                                    continue block36;
                                }
                            }
                            throw new UnsupportedOperationException("Unknown blocked reason: " + (Object)((Object)result.getBlockedReason().get()));
                        }
                        boolean stageFinishedExecution = false;
                        stageExecutionAndScheduler22 = scheduledStageExecutions.iterator();
                        while (stageExecutionAndScheduler22.hasNext()) {
                            StageExecutionAndScheduler stageExecutionAndScheduler = (StageExecutionAndScheduler)stageExecutionAndScheduler22.next();
                            SqlStageExecution stageExecution = stageExecutionAndScheduler.getStageExecution();
                            StageId stageId = stageExecution.getStageExecutionId().getStageId();
                            if (completedStages.contains(stageId) || !stageExecution.getState().isDone()) continue;
                            stageExecutionAndScheduler.getStageLinkage().processScheduleResults(stageExecution.getState(), (Set<RemoteTask>)ImmutableSet.of());
                            completedStages.add(stageId);
                            stageFinishedExecution = true;
                        }
                        if (stageFinishedExecution) continue block34;
                        if (blockedStages.isEmpty()) continue;
                        Throwable throwable = null;
                        try (TimeStat.BlockTimer timer = this.schedulerStats.getSleepTime().time();){
                            MoreFutures.tryGetFutureValue((Future)MoreFutures.whenAnyComplete(blockedStages), (int)1, (TimeUnit)TimeUnit.SECONDS);
                        }
                        catch (Throwable throwable2) {
                            Throwable throwable3 = throwable2;
                            throw throwable2;
                        }
                        for (ListenableFuture listenableFuture : blockedStages) {
                            listenableFuture.cancel(true);
                        }
                    }
                }
                for (StageExecutionAndScheduler stageExecutionInfo : scheduledStageExecutions) {
                    StageExecutionState state = stageExecutionInfo.getStageExecution().getState();
                    if (state == StageExecutionState.SCHEDULED || state == StageExecutionState.RUNNING || state.isDone()) continue;
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("Scheduling is complete, but stage execution %s is in state %s", new Object[]{stageExecutionInfo.getStageExecution().getStageExecutionId(), state}));
                }
                this.scheduling.set(false);
                if (!this.getSectionsReadyForExecution().isEmpty()) {
                    this.startScheduling();
                }
            }
            catch (Throwable completedStages) {
                object = completedStages;
                throw completedStages;
            }
            finally {
                if (ignored != null) {
                    if (object != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable completedStages) {
                            ((Throwable)object).addSuppressed(completedStages);
                        }
                    } else {
                        ignored.close();
                    }
                }
            }
        }
        catch (Throwable t) {
            this.scheduling.set(false);
            this.queryStateMachine.transitionToFailed(t);
            throw t;
        }
        finally {
            RuntimeException closeError = new RuntimeException();
            for (StageExecutionAndScheduler stageExecutionInfo : scheduledStageExecutions) {
                try {
                    stageExecutionInfo.getStageScheduler().close();
                }
                catch (Throwable t) {
                    this.queryStateMachine.transitionToFailed(t);
                    if (closeError == t) continue;
                    closeError.addSuppressed(t);
                }
            }
            if (closeError.getSuppressed().length > 0) {
                throw closeError;
            }
        }
    }

    private List<StreamingPlanSection> getSectionsReadyForExecution() {
        long runningPlanSections = Streams.stream((Iterable)Traverser.forTree(StreamingPlanSection::getChildren).depthFirstPreOrder((Object)this.sectionedPlan)).map(section -> this.getStageExecution(section.getPlan().getFragment().getId()).getState()).filter(state -> !state.isDone() && state != StageExecutionState.PLANNED).count();
        return (List)Streams.stream((Iterable)Traverser.forTree(StreamingPlanSection::getChildren).depthFirstPreOrder((Object)this.sectionedPlan)).filter(this::isReadyForExecution).limit((long)this.maxConcurrentMaterializations - runningPlanSections).collect(ImmutableList.toImmutableList());
    }

    private boolean isReadyForExecution(StreamingPlanSection section) {
        SqlStageExecution stageExecution = this.getStageExecution(section.getPlan().getFragment().getId());
        if (stageExecution.getState() != StageExecutionState.PLANNED) {
            return false;
        }
        for (StreamingPlanSection child : section.getChildren()) {
            SqlStageExecution rootStageExecution = this.getStageExecution(child.getPlan().getFragment().getId());
            if (rootStageExecution.getState() == StageExecutionState.FINISHED) continue;
            return false;
        }
        return true;
    }

    private List<List<StageExecutionAndScheduler>> getStageExecutions(List<StreamingPlanSection> sections) {
        return (List)sections.stream().map(section -> (ImmutableList)Streams.stream((Iterable)Traverser.forTree(StreamingSubPlan::getChildren).depthFirstPreOrder((Object)section.getPlan())).collect(ImmutableList.toImmutableList())).map(plans -> (ImmutableList)plans.stream().map(StreamingSubPlan::getFragment).map(PlanFragment::getId).map(this::getStageExecutionInfo).collect(ImmutableList.toImmutableList())).collect(ImmutableList.toImmutableList());
    }

    private SqlStageExecution getStageExecution(PlanFragmentId planFragmentId) {
        return this.stageExecutions.get(this.getStageId(planFragmentId)).getStageExecution();
    }

    private StageExecutionAndScheduler getStageExecutionInfo(PlanFragmentId planFragmentId) {
        return this.stageExecutions.get(this.getStageId(planFragmentId));
    }

    private StageId getStageId(PlanFragmentId fragmentId) {
        return new StageId(this.queryStateMachine.getQueryId(), fragmentId.getId());
    }

    @Override
    public long getUserMemoryReservation() {
        return this.stageExecutions.values().stream().mapToLong(stageExecutionInfo -> stageExecutionInfo.getStageExecution().getUserMemoryReservation()).sum();
    }

    @Override
    public long getTotalMemoryReservation() {
        return this.stageExecutions.values().stream().mapToLong(stageExecutionInfo -> stageExecutionInfo.getStageExecution().getTotalMemoryReservation()).sum();
    }

    @Override
    public Duration getTotalCpuTime() {
        long millis = this.stageExecutions.values().stream().mapToLong(stage -> stage.getStageExecution().getTotalCpuTime().toMillis()).sum();
        return new Duration((double)millis, TimeUnit.MILLISECONDS);
    }

    @Override
    public BasicStageExecutionStats getBasicStageStats() {
        List stageStats = (List)this.stageExecutions.values().stream().map(stageExecutionInfo -> stageExecutionInfo.getStageExecution().getBasicStageStats()).collect(ImmutableList.toImmutableList());
        return BasicStageExecutionStats.aggregateBasicStageStats(stageStats);
    }

    @Override
    public StageInfo getStageInfo() {
        Map stageInfos = (Map)this.stageExecutions.values().stream().map(StageExecutionAndScheduler::getStageExecution).collect(ImmutableMap.toImmutableMap(execution -> execution.getStageExecutionId().getStageId(), SqlStageExecution::getStageExecutionInfo));
        return this.buildStageInfo(this.plan, stageInfos);
    }

    private StageInfo buildStageInfo(SubPlan subPlan, Map<StageId, StageExecutionInfo> stageExecutionInfos) {
        StageId stageId = this.getStageId(subPlan.getFragment().getId());
        StageExecutionInfo stageExecutionInfo = stageExecutionInfos.get(stageId);
        Preconditions.checkArgument((stageExecutionInfo != null ? 1 : 0) != 0, (String)"No stageExecutionInfo for %s", (Object)stageId);
        return new StageInfo(stageId, this.locationFactory.createStageLocation(stageId), Optional.of(subPlan.getFragment()), stageExecutionInfo, (List<StageExecutionInfo>)ImmutableList.of(), (List)subPlan.getChildren().stream().map(plan -> this.buildStageInfo((SubPlan)plan, stageExecutionInfos)).collect(ImmutableList.toImmutableList()));
    }

    @Override
    public void cancelStage(StageId stageId) {
        try (SetThreadName ignored = new SetThreadName("Query-%s", new Object[]{this.queryStateMachine.getQueryId()});){
            SqlStageExecution execution = this.stageExecutions.get(stageId).getStageExecution();
            SqlStageExecution stage = Objects.requireNonNull(execution, () -> String.format("Stage %s does not exist", stageId));
            stage.cancel();
        }
    }

    @Override
    public void abort() {
        try (SetThreadName ignored = new SetThreadName("Query-%s", new Object[]{this.queryStateMachine.getQueryId()});){
            this.stageExecutions.values().forEach(stageExecutionInfo -> stageExecutionInfo.getStageExecution().abort());
        }
    }
}

