/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.scheduler;

import com.facebook.airlift.concurrent.MoreFutures;
import com.facebook.presto.execution.Lifespan;
import com.facebook.presto.execution.RemoteTask;
import com.facebook.presto.execution.SqlStageExecution;
import com.facebook.presto.execution.scheduler.FixedSourcePartitionedScheduler;
import com.facebook.presto.execution.scheduler.ScheduleResult;
import com.facebook.presto.execution.scheduler.SourceScheduler;
import com.facebook.presto.execution.scheduler.SplitPlacementPolicy;
import com.facebook.presto.execution.scheduler.SplitPlacementResult;
import com.facebook.presto.execution.scheduler.StageScheduler;
import com.facebook.presto.metadata.InternalNode;
import com.facebook.presto.metadata.Split;
import com.facebook.presto.spi.SplitContext;
import com.facebook.presto.spi.connector.ConnectorPartitionHandle;
import com.facebook.presto.spi.connector.NotPartitionedPartitionHandle;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.split.EmptySplit;
import com.facebook.presto.split.SplitSource;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class SourcePartitionedScheduler
implements SourceScheduler {
    private final SqlStageExecution stage;
    private final SplitSource splitSource;
    private final SplitPlacementPolicy splitPlacementPolicy;
    private final int splitBatchSize;
    private final PlanNodeId partitionedNode;
    private final boolean groupedExecution;
    private boolean lifespanAdded;
    private final Map<Lifespan, ScheduleGroup> scheduleGroups = new HashMap<Lifespan, ScheduleGroup>();
    private State state = State.INITIALIZED;
    private SettableFuture<?> whenFinishedOrNewLifespanAdded = SettableFuture.create();

    private SourcePartitionedScheduler(SqlStageExecution stage, PlanNodeId partitionedNode, SplitSource splitSource, SplitPlacementPolicy splitPlacementPolicy, int splitBatchSize, boolean groupedExecution) {
        this.stage = Objects.requireNonNull(stage, "stage is null");
        this.partitionedNode = Objects.requireNonNull(partitionedNode, "partitionedNode is null");
        this.splitSource = Objects.requireNonNull(splitSource, "splitSource is null");
        this.splitPlacementPolicy = Objects.requireNonNull(splitPlacementPolicy, "splitPlacementPolicy is null");
        Preconditions.checkArgument((splitBatchSize > 0 ? 1 : 0) != 0, (Object)"splitBatchSize must be at least one");
        this.splitBatchSize = splitBatchSize;
        this.groupedExecution = groupedExecution;
    }

    @Override
    public PlanNodeId getPlanNodeId() {
        return this.partitionedNode;
    }

    public static StageScheduler newSourcePartitionedSchedulerAsStageScheduler(SqlStageExecution stage, PlanNodeId partitionedNode, SplitSource splitSource, SplitPlacementPolicy splitPlacementPolicy, int splitBatchSize) {
        final SourcePartitionedScheduler sourcePartitionedScheduler = new SourcePartitionedScheduler(stage, partitionedNode, splitSource, splitPlacementPolicy, splitBatchSize, false);
        sourcePartitionedScheduler.startLifespan(Lifespan.taskWide(), NotPartitionedPartitionHandle.NOT_PARTITIONED);
        return new StageScheduler(){

            @Override
            public ScheduleResult schedule() {
                ScheduleResult scheduleResult = sourcePartitionedScheduler.schedule();
                sourcePartitionedScheduler.drainCompletelyScheduledLifespans();
                return scheduleResult;
            }

            @Override
            public void close() {
                sourcePartitionedScheduler.close();
            }
        };
    }

    public static SourceScheduler newSourcePartitionedSchedulerAsSourceScheduler(SqlStageExecution stage, PlanNodeId partitionedNode, SplitSource splitSource, SplitPlacementPolicy splitPlacementPolicy, int splitBatchSize, boolean groupedExecution) {
        return new SourcePartitionedScheduler(stage, partitionedNode, splitSource, splitPlacementPolicy, splitBatchSize, groupedExecution);
    }

    @Override
    public synchronized void startLifespan(Lifespan lifespan, ConnectorPartitionHandle partitionHandle) {
        Preconditions.checkState((this.state == State.INITIALIZED || this.state == State.SPLITS_ADDED ? 1 : 0) != 0);
        this.lifespanAdded = true;
        this.scheduleGroups.put(lifespan, new ScheduleGroup(partitionHandle));
        this.whenFinishedOrNewLifespanAdded.set(null);
        this.whenFinishedOrNewLifespanAdded = SettableFuture.create();
    }

    @Override
    public synchronized void rewindLifespan(Lifespan lifespan, ConnectorPartitionHandle partitionHandle) {
        Preconditions.checkState((this.state == State.INITIALIZED || this.state == State.SPLITS_ADDED ? 1 : 0) != 0, (String)"Current state %s is not rewindable", (Object)((Object)this.state));
        Preconditions.checkState((boolean)this.lifespanAdded, (Object)"Cannot rewind lifespan without any lifespan added before");
        this.scheduleGroups.remove(lifespan);
        this.splitSource.rewind(partitionHandle);
    }

    @Override
    public synchronized ScheduleResult schedule() {
        this.dropListenersFromWhenFinishedOrNewLifespansAdded();
        int overallSplitAssignmentCount = 0;
        ImmutableSet.Builder overallNewTasks = ImmutableSet.builder();
        ArrayList<Object> overallBlockedFutures = new ArrayList<Object>();
        boolean anyBlockedOnPlacements = false;
        boolean anyBlockedOnNextSplitBatch = false;
        boolean anyNotBlocked = false;
        for (Map.Entry<Lifespan, ScheduleGroup> entry : this.scheduleGroups.entrySet()) {
            Lifespan lifespan = entry.getKey();
            ScheduleGroup scheduleGroup = entry.getValue();
            if (scheduleGroup.state == ScheduleGroupState.NO_MORE_SPLITS || scheduleGroup.state == ScheduleGroupState.DONE) {
                Verify.verify((scheduleGroup.nextSplitBatchFuture == null ? 1 : 0) != 0);
            } else if (scheduleGroup.pendingSplits.isEmpty()) {
                if (scheduleGroup.nextSplitBatchFuture == null) {
                    scheduleGroup.nextSplitBatchFuture = this.splitSource.getNextBatch(scheduleGroup.partitionHandle, lifespan, this.splitBatchSize);
                    long start = System.nanoTime();
                    MoreFutures.addSuccessCallback(scheduleGroup.nextSplitBatchFuture, () -> this.stage.recordGetSplitTime(start));
                }
                if (scheduleGroup.nextSplitBatchFuture.isDone()) {
                    SplitSource.SplitBatch nextSplits = (SplitSource.SplitBatch)MoreFutures.getFutureValue(scheduleGroup.nextSplitBatchFuture);
                    scheduleGroup.nextSplitBatchFuture = null;
                    scheduleGroup.pendingSplits = new HashSet<Split>(nextSplits.getSplits());
                    if (nextSplits.isLastBatch()) {
                        if (scheduleGroup.state == ScheduleGroupState.INITIALIZED && scheduleGroup.pendingSplits.isEmpty()) {
                            scheduleGroup.pendingSplits.add(new Split(this.splitSource.getConnectorId(), this.splitSource.getTransactionHandle(), new EmptySplit(this.splitSource.getConnectorId()), lifespan, SplitContext.NON_CACHEABLE));
                        }
                        scheduleGroup.state = ScheduleGroupState.NO_MORE_SPLITS;
                    }
                } else {
                    overallBlockedFutures.add(scheduleGroup.nextSplitBatchFuture);
                    anyBlockedOnNextSplitBatch = true;
                    continue;
                }
            }
            Multimap<InternalNode, Split> splitAssignment = ImmutableMultimap.of();
            if (!scheduleGroup.pendingSplits.isEmpty()) {
                if (!scheduleGroup.placementFuture.isDone()) {
                    anyBlockedOnPlacements = true;
                    continue;
                }
                if (scheduleGroup.state == ScheduleGroupState.INITIALIZED) {
                    scheduleGroup.state = ScheduleGroupState.SPLITS_ADDED;
                }
                if (this.state == State.INITIALIZED) {
                    this.state = State.SPLITS_ADDED;
                }
                SplitPlacementResult splitPlacementResult = this.splitPlacementPolicy.computeAssignments(scheduleGroup.pendingSplits);
                splitAssignment = splitPlacementResult.getAssignments();
                splitAssignment.values().forEach(scheduleGroup.pendingSplits::remove);
                overallSplitAssignmentCount += splitAssignment.size();
                if (!scheduleGroup.pendingSplits.isEmpty()) {
                    scheduleGroup.placementFuture = splitPlacementResult.getBlocked();
                    overallBlockedFutures.add(scheduleGroup.placementFuture);
                    anyBlockedOnPlacements = true;
                }
            }
            ImmutableMultimap noMoreSplitsNotification = ImmutableMultimap.of();
            if (scheduleGroup.pendingSplits.isEmpty() && scheduleGroup.state == ScheduleGroupState.NO_MORE_SPLITS) {
                scheduleGroup.state = ScheduleGroupState.DONE;
                if (!lifespan.isTaskWide()) {
                    InternalNode node = ((FixedSourcePartitionedScheduler.BucketedSplitPlacementPolicy)this.splitPlacementPolicy).getNodeForBucket(lifespan.getId());
                    noMoreSplitsNotification = ImmutableMultimap.of((Object)node, (Object)lifespan);
                }
            }
            overallNewTasks.addAll(this.assignSplits(splitAssignment, (Multimap<InternalNode, Lifespan>)noMoreSplitsNotification));
            if (scheduleGroup.nextSplitBatchFuture != null || !scheduleGroup.pendingSplits.isEmpty() || scheduleGroup.state == ScheduleGroupState.DONE) continue;
            anyNotBlocked = true;
        }
        if (this.state == State.NO_MORE_SPLITS || this.state == State.FINISHED || !this.groupedExecution && this.lifespanAdded && this.scheduleGroups.isEmpty() && this.splitSource.isFinished()) {
            switch (this.state) {
                case INITIALIZED: {
                    throw new IllegalStateException("At least 1 split should have been scheduled for this plan node");
                }
                case SPLITS_ADDED: {
                    this.state = State.NO_MORE_SPLITS;
                    this.splitSource.close();
                }
                case NO_MORE_SPLITS: {
                    this.state = State.FINISHED;
                    this.whenFinishedOrNewLifespanAdded.set(null);
                }
                case FINISHED: {
                    return ScheduleResult.nonBlocked(true, (Iterable<? extends RemoteTask>)overallNewTasks.build(), overallSplitAssignmentCount);
                }
            }
            throw new IllegalStateException("Unknown state");
        }
        if (anyNotBlocked) {
            return ScheduleResult.nonBlocked(false, (Iterable<? extends RemoteTask>)overallNewTasks.build(), overallSplitAssignmentCount);
        }
        if (anyBlockedOnPlacements) {
            overallNewTasks.addAll(this.finalizeTaskCreationIfNecessary());
        }
        ScheduleResult.BlockedReason blockedReason = anyBlockedOnNextSplitBatch ? (anyBlockedOnPlacements ? ScheduleResult.BlockedReason.MIXED_SPLIT_QUEUES_FULL_AND_WAITING_FOR_SOURCE : ScheduleResult.BlockedReason.WAITING_FOR_SOURCE) : (anyBlockedOnPlacements ? ScheduleResult.BlockedReason.SPLIT_QUEUES_FULL : ScheduleResult.BlockedReason.NO_ACTIVE_DRIVER_GROUP);
        overallBlockedFutures.add(this.whenFinishedOrNewLifespanAdded);
        return ScheduleResult.blocked(false, (Iterable<? extends RemoteTask>)overallNewTasks.build(), Futures.nonCancellationPropagating((ListenableFuture)MoreFutures.whenAnyComplete(overallBlockedFutures)), blockedReason, overallSplitAssignmentCount);
    }

    private synchronized void dropListenersFromWhenFinishedOrNewLifespansAdded() {
        if (this.whenFinishedOrNewLifespanAdded.isDone()) {
            return;
        }
        this.whenFinishedOrNewLifespanAdded.cancel(true);
        this.whenFinishedOrNewLifespanAdded = SettableFuture.create();
    }

    @Override
    public void close() {
        this.splitSource.close();
    }

    @Override
    public synchronized List<Lifespan> drainCompletelyScheduledLifespans() {
        if (this.scheduleGroups.isEmpty()) {
            return ImmutableList.of();
        }
        ImmutableList.Builder result = ImmutableList.builder();
        Iterator<Map.Entry<Lifespan, ScheduleGroup>> entryIterator = this.scheduleGroups.entrySet().iterator();
        while (entryIterator.hasNext()) {
            Map.Entry<Lifespan, ScheduleGroup> entry = entryIterator.next();
            if (entry.getValue().state != ScheduleGroupState.DONE) continue;
            result.add((Object)entry.getKey());
            entryIterator.remove();
        }
        if (this.scheduleGroups.isEmpty() && this.splitSource.isFinished()) {
            this.whenFinishedOrNewLifespanAdded.set(null);
            this.whenFinishedOrNewLifespanAdded = SettableFuture.create();
        }
        return result.build();
    }

    @Override
    public synchronized void notifyAllLifespansFinishedExecution() {
        Preconditions.checkState((boolean)this.groupedExecution);
        this.state = State.FINISHED;
        this.splitSource.close();
        this.whenFinishedOrNewLifespanAdded.set(null);
    }

    private Set<RemoteTask> assignSplits(Multimap<InternalNode, Split> splitAssignment, Multimap<InternalNode, Lifespan> noMoreSplitsNotification) {
        ImmutableSet.Builder newTasks = ImmutableSet.builder();
        ImmutableSet nodes = ImmutableSet.builder().addAll((Iterable)splitAssignment.keySet()).addAll((Iterable)noMoreSplitsNotification.keySet()).build();
        for (InternalNode node : nodes) {
            ImmutableMultimap splits = ImmutableMultimap.builder().putAll((Object)this.partitionedNode, (Iterable)splitAssignment.get((Object)node)).build();
            ImmutableMultimap.Builder noMoreSplits = ImmutableMultimap.builder();
            if (noMoreSplitsNotification.containsKey((Object)node)) {
                noMoreSplits.putAll((Object)this.partitionedNode, (Iterable)noMoreSplitsNotification.get((Object)node));
            }
            newTasks.addAll(this.stage.scheduleSplits(node, (Multimap<PlanNodeId, Split>)splits, (Multimap<PlanNodeId, Lifespan>)noMoreSplits.build()));
        }
        return newTasks.build();
    }

    private Set<RemoteTask> finalizeTaskCreationIfNecessary() {
        if (this.stage.getFragment().isLeaf()) {
            return ImmutableSet.of();
        }
        this.splitPlacementPolicy.lockDownNodes();
        Set<InternalNode> scheduledNodes = this.stage.getScheduledNodes();
        Set newTasks = (Set)this.splitPlacementPolicy.allNodes().stream().filter(node -> !scheduledNodes.contains(node)).flatMap(node -> this.stage.scheduleSplits((InternalNode)node, (Multimap<PlanNodeId, Split>)ImmutableMultimap.of(), (Multimap<PlanNodeId, Lifespan>)ImmutableMultimap.of()).stream()).collect(ImmutableSet.toImmutableSet());
        this.stage.transitionToFinishedTaskScheduling();
        return newTasks;
    }

    private static enum ScheduleGroupState {
        INITIALIZED,
        SPLITS_ADDED,
        NO_MORE_SPLITS,
        DONE;

    }

    private static class ScheduleGroup {
        public final ConnectorPartitionHandle partitionHandle;
        public ListenableFuture<SplitSource.SplitBatch> nextSplitBatchFuture;
        public ListenableFuture<?> placementFuture = Futures.immediateFuture(null);
        public Set<Split> pendingSplits = new HashSet<Split>();
        public ScheduleGroupState state = ScheduleGroupState.INITIALIZED;

        public ScheduleGroup(ConnectorPartitionHandle partitionHandle) {
            this.partitionHandle = Objects.requireNonNull(partitionHandle, "partitionHandle is null");
        }
    }

    private static enum State {
        INITIALIZED,
        SPLITS_ADDED,
        NO_MORE_SPLITS,
        FINISHED;

    }
}

