/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.scheduler;

import com.facebook.presto.execution.scheduler.StreamingSubPlan;
import com.facebook.presto.sql.planner.SubPlan;
import com.facebook.presto.sql.planner.plan.RemoteSourceNode;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class StreamingPlanSection {
    private final StreamingSubPlan plan;
    private final List<StreamingPlanSection> children;

    public StreamingPlanSection(StreamingSubPlan plan, List<StreamingPlanSection> children) {
        this.plan = Objects.requireNonNull(plan, "plan is null");
        this.children = ImmutableList.copyOf((Collection)Objects.requireNonNull(children, "children is null"));
    }

    public StreamingSubPlan getPlan() {
        return this.plan;
    }

    public List<StreamingPlanSection> getChildren() {
        return this.children;
    }

    public static StreamingPlanSection extractStreamingSections(SubPlan subPlan) {
        ImmutableList.Builder materializedExchangeChildren = ImmutableList.builder();
        StreamingSubPlan streamingSection = StreamingPlanSection.extractStreamingSection(subPlan, (ImmutableList.Builder<SubPlan>)materializedExchangeChildren);
        return new StreamingPlanSection(streamingSection, (List)materializedExchangeChildren.build().stream().map(StreamingPlanSection::extractStreamingSections).collect(ImmutableList.toImmutableList()));
    }

    private static StreamingSubPlan extractStreamingSection(SubPlan subPlan, ImmutableList.Builder<SubPlan> materializedExchangeChildren) {
        ImmutableList.Builder streamingSources = ImmutableList.builder();
        Set streamingFragmentIds = (Set)subPlan.getFragment().getRemoteSourceNodes().stream().map(RemoteSourceNode::getSourceFragmentIds).flatMap(Collection::stream).collect(ImmutableSet.toImmutableSet());
        for (SubPlan child : subPlan.getChildren()) {
            if (streamingFragmentIds.contains(child.getFragment().getId())) {
                streamingSources.add((Object)StreamingPlanSection.extractStreamingSection(child, materializedExchangeChildren));
                continue;
            }
            materializedExchangeChildren.add((Object)child);
        }
        return new StreamingSubPlan(subPlan.getFragment(), (List<StreamingSubPlan>)streamingSources.build());
    }
}

