/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.scheduler;

import com.facebook.presto.Session;
import com.facebook.presto.execution.scheduler.ExecutionWriterTarget;
import com.facebook.presto.execution.scheduler.StreamingSubPlan;
import com.facebook.presto.metadata.AnalyzeTableHandle;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.TableLayoutResult;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.Constraint;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.plan.FilterNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.plan.TableScanNode;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.sql.planner.optimizations.PlanNodeSearcher;
import com.facebook.presto.sql.planner.plan.DeleteNode;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.SemiJoinNode;
import com.facebook.presto.sql.planner.plan.StatisticsWriterNode;
import com.facebook.presto.sql.planner.plan.TableFinishNode;
import com.facebook.presto.sql.planner.plan.TableWriterNode;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import com.google.common.graph.Traverser;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class TableWriteInfo {
    private final Optional<ExecutionWriterTarget> writerTarget;
    private final Optional<AnalyzeTableHandle> analyzeTableHandle;
    private final Optional<DeleteScanInfo> deleteScanInfo;

    @JsonCreator
    public TableWriteInfo(@JsonProperty(value="writerTarget") Optional<ExecutionWriterTarget> writerTarget, @JsonProperty(value="analyzeTableHandle") Optional<AnalyzeTableHandle> analyzeTableHandle, @JsonProperty(value="deleteScanInfo") Optional<DeleteScanInfo> deleteScanInfo) {
        this.writerTarget = Objects.requireNonNull(writerTarget, "writerTarget is null");
        this.analyzeTableHandle = Objects.requireNonNull(analyzeTableHandle, "analyzeTableHandle is null");
        this.deleteScanInfo = Objects.requireNonNull(deleteScanInfo, "deleteScanInfo is null");
        Preconditions.checkArgument((!analyzeTableHandle.isPresent() || !writerTarget.isPresent() && !deleteScanInfo.isPresent() ? 1 : 0) != 0, (Object)"analyzeTableHandle is present, so no other fields should be present");
        Preconditions.checkArgument((!deleteScanInfo.isPresent() || writerTarget.isPresent() ? 1 : 0) != 0, (Object)"deleteScanInfo is present, but writerTarget is not present");
    }

    public static TableWriteInfo createTableWriteInfo(StreamingSubPlan plan, Metadata metadata, Session session) {
        Optional<ExecutionWriterTarget> writerTarget = TableWriteInfo.createWriterTarget(plan, metadata, session);
        Optional<AnalyzeTableHandle> analyzeTableHandle = TableWriteInfo.createAnalyzeTableHandle(plan, metadata, session);
        Optional<DeleteScanInfo> deleteScanInfo = TableWriteInfo.createDeleteScanInfo(plan, writerTarget, metadata, session);
        return new TableWriteInfo(writerTarget, analyzeTableHandle, deleteScanInfo);
    }

    private static Optional<ExecutionWriterTarget> createWriterTarget(StreamingSubPlan plan, Metadata metadata, Session session) {
        Optional<TableFinishNode> tableFinishNode = TableWriteInfo.findSinglePlanNode(plan, TableFinishNode.class);
        if (tableFinishNode.isPresent()) {
            TableWriterNode.WriterTarget target = tableFinishNode.get().getTarget().orElseThrow(() -> new VerifyException("target is absent"));
            if (target instanceof TableWriterNode.CreateName) {
                TableWriterNode.CreateName create = (TableWriterNode.CreateName)target;
                return Optional.of(new ExecutionWriterTarget.CreateHandle(metadata.beginCreateTable(session, create.getConnectorId().getCatalogName(), create.getTableMetadata(), create.getLayout()), create.getSchemaTableName()));
            }
            if (target instanceof TableWriterNode.InsertReference) {
                TableWriterNode.InsertReference insert = (TableWriterNode.InsertReference)target;
                return Optional.of(new ExecutionWriterTarget.InsertHandle(metadata.beginInsert(session, insert.getHandle()), insert.getSchemaTableName()));
            }
            if (target instanceof TableWriterNode.DeleteHandle) {
                TableWriterNode.DeleteHandle delete = (TableWriterNode.DeleteHandle)target;
                return Optional.of(new ExecutionWriterTarget.DeleteHandle(metadata.beginDelete(session, delete.getHandle()), delete.getSchemaTableName()));
            }
            throw new IllegalArgumentException("Unhandled target type: " + target.getClass().getSimpleName());
        }
        return Optional.empty();
    }

    private static Optional<AnalyzeTableHandle> createAnalyzeTableHandle(StreamingSubPlan plan, Metadata metadata, Session session) {
        Optional<StatisticsWriterNode> node = TableWriteInfo.findSinglePlanNode(plan, StatisticsWriterNode.class);
        if (node.isPresent()) {
            return Optional.of(metadata.beginStatisticsCollection(session, node.get().getTableHandle()));
        }
        return Optional.empty();
    }

    private static Optional<DeleteScanInfo> createDeleteScanInfo(StreamingSubPlan plan, Optional<ExecutionWriterTarget> writerTarget, Metadata metadata, Session session) {
        if (writerTarget.isPresent() && writerTarget.get() instanceof ExecutionWriterTarget.DeleteHandle) {
            TableHandle tableHandle = ((ExecutionWriterTarget.DeleteHandle)writerTarget.get()).getHandle();
            DeleteNode delete = (DeleteNode)((Object)Iterables.getOnlyElement(TableWriteInfo.findPlanNodes(plan, DeleteNode.class)));
            TableScanNode tableScan = TableWriteInfo.getDeleteTableScan(delete);
            TupleDomain originalEnforcedConstraint = tableScan.getEnforcedConstraint();
            TableLayoutResult layoutResult = metadata.getLayout(session, tableHandle, (Constraint<ColumnHandle>)new Constraint(originalEnforcedConstraint), Optional.of(ImmutableSet.copyOf(tableScan.getAssignments().values())));
            return Optional.of(new DeleteScanInfo(tableScan.getId(), layoutResult.getLayout().getNewTableHandle()));
        }
        return Optional.empty();
    }

    private static <T extends PlanNode> Optional<T> findSinglePlanNode(StreamingSubPlan plan, Class<T> clazz) {
        List<T> allMatches = TableWriteInfo.findPlanNodes(plan, clazz);
        switch (allMatches.size()) {
            case 0: {
                return Optional.empty();
            }
            case 1: {
                return Optional.of(Iterables.getOnlyElement(allMatches));
            }
        }
        throw new IllegalArgumentException(String.format("Multiple matches found for class %s", clazz));
    }

    private static <T extends PlanNode> List<T> findPlanNodes(StreamingSubPlan plan, Class<T> clazz) {
        return (List)Streams.stream((Iterable)Traverser.forTree(StreamingSubPlan::getChildren).depthFirstPreOrder((Object)plan)).map(subPlan -> PlanNodeSearcher.searchFrom(subPlan.getFragment().getRoot()).where(clazz::isInstance).findAll()).flatMap(Collection::stream).collect(ImmutableList.toImmutableList());
    }

    private static TableScanNode getDeleteTableScan(PlanNode node) {
        if (node instanceof TableScanNode) {
            return (TableScanNode)node;
        }
        if (node instanceof DeleteNode) {
            return TableWriteInfo.getDeleteTableScan(((DeleteNode)node).getSource());
        }
        if (node instanceof FilterNode) {
            return TableWriteInfo.getDeleteTableScan(((FilterNode)node).getSource());
        }
        if (node instanceof ProjectNode) {
            return TableWriteInfo.getDeleteTableScan(((ProjectNode)node).getSource());
        }
        if (node instanceof SemiJoinNode) {
            return TableWriteInfo.getDeleteTableScan(((SemiJoinNode)node).getSource());
        }
        if (node instanceof JoinNode) {
            JoinNode joinNode = (JoinNode)node;
            return TableWriteInfo.getDeleteTableScan(joinNode.getLeft());
        }
        throw new IllegalArgumentException("Invalid descendant for DeleteNode: " + node.getClass().getName());
    }

    @JsonProperty
    public Optional<ExecutionWriterTarget> getWriterTarget() {
        return this.writerTarget;
    }

    @JsonProperty
    public Optional<AnalyzeTableHandle> getAnalyzeTableHandle() {
        return this.analyzeTableHandle;
    }

    @JsonProperty
    public Optional<DeleteScanInfo> getDeleteScanInfo() {
        return this.deleteScanInfo;
    }

    public static class DeleteScanInfo {
        private final PlanNodeId id;
        private final TableHandle tableHandle;

        @JsonCreator
        public DeleteScanInfo(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="tableHandle") TableHandle tableHandle) {
            this.id = id;
            this.tableHandle = tableHandle;
        }

        @JsonProperty
        public PlanNodeId getId() {
            return this.id;
        }

        @JsonProperty
        public TableHandle getTableHandle() {
            return this.tableHandle;
        }
    }
}

