/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.scheduler.group;

import com.facebook.presto.execution.Lifespan;
import com.facebook.presto.execution.scheduler.BucketNodeMap;
import com.facebook.presto.execution.scheduler.SourceScheduler;
import com.facebook.presto.execution.scheduler.group.LifespanScheduler;
import com.facebook.presto.metadata.InternalNode;
import com.facebook.presto.spi.connector.ConnectorPartitionHandle;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.SettableFuture;
import it.unimi.dsi.fastutil.ints.IntArrayFIFOQueue;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalInt;
import javax.annotation.concurrent.GuardedBy;

public class DynamicLifespanScheduler
implements LifespanScheduler {
    private static final int NOT_ASSIGNED = -1;
    private final BucketNodeMap bucketNodeMap;
    private final List<InternalNode> nodeByTaskId;
    private final List<ConnectorPartitionHandle> partitionHandles;
    private final OptionalInt concurrentLifespansPerTask;
    private final IntSet[] runningDriverGroupIdsByTask;
    private final int[] taskByDriverGroup;
    private final IntArrayFIFOQueue noPreferenceDriverGroups;
    private final Map<InternalNode, IntArrayFIFOQueue> nodeToPreferredDriverGroups;
    private final IntSet failedTasks;
    private boolean initialScheduled;
    private SettableFuture<?> newDriverGroupReady = SettableFuture.create();
    @GuardedBy(value="this")
    private final IntArrayFIFOQueue availableTasks = new IntArrayFIFOQueue();
    @GuardedBy(value="this")
    private int totalLifespanExecutionFinished;

    public DynamicLifespanScheduler(BucketNodeMap bucketNodeMap, List<InternalNode> nodeByTaskId, List<ConnectorPartitionHandle> partitionHandles, OptionalInt concurrentLifespansPerTask) {
        this.bucketNodeMap = Objects.requireNonNull(bucketNodeMap, "bucketNodeMap is null");
        this.nodeByTaskId = Objects.requireNonNull(nodeByTaskId, "nodeByTaskId is null");
        this.partitionHandles = Collections.unmodifiableList(new ArrayList(Objects.requireNonNull(partitionHandles, "partitionHandles is null")));
        this.concurrentLifespansPerTask = Objects.requireNonNull(concurrentLifespansPerTask, "concurrentLifespansPerTask is null");
        concurrentLifespansPerTask.ifPresent(lifespansPerTask -> Preconditions.checkArgument((lifespansPerTask >= 1 ? 1 : 0) != 0, (Object)"concurrentLifespansPerTask must be great or equal to 1 if present"));
        int bucketCount = partitionHandles.size();
        Verify.verify((bucketCount > 0 ? 1 : 0) != 0);
        this.runningDriverGroupIdsByTask = new IntSet[nodeByTaskId.size()];
        for (int i = 0; i < nodeByTaskId.size(); ++i) {
            this.runningDriverGroupIdsByTask[i] = new IntOpenHashSet();
        }
        this.taskByDriverGroup = new int[bucketCount];
        this.noPreferenceDriverGroups = new IntArrayFIFOQueue();
        this.nodeToPreferredDriverGroups = new HashMap<InternalNode, IntArrayFIFOQueue>();
        ImmutableSet nodeSet = ImmutableSet.copyOf(nodeByTaskId);
        for (int i = 0; i < bucketCount; ++i) {
            this.taskByDriverGroup[i] = -1;
            if (bucketNodeMap.getAssignedNode(i).isPresent() && nodeSet.contains(bucketNodeMap.getAssignedNode(i).get())) {
                InternalNode preferredNode = bucketNodeMap.getAssignedNode(i).get();
                this.nodeToPreferredDriverGroups.computeIfAbsent(preferredNode, k -> new IntArrayFIFOQueue());
                this.nodeToPreferredDriverGroups.get(preferredNode).enqueue(i);
                continue;
            }
            this.noPreferenceDriverGroups.enqueue(i);
        }
        this.failedTasks = new IntOpenHashSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scheduleInitial(SourceScheduler scheduler) {
        Preconditions.checkState((!this.initialScheduled ? 1 : 0) != 0, (Object)"Initial scheduling happened before scheduleInitial is called");
        int driverGroupsScheduledPerTask = 0;
        DynamicLifespanScheduler dynamicLifespanScheduler = this;
        synchronized (dynamicLifespanScheduler) {
            while (!this.noPreferenceDriverGroups.isEmpty() || !this.nodeToPreferredDriverGroups.isEmpty()) {
                for (int taskId = 0; !(taskId >= this.nodeByTaskId.size() || this.noPreferenceDriverGroups.isEmpty() && this.nodeToPreferredDriverGroups.isEmpty()); ++taskId) {
                    InternalNode node = this.nodeByTaskId.get(taskId);
                    OptionalInt driverGroupId = this.getNextDriverGroup(node);
                    if (!driverGroupId.isPresent()) continue;
                    scheduler.startLifespan(Lifespan.driverGroup(driverGroupId.getAsInt()), this.partitionHandles.get(driverGroupId.getAsInt()));
                    this.taskByDriverGroup[driverGroupId.getAsInt()] = taskId;
                    this.runningDriverGroupIdsByTask[taskId].add(driverGroupId.getAsInt());
                }
                if (!this.concurrentLifespansPerTask.isPresent() || ++driverGroupsScheduledPerTask != this.concurrentLifespansPerTask.getAsInt()) continue;
            }
            this.initialScheduled = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onLifespanExecutionFinished(Iterable<Lifespan> newlyCompletelyExecutedDriverGroups) {
        SettableFuture<?> newDriverGroupReady;
        Preconditions.checkState((boolean)this.initialScheduled, (Object)"onLifespanExecutionFinished should only be called after initial scheduling finished");
        DynamicLifespanScheduler dynamicLifespanScheduler = this;
        synchronized (dynamicLifespanScheduler) {
            for (Lifespan newlyCompletelyExecutedDriverGroup : newlyCompletelyExecutedDriverGroups) {
                Preconditions.checkArgument((!newlyCompletelyExecutedDriverGroup.isTaskWide() ? 1 : 0) != 0);
                int driverGroupId = newlyCompletelyExecutedDriverGroup.getId();
                this.availableTasks.enqueue(this.taskByDriverGroup[driverGroupId]);
                ++this.totalLifespanExecutionFinished;
                this.runningDriverGroupIdsByTask[this.taskByDriverGroup[driverGroupId]].remove(driverGroupId);
            }
            newDriverGroupReady = this.newDriverGroupReady;
        }
        newDriverGroupReady.set(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onTaskFailed(int taskId, List<SourceScheduler> sourceSchedulers) {
        Preconditions.checkState((boolean)this.initialScheduled, (Object)"onTaskFailed should only be called after initial scheduling finished");
        DynamicLifespanScheduler dynamicLifespanScheduler = this;
        synchronized (dynamicLifespanScheduler) {
            this.failedTasks.add(taskId);
            IntIterator intIterator = this.runningDriverGroupIdsByTask[taskId].iterator();
            while (intIterator.hasNext()) {
                int driverGroupId = (Integer)intIterator.next();
                for (SourceScheduler sourceScheduler : sourceSchedulers) {
                    sourceScheduler.rewindLifespan(Lifespan.driverGroup(driverGroupId), this.partitionHandles.get(driverGroupId));
                }
                this.noPreferenceDriverGroups.enqueue(driverGroupId);
            }
            if (this.nodeToPreferredDriverGroups.containsKey(this.nodeByTaskId.get(taskId))) {
                IntArrayFIFOQueue preferredDriverGroupQueue = this.nodeToPreferredDriverGroups.get(this.nodeByTaskId.get(taskId));
                while (!preferredDriverGroupQueue.isEmpty()) {
                    this.noPreferenceDriverGroups.enqueue(preferredDriverGroupQueue.dequeueInt());
                }
                this.nodeToPreferredDriverGroups.remove(this.nodeByTaskId.get(taskId));
            }
            this.runningDriverGroupIdsByTask[taskId].clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SettableFuture schedule(SourceScheduler scheduler) {
        Preconditions.checkState((boolean)this.initialScheduled, (Object)"schedule should only be called after initial scheduling finished");
        Preconditions.checkState((this.failedTasks.size() < this.nodeByTaskId.size() ? 1 : 0) != 0, (Object)"All tasks have failed");
        DynamicLifespanScheduler dynamicLifespanScheduler = this;
        synchronized (dynamicLifespanScheduler) {
            this.newDriverGroupReady = SettableFuture.create();
            while (!(this.availableTasks.isEmpty() || this.noPreferenceDriverGroups.isEmpty() && this.nodeToPreferredDriverGroups.isEmpty())) {
                OptionalInt nextDriverGroupId;
                int taskId = this.availableTasks.dequeueInt();
                if (this.failedTasks.contains(taskId) || !(nextDriverGroupId = this.getNextDriverGroup(this.nodeByTaskId.get(taskId))).isPresent()) continue;
                scheduler.startLifespan(Lifespan.driverGroup(nextDriverGroupId.getAsInt()), this.partitionHandles.get(nextDriverGroupId.getAsInt()));
                this.taskByDriverGroup[nextDriverGroupId.getAsInt()] = taskId;
                this.runningDriverGroupIdsByTask[taskId].add(nextDriverGroupId.getAsInt());
            }
        }
        return this.newDriverGroupReady;
    }

    @Override
    public synchronized boolean allLifespanExecutionFinished() {
        return this.totalLifespanExecutionFinished == this.partitionHandles.size();
    }

    private OptionalInt getNextDriverGroup(InternalNode node) {
        OptionalInt driverGroupId = OptionalInt.empty();
        if (this.nodeToPreferredDriverGroups.get(node) != null && !this.nodeToPreferredDriverGroups.get(node).isEmpty()) {
            driverGroupId = OptionalInt.of(this.nodeToPreferredDriverGroups.get(node).dequeueInt());
            if (this.nodeToPreferredDriverGroups.get(node).isEmpty()) {
                this.nodeToPreferredDriverGroups.remove(node);
            }
        } else if (!this.noPreferenceDriverGroups.isEmpty()) {
            driverGroupId = OptionalInt.of(this.noPreferenceDriverGroups.dequeueInt());
            this.bucketNodeMap.assignOrUpdateBucketToNode(driverGroupId.getAsInt(), node, false);
        }
        return driverGroupId;
    }
}

