/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.memory;

import com.facebook.presto.memory.MemoryInfo;
import com.facebook.presto.memory.MemoryPool;
import com.facebook.presto.memory.NodeMemoryConfig;
import com.facebook.presto.spi.memory.MemoryPoolId;
import com.facebook.presto.spi.memory.MemoryPoolInfo;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.units.DataSize;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;

public final class LocalMemoryManager {
    public static final MemoryPoolId GENERAL_POOL = new MemoryPoolId("general");
    public static final MemoryPoolId RESERVED_POOL = new MemoryPoolId("reserved");
    private DataSize maxMemory;
    private Map<MemoryPoolId, MemoryPool> pools;

    @Inject
    public LocalMemoryManager(NodeMemoryConfig config) {
        this(config, Runtime.getRuntime().maxMemory());
    }

    @VisibleForTesting
    public LocalMemoryManager(NodeMemoryConfig config, long availableMemory) {
        Objects.requireNonNull(config, "config is null");
        this.configureMemoryPools(config, availableMemory);
    }

    private void configureMemoryPools(NodeMemoryConfig config, long availableMemory) {
        LocalMemoryManager.validateHeapHeadroom(config, availableMemory);
        this.maxMemory = new DataSize((double)(availableMemory - config.getHeapHeadroom().toBytes()), DataSize.Unit.BYTE);
        Preconditions.checkArgument((config.getMaxQueryMemoryPerNode().toBytes() <= config.getMaxQueryTotalMemoryPerNode().toBytes() ? 1 : 0) != 0, (String)"Max query memory per node (%s) cannot be greater than the max query total memory per node (%s).", (Object)"query.max-memory-per-node", (Object)"query.max-total-memory-per-node");
        ImmutableMap.Builder builder = ImmutableMap.builder();
        long generalPoolSize = this.maxMemory.toBytes();
        if (config.isReservedPoolEnabled()) {
            builder.put((Object)RESERVED_POOL, (Object)new MemoryPool(RESERVED_POOL, config.getMaxQueryTotalMemoryPerNode()));
            generalPoolSize -= config.getMaxQueryTotalMemoryPerNode().toBytes();
        }
        Verify.verify((generalPoolSize > 0L ? 1 : 0) != 0, (String)"general memory pool size is 0", (Object[])new Object[0]);
        builder.put((Object)GENERAL_POOL, (Object)new MemoryPool(GENERAL_POOL, new DataSize((double)generalPoolSize, DataSize.Unit.BYTE)));
        this.pools = builder.build();
    }

    @VisibleForTesting
    static void validateHeapHeadroom(NodeMemoryConfig config, long availableMemory) {
        long maxQueryTotalMemoryPerNode = config.getMaxQueryTotalMemoryPerNode().toBytes();
        long heapHeadroom = config.getHeapHeadroom().toBytes();
        if (heapHeadroom < 0L || heapHeadroom + maxQueryTotalMemoryPerNode > availableMemory) {
            throw new IllegalArgumentException(String.format("Invalid memory configuration. The sum of max total query memory per node (%s) and heap headroom (%s) cannot be larger than the available heap memory (%s)", maxQueryTotalMemoryPerNode, heapHeadroom, availableMemory));
        }
    }

    public MemoryInfo getInfo() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<MemoryPoolId, MemoryPool> entry : this.pools.entrySet()) {
            builder.put((Object)entry.getKey(), (Object)entry.getValue().getInfo());
        }
        return new MemoryInfo(this.maxMemory, (Map<MemoryPoolId, MemoryPoolInfo>)builder.build());
    }

    public List<MemoryPool> getPools() {
        return ImmutableList.copyOf(this.pools.values());
    }

    public MemoryPool getGeneralPool() {
        return this.pools.get(GENERAL_POOL);
    }

    public Optional<MemoryPool> getReservedPool() {
        return Optional.ofNullable(this.pools.get(RESERVED_POOL));
    }
}

