/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.FunctionManager;
import com.facebook.presto.metadata.PolymorphicScalarFunction;
import com.facebook.presto.metadata.SqlScalarFunction;
import com.facebook.presto.operator.scalar.BuiltInScalarFunctionImplementation;
import com.facebook.presto.spi.function.OperatorType;
import com.facebook.presto.spi.function.Signature;
import com.facebook.presto.spi.function.SqlFunctionVisibility;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

public final class PolymorphicScalarFunctionBuilder {
    private final Class<?> clazz;
    private final Optional<OperatorType> operatorType;
    private Signature signature;
    private String description;
    private Optional<SqlFunctionVisibility> visibility = Optional.empty();
    private Boolean deterministic;
    private Boolean calledOnNullInput;
    private final List<PolymorphicScalarFunction.PolymorphicScalarFunctionChoice> choices = new ArrayList<PolymorphicScalarFunction.PolymorphicScalarFunctionChoice>();

    public PolymorphicScalarFunctionBuilder(Class<?> clazz) {
        this.clazz = clazz;
        this.operatorType = Optional.empty();
    }

    public PolymorphicScalarFunctionBuilder(Class<?> clazz, OperatorType operatorType) {
        this.clazz = clazz;
        this.operatorType = Optional.of(operatorType);
    }

    public PolymorphicScalarFunctionBuilder signature(Signature signature) {
        this.signature = Objects.requireNonNull(signature, "signature is null");
        this.visibility = Optional.of(this.visibility.orElse(PolymorphicScalarFunctionBuilder.isOperator(signature) ? SqlFunctionVisibility.HIDDEN : SqlFunctionVisibility.PUBLIC));
        return this;
    }

    public PolymorphicScalarFunctionBuilder description(String description) {
        this.description = description;
        return this;
    }

    public PolymorphicScalarFunctionBuilder visibility(SqlFunctionVisibility visibility) {
        this.visibility = Optional.of(visibility);
        return this;
    }

    public PolymorphicScalarFunctionBuilder deterministic(boolean deterministic) {
        this.deterministic = deterministic;
        return this;
    }

    public PolymorphicScalarFunctionBuilder calledOnNullInput(boolean calledOnNullInput) {
        this.calledOnNullInput = calledOnNullInput;
        return this;
    }

    public PolymorphicScalarFunctionBuilder choice(Function<ChoiceBuilder, ChoiceBuilder> choiceSpecification) {
        ChoiceBuilder choiceBuilder = new ChoiceBuilder(this.clazz, this.signature);
        choiceSpecification.apply(choiceBuilder);
        this.choices.add(choiceBuilder.build());
        return this;
    }

    public SqlScalarFunction build() {
        Preconditions.checkState((this.signature != null ? 1 : 0) != 0, (Object)"signature is null");
        Preconditions.checkState((this.deterministic != null ? 1 : 0) != 0, (Object)"deterministic is null");
        Preconditions.checkState((this.operatorType.isPresent() || this.calledOnNullInput != null ? 1 : 0) != 0, (Object)"None operator needs to set calledOnNullInput");
        return new PolymorphicScalarFunction(this.signature, this.description, this.visibility.orElse(SqlFunctionVisibility.PUBLIC), this.deterministic, this.operatorType.map(OperatorType::isCalledOnNullInput).orElse(this.calledOnNullInput), this.choices);
    }

    @SafeVarargs
    public static Function<SpecializeContext, List<Object>> concat(Function<SpecializeContext, List<Object>> ... extraParametersFunctions) {
        return context -> {
            ImmutableList.Builder extraParametersBuilder = ImmutableList.builder();
            for (Function extraParametersFunction : extraParametersFunctions) {
                extraParametersBuilder.addAll((Iterable)extraParametersFunction.apply(context));
            }
            return extraParametersBuilder.build();
        };
    }

    public static <T> Function<SpecializeContext, List<Object>> constant(T value) {
        return context -> ImmutableList.of((Object)value);
    }

    private static boolean isOperator(Signature signature) {
        for (OperatorType operator : OperatorType.values()) {
            if (!signature.getName().equals((Object)operator.getFunctionName())) continue;
            return true;
        }
        return false;
    }

    static class MethodAndNativeContainerTypes {
        private final Method method;
        private List<Optional<Class<?>>> explicitNativeContainerTypes;

        MethodAndNativeContainerTypes(Method method, List<Optional<Class<?>>> explicitNativeContainerTypes) {
            this.method = method;
            this.explicitNativeContainerTypes = explicitNativeContainerTypes;
        }

        public Method getMethod() {
            return this.method;
        }

        List<Optional<Class<?>>> getExplicitNativeContainerTypes() {
            return this.explicitNativeContainerTypes;
        }

        void setExplicitNativeContainerTypes(List<Optional<Class<?>>> explicitNativeContainerTypes) {
            this.explicitNativeContainerTypes = explicitNativeContainerTypes;
        }
    }

    static final class MethodsGroup {
        private final Optional<Function<SpecializeContext, List<Object>>> extraParametersFunction;
        private final List<MethodAndNativeContainerTypes> methodAndNativeContainerTypes;

        MethodsGroup(List<MethodAndNativeContainerTypes> methodAndNativeContainerTypes, Optional<Function<SpecializeContext, List<Object>>> extraParametersFunction) {
            this.methodAndNativeContainerTypes = Objects.requireNonNull(methodAndNativeContainerTypes, "methodAndNativeContainerTypes is null");
            this.extraParametersFunction = Objects.requireNonNull(extraParametersFunction, "extraParametersFunction is null");
        }

        List<MethodAndNativeContainerTypes> getMethods() {
            return this.methodAndNativeContainerTypes;
        }

        Optional<Function<SpecializeContext, List<Object>>> getExtraParametersFunction() {
            return this.extraParametersFunction;
        }
    }

    public static class ChoiceBuilder {
        private final Class<?> clazz;
        private final Signature signature;
        private boolean nullableResult;
        private List<BuiltInScalarFunctionImplementation.ArgumentProperty> argumentProperties;
        private BuiltInScalarFunctionImplementation.ReturnPlaceConvention returnPlaceConvention;
        private final ImmutableList.Builder<MethodsGroup> methodsGroups = ImmutableList.builder();

        private ChoiceBuilder(Class<?> clazz, Signature signature) {
            this.clazz = Objects.requireNonNull(clazz, "clazz is null");
            this.signature = Objects.requireNonNull(signature, "signature is null");
        }

        public ChoiceBuilder implementation(Function<MethodsGroupBuilder, MethodsGroupBuilder> methodsGroupSpecification) {
            if (this.argumentProperties == null) {
                this.argumentProperties = Collections.nCopies(this.signature.getArgumentTypes().size(), BuiltInScalarFunctionImplementation.ArgumentProperty.valueTypeArgumentProperty(BuiltInScalarFunctionImplementation.NullConvention.RETURN_NULL_ON_NULL));
            }
            if (this.returnPlaceConvention == null) {
                this.returnPlaceConvention = BuiltInScalarFunctionImplementation.ReturnPlaceConvention.STACK;
            }
            MethodsGroupBuilder methodsGroupBuilder = new MethodsGroupBuilder(this.clazz, this.signature, this.argumentProperties);
            methodsGroupSpecification.apply(methodsGroupBuilder);
            this.methodsGroups.add((Object)methodsGroupBuilder.build());
            return this;
        }

        public ChoiceBuilder nullableResult(boolean nullableResult) {
            this.nullableResult = nullableResult;
            return this;
        }

        public ChoiceBuilder argumentProperties(BuiltInScalarFunctionImplementation.ArgumentProperty ... argumentProperties) {
            Objects.requireNonNull(argumentProperties, "argumentProperties is null");
            Preconditions.checkState((this.argumentProperties == null ? 1 : 0) != 0, (Object)"The `argumentProperties` method must be invoked only once, and must be invoked before the `implementation` method");
            this.argumentProperties = ImmutableList.copyOf((Object[])argumentProperties);
            return this;
        }

        public ChoiceBuilder returnPlaceConvention(BuiltInScalarFunctionImplementation.ReturnPlaceConvention returnPlaceConvention) {
            Objects.requireNonNull(returnPlaceConvention, "returnPlaceConvention is null");
            Preconditions.checkState((this.returnPlaceConvention == null ? 1 : 0) != 0, (Object)"The `returnPlaceConvention` method must be invoked only once, and must be invoked before the `implementation` method");
            this.returnPlaceConvention = returnPlaceConvention;
            return this;
        }

        public PolymorphicScalarFunction.PolymorphicScalarFunctionChoice build() {
            return new PolymorphicScalarFunction.PolymorphicScalarFunctionChoice(this.nullableResult, this.argumentProperties, this.returnPlaceConvention, (List<MethodsGroup>)this.methodsGroups.build());
        }
    }

    public static class MethodsGroupBuilder {
        private final Class<?> clazz;
        private final Signature signature;
        private List<BuiltInScalarFunctionImplementation.ArgumentProperty> argumentProperties;
        private final ImmutableList.Builder<MethodAndNativeContainerTypes> methodAndNativeContainerTypesList = ImmutableList.builder();
        private Optional<Function<SpecializeContext, List<Object>>> extraParametersFunction = Optional.empty();

        private MethodsGroupBuilder(Class<?> clazz, Signature signature, List<BuiltInScalarFunctionImplementation.ArgumentProperty> argumentProperties) {
            this.clazz = clazz;
            this.signature = signature;
            this.argumentProperties = argumentProperties;
        }

        public MethodsGroupBuilder methods(String ... methodNames) {
            return this.methods(Arrays.asList((Object[])Objects.requireNonNull(methodNames, "methodNames is null")));
        }

        public MethodsGroupBuilder methods(List<String> methodNames) {
            Objects.requireNonNull(methodNames, "methodNames is null");
            Preconditions.checkArgument((!methodNames.isEmpty() ? 1 : 0) != 0, (Object)"methods list is empty");
            methodNames.forEach(methodName -> this.methodWithExplicitJavaTypes((String)methodName, Collections.nCopies(this.signature.getArgumentTypes().size(), Optional.empty())));
            return this;
        }

        public MethodsGroupBuilder withExtraParameters(Function<SpecializeContext, List<Object>> extraParametersFunction) {
            Preconditions.checkState((!this.methodAndNativeContainerTypesList.build().isEmpty() ? 1 : 0) != 0, (Object)"methods must be selected first");
            Objects.requireNonNull(extraParametersFunction, "extraParametersFunction is null");
            this.extraParametersFunction = Optional.of(extraParametersFunction);
            return this;
        }

        public MethodsGroupBuilder methodWithExplicitJavaTypes(String methodName, List<Optional<Class<?>>> types) {
            Objects.requireNonNull(methodName, "methodName is null");
            List matchingMethod = (List)Arrays.asList(this.clazz.getMethods()).stream().filter(method -> methodName.equals(method.getName())).map(method -> new MethodAndNativeContainerTypes((Method)method, types)).collect(ImmutableList.toImmutableList());
            Preconditions.checkState((!matchingMethod.isEmpty() ? 1 : 0) != 0, (String)"method %s was not found in %s", (Object)methodName, this.clazz);
            Preconditions.checkState((matchingMethod.size() == 1 ? 1 : 0) != 0, (String)"multiple methods %s was not found in %s", (Object)methodName, this.clazz);
            MethodAndNativeContainerTypes methodAndNativeContainerTypes = (MethodAndNativeContainerTypes)matchingMethod.get(0);
            int argumentSize = this.signature.getArgumentTypes().size();
            Preconditions.checkState((types.size() == argumentSize ? 1 : 0) != 0, (String)"not matching number of arguments from signature: %s (should have %s)", (int)types.size(), (int)argumentSize);
            Preconditions.checkState((types.size() == this.argumentProperties.size() ? 1 : 0) != 0, (String)"not matching number of arguments from argument properties: %s (should have %s)", (int)types.size(), (int)this.argumentProperties.size());
            Iterator<BuiltInScalarFunctionImplementation.ArgumentProperty> argumentPropertyIterator = this.argumentProperties.iterator();
            Iterator<Optional<Class<?>>> typesIterator = types.iterator();
            while (argumentPropertyIterator.hasNext() && typesIterator.hasNext()) {
                Optional<Class<?>> classOptional = typesIterator.next();
                BuiltInScalarFunctionImplementation.ArgumentProperty argumentProperty = argumentPropertyIterator.next();
                Preconditions.checkState((argumentProperty.getNullConvention() == BuiltInScalarFunctionImplementation.NullConvention.BLOCK_AND_POSITION == classOptional.isPresent() ? 1 : 0) != 0, (Object)"Explicit type is not set when null convention is BLOCK_AND_POSITION");
            }
            this.methodAndNativeContainerTypesList.add((Object)methodAndNativeContainerTypes);
            return this;
        }

        public MethodsGroup build() {
            return new MethodsGroup((List<MethodAndNativeContainerTypes>)this.methodAndNativeContainerTypesList.build(), this.extraParametersFunction);
        }
    }

    public static final class SpecializeContext {
        private final BoundVariables boundVariables;
        private final List<Type> parameterTypes;
        private final Type returnType;
        private final TypeManager typeManager;
        private final FunctionManager functionManager;

        SpecializeContext(BoundVariables boundVariables, List<Type> parameterTypes, Type returnType, TypeManager typeManager, FunctionManager functionManager) {
            this.boundVariables = Objects.requireNonNull(boundVariables, "boundVariables is null");
            this.parameterTypes = Objects.requireNonNull(parameterTypes, "parameterTypes is null");
            this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
            this.returnType = Objects.requireNonNull(returnType, "returnType is null");
            this.functionManager = Objects.requireNonNull(functionManager, "functionManager is null");
        }

        public Type getType(String name) {
            return this.boundVariables.getTypeVariable(name);
        }

        public Long getLiteral(String name) {
            return this.boundVariables.getLongVariable(name);
        }

        public List<Type> getParameterTypes() {
            return this.parameterTypes;
        }

        public Type getReturnType() {
            return this.returnType;
        }

        public TypeManager getTypeManager() {
            return this.typeManager;
        }

        public FunctionManager getFunctionManager() {
            return this.functionManager;
        }
    }
}

