/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.spi.function.LongVariableConstraint;
import com.facebook.presto.spi.function.Signature;
import com.facebook.presto.spi.function.TypeVariableConstraint;
import com.facebook.presto.spi.type.FunctionType;
import com.facebook.presto.spi.type.NamedTypeSignature;
import com.facebook.presto.spi.type.ParameterKind;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.spi.type.TypeSignatureParameter;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.type.TypeCalculation;
import com.facebook.presto.type.TypeRegistry;
import com.facebook.presto.type.UnknownType;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class SignatureBinder {
    private static final int SOLVE_ITERATION_LIMIT = 4;
    private final TypeManager typeManager;
    private final Signature declaredSignature;
    private final boolean allowCoercion;
    private final Map<String, TypeVariableConstraint> typeVariableConstraints;

    public SignatureBinder(TypeManager typeManager, Signature declaredSignature, boolean allowCoercion) {
        SignatureBinder.checkNoLiteralVariableUsageAcrossTypes(declaredSignature);
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.declaredSignature = Objects.requireNonNull(declaredSignature, "parametrizedSignature is null");
        this.allowCoercion = allowCoercion;
        this.typeVariableConstraints = declaredSignature.getTypeVariableConstraints().stream().collect(Collectors.toMap(TypeVariableConstraint::getName, Function.identity()));
    }

    public Optional<Signature> bind(List<? extends TypeSignatureProvider> actualArgumentTypes) {
        Optional<BoundVariables> boundVariables = this.bindVariables(actualArgumentTypes);
        if (!boundVariables.isPresent()) {
            return Optional.empty();
        }
        return Optional.of(SignatureBinder.applyBoundVariables(this.declaredSignature, boundVariables.get(), actualArgumentTypes.size()));
    }

    public Optional<Signature> bind(List<? extends TypeSignatureProvider> actualArgumentTypes, Type actualReturnType) {
        Optional<BoundVariables> boundVariables = this.bindVariables(actualArgumentTypes, actualReturnType);
        if (!boundVariables.isPresent()) {
            return Optional.empty();
        }
        return Optional.of(SignatureBinder.applyBoundVariables(this.declaredSignature, boundVariables.get(), actualArgumentTypes.size()));
    }

    public Optional<BoundVariables> bindVariables(List<? extends TypeSignatureProvider> actualArgumentTypes) {
        ImmutableList.Builder constraintSolvers = ImmutableList.builder();
        if (!this.appendConstraintSolversForArguments((ImmutableList.Builder<TypeConstraintSolver>)constraintSolvers, actualArgumentTypes)) {
            return Optional.empty();
        }
        return this.iterativeSolve((List<TypeConstraintSolver>)constraintSolvers.build());
    }

    public Optional<BoundVariables> bindVariables(List<? extends TypeSignatureProvider> actualArgumentTypes, Type actualReturnType) {
        ImmutableList.Builder constraintSolvers = ImmutableList.builder();
        if (!this.appendConstraintSolversForReturnValue((ImmutableList.Builder<TypeConstraintSolver>)constraintSolvers, new TypeSignatureProvider(actualReturnType.getTypeSignature()))) {
            return Optional.empty();
        }
        if (!this.appendConstraintSolversForArguments((ImmutableList.Builder<TypeConstraintSolver>)constraintSolvers, actualArgumentTypes)) {
            return Optional.empty();
        }
        return this.iterativeSolve((List<TypeConstraintSolver>)constraintSolvers.build());
    }

    public static Signature applyBoundVariables(Signature signature, BoundVariables boundVariables, int arity) {
        List argumentSignatures;
        if (signature.isVariableArity()) {
            argumentSignatures = SignatureBinder.expandVarargFormalTypeSignature(signature.getArgumentTypes(), arity);
        } else {
            Preconditions.checkArgument((signature.getArgumentTypes().size() == arity ? 1 : 0) != 0);
            argumentSignatures = signature.getArgumentTypes();
        }
        List<TypeSignature> boundArgumentSignatures = SignatureBinder.applyBoundVariables(argumentSignatures, boundVariables);
        TypeSignature boundReturnTypeSignature = SignatureBinder.applyBoundVariables(signature.getReturnType(), boundVariables);
        return new Signature(signature.getName(), signature.getKind(), (List)ImmutableList.of(), (List)ImmutableList.of(), boundReturnTypeSignature, boundArgumentSignatures, false);
    }

    public static List<TypeSignature> applyBoundVariables(List<TypeSignature> typeSignatures, BoundVariables boundVariables) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (TypeSignature typeSignature : typeSignatures) {
            builder.add((Object)SignatureBinder.applyBoundVariables(typeSignature, boundVariables));
        }
        return builder.build();
    }

    public static TypeSignature applyBoundVariables(TypeSignature typeSignature, BoundVariables boundVariables) {
        String baseType = typeSignature.getBase();
        if (boundVariables.containsTypeVariable(baseType)) {
            Preconditions.checkState((boolean)typeSignature.getParameters().isEmpty(), (Object)"Type parameters cannot have parameters");
            return boundVariables.getTypeVariable(baseType).getTypeSignature();
        }
        List parameters = typeSignature.getParameters().stream().map(typeSignatureParameter -> SignatureBinder.applyBoundVariables(typeSignatureParameter, boundVariables)).collect(Collectors.toList());
        return new TypeSignature(baseType, parameters);
    }

    public static List<Type> applyBoundVariables(TypeManager typeManager, List<TypeSignature> typeSignatures, BoundVariables boundVariables) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (TypeSignature typeSignature : typeSignatures) {
            builder.add((Object)SignatureBinder.applyBoundVariables(typeManager, typeSignature, boundVariables));
        }
        return builder.build();
    }

    public static Type applyBoundVariables(TypeManager typeManager, TypeSignature typeSignature, BoundVariables boundVariables) {
        String baseType = typeSignature.getBase();
        if (boundVariables.containsTypeVariable(baseType)) {
            Preconditions.checkState((boolean)typeSignature.getParameters().isEmpty(), (Object)"Type parameters cannot have parameters");
            return boundVariables.getTypeVariable(baseType);
        }
        List parameters = typeSignature.getParameters().stream().map(typeSignatureParameter -> SignatureBinder.applyBoundVariables(typeSignatureParameter, boundVariables)).collect(Collectors.toList());
        return typeManager.getParameterizedType(baseType, parameters);
    }

    private static void checkNoLiteralVariableUsageAcrossTypes(Signature declaredSignature) {
        HashMap<String, TypeSignature> existingUsages = new HashMap<String, TypeSignature>();
        for (TypeSignature parameter : declaredSignature.getArgumentTypes()) {
            SignatureBinder.checkNoLiteralVariableUsageAcrossTypes(parameter, existingUsages);
        }
    }

    private static void checkNoLiteralVariableUsageAcrossTypes(TypeSignature typeSignature, Map<String, TypeSignature> existingUsages) {
        List variables = typeSignature.getParameters().stream().filter(TypeSignatureParameter::isVariable).collect(Collectors.toList());
        for (TypeSignatureParameter variable : variables) {
            TypeSignature existing = existingUsages.get(variable.getVariable());
            if (existing != null && !existing.equals((Object)typeSignature)) {
                throw new UnsupportedOperationException("Literal parameters may not be shared across different types");
            }
            existingUsages.put(variable.getVariable(), typeSignature);
        }
        for (TypeSignatureParameter parameter : typeSignature.getParameters()) {
            if (parameter.isLongLiteral() || parameter.isVariable()) continue;
            SignatureBinder.checkNoLiteralVariableUsageAcrossTypes((TypeSignature)parameter.getTypeSignatureOrNamedTypeSignature().get(), existingUsages);
        }
    }

    private boolean appendConstraintSolversForReturnValue(ImmutableList.Builder<TypeConstraintSolver> resultBuilder, TypeSignatureProvider actualReturnType) {
        TypeSignature formalReturnTypeSignature = this.declaredSignature.getReturnType();
        return this.appendTypeRelationshipConstraintSolver(resultBuilder, formalReturnTypeSignature, actualReturnType, false) && this.appendConstraintSolvers(resultBuilder, formalReturnTypeSignature, actualReturnType, false);
    }

    private boolean appendConstraintSolversForArguments(ImmutableList.Builder<TypeConstraintSolver> resultBuilder, List<? extends TypeSignatureProvider> actualTypes) {
        boolean variableArity = this.declaredSignature.isVariableArity();
        List<TypeSignature> formalTypeSignatures = this.declaredSignature.getArgumentTypes();
        if (variableArity) {
            if (actualTypes.size() < formalTypeSignatures.size() - 1) {
                return false;
            }
            formalTypeSignatures = SignatureBinder.expandVarargFormalTypeSignature(formalTypeSignatures, actualTypes.size());
        }
        if (formalTypeSignatures.size() != actualTypes.size()) {
            return false;
        }
        for (int i = 0; i < formalTypeSignatures.size(); ++i) {
            if (this.appendTypeRelationshipConstraintSolver(resultBuilder, formalTypeSignatures.get(i), actualTypes.get(i), this.allowCoercion)) continue;
            return false;
        }
        return this.appendConstraintSolvers(resultBuilder, formalTypeSignatures, actualTypes, this.allowCoercion);
    }

    private boolean appendConstraintSolvers(ImmutableList.Builder<TypeConstraintSolver> resultBuilder, List<? extends TypeSignature> formalTypeSignatures, List<? extends TypeSignatureProvider> actualTypes, boolean allowCoercion) {
        if (formalTypeSignatures.size() != actualTypes.size()) {
            return false;
        }
        for (int i = 0; i < formalTypeSignatures.size(); ++i) {
            if (this.appendConstraintSolvers(resultBuilder, formalTypeSignatures.get(i), actualTypes.get(i), allowCoercion)) continue;
            return false;
        }
        return true;
    }

    private boolean appendConstraintSolvers(ImmutableList.Builder<TypeConstraintSolver> resultBuilder, TypeSignature formalTypeSignature, TypeSignatureProvider actualTypeSignatureProvider, boolean allowCoercion) {
        if ("function".equals(formalTypeSignature.getBase())) {
            List formalTypeParameterTypeSignatures = formalTypeSignature.getTypeParametersAsTypeSignatures();
            resultBuilder.add((Object)new FunctionSolver(SignatureBinder.getLambdaArgumentTypeSignatures(formalTypeSignature), (TypeSignature)formalTypeParameterTypeSignatures.get(formalTypeParameterTypeSignatures.size() - 1), actualTypeSignatureProvider));
            return true;
        }
        if (actualTypeSignatureProvider.hasDependency()) {
            return false;
        }
        if (formalTypeSignature.getParameters().isEmpty()) {
            TypeVariableConstraint typeVariableConstraint = this.typeVariableConstraints.get(formalTypeSignature.getBase());
            if (typeVariableConstraint == null) {
                return true;
            }
            Type actualType = this.typeManager.getType(actualTypeSignatureProvider.getTypeSignature());
            resultBuilder.add((Object)new TypeParameterSolver(formalTypeSignature.getBase(), actualType, typeVariableConstraint.isComparableRequired(), typeVariableConstraint.isOrderableRequired(), Optional.ofNullable(typeVariableConstraint.getVariadicBound())));
            return true;
        }
        Type actualType = this.typeManager.getType(actualTypeSignatureProvider.getTypeSignature());
        if (SignatureBinder.isTypeWithLiteralParameters(formalTypeSignature)) {
            resultBuilder.add((Object)new TypeWithLiteralParametersSolver(formalTypeSignature, actualType));
            return true;
        }
        List<TypeSignatureProvider> actualTypeParametersTypeSignatureProvider = UnknownType.UNKNOWN.equals(actualType) ? Collections.nCopies(formalTypeSignature.getParameters().size(), new TypeSignatureProvider(UnknownType.UNKNOWN.getTypeSignature())) : TypeSignatureProvider.fromTypes(actualType.getTypeParameters());
        ImmutableList.Builder formalTypeParameterTypeSignatures = ImmutableList.builder();
        for (TypeSignatureParameter formalTypeParameter : formalTypeSignature.getParameters()) {
            Optional typeSignature = formalTypeParameter.getTypeSignatureOrNamedTypeSignature();
            if (!typeSignature.isPresent()) {
                throw new UnsupportedOperationException("Types with both type parameters and literal parameters at the same time are not supported");
            }
            formalTypeParameterTypeSignatures.add(typeSignature.get());
        }
        return this.appendConstraintSolvers(resultBuilder, (List<? extends TypeSignature>)formalTypeParameterTypeSignatures.build(), actualTypeParametersTypeSignatureProvider, allowCoercion && TypeRegistry.isCovariantTypeBase(formalTypeSignature.getBase()));
    }

    private Set<String> typeVariablesOf(TypeSignature typeSignature) {
        if (this.typeVariableConstraints.containsKey(typeSignature.getBase())) {
            return ImmutableSet.of((Object)typeSignature.getBase());
        }
        HashSet<String> variables = new HashSet<String>();
        block6: for (TypeSignatureParameter parameter : typeSignature.getParameters()) {
            switch (parameter.getKind()) {
                case TYPE: {
                    variables.addAll(this.typeVariablesOf(parameter.getTypeSignature()));
                    continue block6;
                }
                case NAMED_TYPE: {
                    variables.addAll(this.typeVariablesOf(parameter.getNamedTypeSignature().getTypeSignature()));
                    continue block6;
                }
                case LONG: {
                    continue block6;
                }
                case VARIABLE: {
                    continue block6;
                }
            }
            throw new UnsupportedOperationException();
        }
        return variables;
    }

    private static Set<String> longVariablesOf(TypeSignature typeSignature) {
        HashSet<String> variables = new HashSet<String>();
        block6: for (TypeSignatureParameter parameter : typeSignature.getParameters()) {
            switch (parameter.getKind()) {
                case TYPE: {
                    variables.addAll(SignatureBinder.longVariablesOf(parameter.getTypeSignature()));
                    continue block6;
                }
                case NAMED_TYPE: {
                    variables.addAll(SignatureBinder.longVariablesOf(parameter.getNamedTypeSignature().getTypeSignature()));
                    continue block6;
                }
                case LONG: {
                    continue block6;
                }
                case VARIABLE: {
                    variables.add(parameter.getVariable());
                    continue block6;
                }
            }
            throw new UnsupportedOperationException();
        }
        return variables;
    }

    private static boolean isTypeWithLiteralParameters(TypeSignature typeSignature) {
        return typeSignature.getParameters().stream().map(TypeSignatureParameter::getKind).allMatch(kind -> kind == ParameterKind.LONG || kind == ParameterKind.VARIABLE);
    }

    private Optional<BoundVariables> iterativeSolve(List<TypeConstraintSolver> constraints) {
        BoundVariables.Builder boundVariablesBuilder = BoundVariables.builder();
        int i = 0;
        block6: while (true) {
            if (i == 4) {
                throw new VerifyException(String.format("SignatureBinder.iterativeSolve does not converge after %d iterations.", 4));
            }
            SolverReturnStatusMerger statusMerger = new SolverReturnStatusMerger();
            for (TypeConstraintSolver constraint : constraints) {
                statusMerger.add(constraint.update(boundVariablesBuilder));
                if (statusMerger.getCurrent() != SolverReturnStatus.UNSOLVABLE) continue;
                return Optional.empty();
            }
            switch (statusMerger.getCurrent()) {
                case UNCHANGED_SATISFIED: {
                    break block6;
                }
                case UNCHANGED_NOT_SATISFIED: {
                    return Optional.empty();
                }
                case CHANGED: {
                    break;
                }
                case UNSOLVABLE: {
                    throw new VerifyException();
                }
                default: {
                    throw new UnsupportedOperationException("unknown status");
                }
            }
            ++i;
        }
        this.calculateVariableValuesForLongConstraints(boundVariablesBuilder);
        BoundVariables boundVariables = boundVariablesBuilder.build();
        if (!this.allTypeVariablesBound(boundVariables)) {
            return Optional.empty();
        }
        return Optional.of(boundVariables);
    }

    private void calculateVariableValuesForLongConstraints(BoundVariables.Builder variableBinder) {
        for (LongVariableConstraint longVariableConstraint : this.declaredSignature.getLongVariableConstraints()) {
            String calculation = longVariableConstraint.getExpression();
            String variableName = longVariableConstraint.getName();
            Long calculatedValue = TypeCalculation.calculateLiteralValue((String)calculation, variableBinder.getLongVariables());
            if (variableBinder.containsLongVariable(variableName)) {
                Long currentValue = variableBinder.getLongVariable(variableName);
                Preconditions.checkState((boolean)Objects.equals(currentValue, calculatedValue), (String)"variable '%s' is already set to %s when trying to set %s", (Object)variableName, (Object)currentValue, (Object)calculatedValue);
            }
            variableBinder.setLongVariable(variableName, calculatedValue);
        }
    }

    private boolean allTypeVariablesBound(BoundVariables boundVariables) {
        return boundVariables.getTypeVariables().keySet().equals(this.typeVariableConstraints.keySet());
    }

    private static TypeSignatureParameter applyBoundVariables(TypeSignatureParameter parameter, BoundVariables boundVariables) {
        ParameterKind parameterKind = parameter.getKind();
        switch (parameterKind) {
            case TYPE: {
                TypeSignature typeSignature = parameter.getTypeSignature();
                return TypeSignatureParameter.of((TypeSignature)SignatureBinder.applyBoundVariables(typeSignature, boundVariables));
            }
            case NAMED_TYPE: {
                NamedTypeSignature namedTypeSignature = parameter.getNamedTypeSignature();
                TypeSignature typeSignature = namedTypeSignature.getTypeSignature();
                return TypeSignatureParameter.of((NamedTypeSignature)new NamedTypeSignature(namedTypeSignature.getFieldName(), SignatureBinder.applyBoundVariables(typeSignature, boundVariables)));
            }
            case VARIABLE: {
                String variableName = parameter.getVariable();
                Preconditions.checkState((boolean)boundVariables.containsLongVariable(variableName), (String)"Variable is not bound: %s", (Object)variableName);
                Long variableValue = boundVariables.getLongVariable(variableName);
                return TypeSignatureParameter.of((long)variableValue);
            }
            case LONG: {
                return parameter;
            }
        }
        throw new IllegalStateException("Unknown parameter kind: " + parameter.getKind());
    }

    private static List<TypeSignature> expandVarargFormalTypeSignature(List<TypeSignature> formalTypeSignatures, int actualArity) {
        int variableArityArgumentsCount = actualArity - formalTypeSignatures.size() + 1;
        if (variableArityArgumentsCount == 0) {
            return formalTypeSignatures.subList(0, formalTypeSignatures.size() - 1);
        }
        if (variableArityArgumentsCount == 1) {
            return formalTypeSignatures;
        }
        Preconditions.checkArgument((variableArityArgumentsCount > 1 && !formalTypeSignatures.isEmpty() ? 1 : 0) != 0);
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll(formalTypeSignatures);
        TypeSignature lastTypeSignature = formalTypeSignatures.get(formalTypeSignatures.size() - 1);
        for (int i = 1; i < variableArityArgumentsCount; ++i) {
            builder.add((Object)lastTypeSignature);
        }
        return builder.build();
    }

    private boolean satisfiesCoercion(boolean allowCoercion, Type fromType, TypeSignature toTypeSignature) {
        if (allowCoercion) {
            return this.typeManager.canCoerce(fromType, this.typeManager.getType(toTypeSignature));
        }
        return fromType.getTypeSignature().equals((Object)toTypeSignature);
    }

    private static List<TypeSignature> getLambdaArgumentTypeSignatures(TypeSignature lambdaTypeSignature) {
        List typeParameters = lambdaTypeSignature.getTypeParametersAsTypeSignatures();
        return typeParameters.subList(0, typeParameters.size() - 1);
    }

    private boolean appendTypeRelationshipConstraintSolver(ImmutableList.Builder<TypeConstraintSolver> resultBuilder, TypeSignature formalTypeSignature, TypeSignatureProvider actualTypeSignatureProvider, boolean allowCoercion) {
        if (actualTypeSignatureProvider.hasDependency()) {
            return "function".equals(formalTypeSignature.getBase());
        }
        Set<String> typeVariables = this.typeVariablesOf(formalTypeSignature);
        Set<String> longVariables = SignatureBinder.longVariablesOf(formalTypeSignature);
        resultBuilder.add((Object)new TypeRelationshipConstraintSolver(formalTypeSignature, typeVariables, longVariables, this.typeManager.getType(actualTypeSignatureProvider.getTypeSignature()), allowCoercion));
        return true;
    }

    private class TypeRelationshipConstraintSolver
    implements TypeConstraintSolver {
        private final TypeSignature superTypeSignature;
        private final Set<String> typeVariables;
        private final Set<String> longVariables;
        private final Type actualType;
        private final boolean allowCoercion;

        public TypeRelationshipConstraintSolver(TypeSignature superTypeSignature, Set<String> typeVariables, Set<String> longVariables, Type actualType, boolean allowCoercion) {
            this.superTypeSignature = superTypeSignature;
            this.typeVariables = typeVariables;
            this.longVariables = longVariables;
            this.actualType = actualType;
            this.allowCoercion = allowCoercion;
        }

        @Override
        public SolverReturnStatus update(BoundVariables.Builder bindings) {
            for (String variable : this.typeVariables) {
                if (bindings.containsTypeVariable(variable)) continue;
                return SolverReturnStatus.UNCHANGED_NOT_SATISFIED;
            }
            for (String variable : this.longVariables) {
                if (bindings.containsLongVariable(variable)) continue;
                return SolverReturnStatus.UNCHANGED_NOT_SATISFIED;
            }
            TypeSignature boundSignature = SignatureBinder.applyBoundVariables(this.superTypeSignature, bindings.build());
            return SignatureBinder.this.satisfiesCoercion(this.allowCoercion, this.actualType, boundSignature) ? SolverReturnStatus.UNCHANGED_SATISFIED : SolverReturnStatus.UNCHANGED_NOT_SATISFIED;
        }
    }

    private class FunctionSolver
    implements TypeConstraintSolver {
        private final List<TypeSignature> formalLambdaArgumentsTypeSignature;
        private final TypeSignature formalLambdaReturnTypeSignature;
        private final TypeSignatureProvider typeSignatureProvider;

        public FunctionSolver(List<TypeSignature> formalLambdaArgumentsTypeSignature, TypeSignature formalLambdaReturnTypeSignature, TypeSignatureProvider typeSignatureProvider) {
            this.formalLambdaArgumentsTypeSignature = formalLambdaArgumentsTypeSignature;
            this.formalLambdaReturnTypeSignature = formalLambdaReturnTypeSignature;
            this.typeSignatureProvider = typeSignatureProvider;
        }

        @Override
        public SolverReturnStatus update(BoundVariables.Builder bindings) {
            TypeSignature actualLambdaTypeSignature;
            Optional<List<Type>> lambdaArgumentTypes = this.synthesizeLambdaArgumentTypes(bindings, this.formalLambdaArgumentsTypeSignature);
            if (!lambdaArgumentTypes.isPresent()) {
                return SolverReturnStatus.UNCHANGED_NOT_SATISFIED;
            }
            if (!this.typeSignatureProvider.hasDependency()) {
                actualLambdaTypeSignature = this.typeSignatureProvider.getTypeSignature();
                if (!"function".equals(actualLambdaTypeSignature.getBase()) || !SignatureBinder.getLambdaArgumentTypeSignatures(actualLambdaTypeSignature).equals(this.toTypeSignatures(lambdaArgumentTypes.get()))) {
                    return SolverReturnStatus.UNSOLVABLE;
                }
            } else {
                actualLambdaTypeSignature = this.typeSignatureProvider.getTypeSignature(lambdaArgumentTypes.get());
                if (!"function".equals(actualLambdaTypeSignature.getBase())) {
                    return SolverReturnStatus.UNSOLVABLE;
                }
                Verify.verify((boolean)SignatureBinder.getLambdaArgumentTypeSignatures(actualLambdaTypeSignature).equals(this.toTypeSignatures(lambdaArgumentTypes.get())));
            }
            Type actualLambdaType = SignatureBinder.this.typeManager.getType(actualLambdaTypeSignature);
            Type actualReturnType = ((FunctionType)actualLambdaType).getReturnType();
            ImmutableList.Builder constraintsBuilder = ImmutableList.builder();
            if (!SignatureBinder.this.appendTypeRelationshipConstraintSolver((ImmutableList.Builder<TypeConstraintSolver>)constraintsBuilder, this.formalLambdaReturnTypeSignature, new TypeSignatureProvider(actualReturnType.getTypeSignature()), false)) {
                return SolverReturnStatus.UNSOLVABLE;
            }
            if (!SignatureBinder.this.appendConstraintSolvers((ImmutableList.Builder<TypeConstraintSolver>)constraintsBuilder, this.formalLambdaReturnTypeSignature, new TypeSignatureProvider(actualReturnType.getTypeSignature()), SignatureBinder.this.allowCoercion)) {
                return SolverReturnStatus.UNSOLVABLE;
            }
            SolverReturnStatusMerger statusMerger = new SolverReturnStatusMerger();
            for (TypeConstraintSolver constraint : constraintsBuilder.build()) {
                statusMerger.add(constraint.update(bindings));
                if (statusMerger.getCurrent() != SolverReturnStatus.UNSOLVABLE) continue;
                return SolverReturnStatus.UNSOLVABLE;
            }
            return statusMerger.getCurrent();
        }

        private Optional<List<Type>> synthesizeLambdaArgumentTypes(BoundVariables.Builder bindings, List<TypeSignature> formalLambdaArgumentTypeSignatures) {
            ImmutableList.Builder lambdaArgumentTypesBuilder = ImmutableList.builder();
            for (TypeSignature lambdaArgument : formalLambdaArgumentTypeSignatures) {
                if (SignatureBinder.this.typeVariableConstraints.containsKey(lambdaArgument.getBase())) {
                    if (!bindings.containsTypeVariable(lambdaArgument.getBase())) {
                        return Optional.empty();
                    }
                    Type typeVariable = bindings.getTypeVariable(lambdaArgument.getBase());
                    lambdaArgumentTypesBuilder.add((Object)typeVariable);
                    continue;
                }
                lambdaArgumentTypesBuilder.add((Object)SignatureBinder.this.typeManager.getType(lambdaArgument));
            }
            return Optional.of(lambdaArgumentTypesBuilder.build());
        }

        private List<TypeSignature> toTypeSignatures(List<Type> types) {
            return (List)types.stream().map(Type::getTypeSignature).collect(ImmutableList.toImmutableList());
        }
    }

    private class TypeWithLiteralParametersSolver
    implements TypeConstraintSolver {
        private final TypeSignature formalTypeSignature;
        private final Type actualType;

        public TypeWithLiteralParametersSolver(TypeSignature formalTypeSignature, Type actualType) {
            this.formalTypeSignature = formalTypeSignature;
            this.actualType = actualType;
        }

        @Override
        public SolverReturnStatus update(BoundVariables.Builder bindings) {
            ImmutableList.Builder originalTypeTypeParametersBuilder = ImmutableList.builder();
            List parameters = this.formalTypeSignature.getParameters();
            for (int i = 0; i < parameters.size(); ++i) {
                TypeSignatureParameter typeSignatureParameter = (TypeSignatureParameter)parameters.get(i);
                if (typeSignatureParameter.getKind() == ParameterKind.VARIABLE) {
                    if (bindings.containsLongVariable(typeSignatureParameter.getVariable())) {
                        originalTypeTypeParametersBuilder.add((Object)TypeSignatureParameter.of((long)bindings.getLongVariable(typeSignatureParameter.getVariable())));
                        continue;
                    }
                    Optional type = SignatureBinder.this.typeManager.coerceTypeBase(this.actualType, this.formalTypeSignature.getBase());
                    if (!type.isPresent()) {
                        return SolverReturnStatus.UNSOLVABLE;
                    }
                    TypeSignature typeSignature = ((Type)type.get()).getTypeSignature();
                    originalTypeTypeParametersBuilder.add((Object)TypeSignatureParameter.of((long)((TypeSignatureParameter)typeSignature.getParameters().get(i)).getLongLiteral()));
                    continue;
                }
                Verify.verify((typeSignatureParameter.getKind() == ParameterKind.LONG ? 1 : 0) != 0);
                originalTypeTypeParametersBuilder.add((Object)typeSignatureParameter);
            }
            Type originalType = SignatureBinder.this.typeManager.getType(new TypeSignature(this.formalTypeSignature.getBase(), (List)originalTypeTypeParametersBuilder.build()));
            Optional commonSuperType = SignatureBinder.this.typeManager.getCommonSuperType(originalType, this.actualType);
            if (!commonSuperType.isPresent()) {
                return SolverReturnStatus.UNSOLVABLE;
            }
            TypeSignature commonSuperTypeSignature = ((Type)commonSuperType.get()).getTypeSignature();
            if (!commonSuperTypeSignature.getBase().equals(this.formalTypeSignature.getBase())) {
                return SolverReturnStatus.UNSOLVABLE;
            }
            SolverReturnStatus result = SolverReturnStatus.UNCHANGED_SATISFIED;
            for (int i = 0; i < parameters.size(); ++i) {
                TypeSignatureParameter typeSignatureParameter = (TypeSignatureParameter)parameters.get(i);
                long commonSuperLongLiteral = ((TypeSignatureParameter)commonSuperTypeSignature.getParameters().get(i)).getLongLiteral();
                if (typeSignatureParameter.getKind() == ParameterKind.VARIABLE) {
                    String variableName = typeSignatureParameter.getVariable();
                    if (bindings.containsLongVariable(variableName) && bindings.getLongVariable(variableName).equals(commonSuperLongLiteral)) continue;
                    bindings.setLongVariable(variableName, commonSuperLongLiteral);
                    result = SolverReturnStatus.CHANGED;
                    continue;
                }
                Verify.verify((typeSignatureParameter.getKind() == ParameterKind.LONG ? 1 : 0) != 0);
                if (commonSuperLongLiteral == typeSignatureParameter.getLongLiteral()) continue;
                return SolverReturnStatus.UNSOLVABLE;
            }
            return result;
        }
    }

    private class TypeParameterSolver
    implements TypeConstraintSolver {
        private final String typeParameter;
        private final Type actualType;
        private final boolean comparableRequired;
        private final boolean orderableRequired;
        private final Optional<String> requiredBaseName;

        public TypeParameterSolver(String typeParameter, Type actualType, boolean comparableRequired, boolean orderableRequired, Optional<String> requiredBaseName) {
            this.typeParameter = typeParameter;
            this.actualType = actualType;
            this.comparableRequired = comparableRequired;
            this.orderableRequired = orderableRequired;
            this.requiredBaseName = requiredBaseName;
        }

        @Override
        public SolverReturnStatus update(BoundVariables.Builder bindings) {
            if (!bindings.containsTypeVariable(this.typeParameter)) {
                if (!this.satisfiesConstraints(this.actualType)) {
                    return SolverReturnStatus.UNSOLVABLE;
                }
                bindings.setTypeVariable(this.typeParameter, this.actualType);
                return SolverReturnStatus.CHANGED;
            }
            Type originalType = bindings.getTypeVariable(this.typeParameter);
            Optional commonSuperType = SignatureBinder.this.typeManager.getCommonSuperType(originalType, this.actualType);
            if (!commonSuperType.isPresent()) {
                return SolverReturnStatus.UNSOLVABLE;
            }
            if (!this.satisfiesConstraints((Type)commonSuperType.get())) {
                return SolverReturnStatus.UNSOLVABLE;
            }
            if (((Type)commonSuperType.get()).equals(originalType)) {
                return SolverReturnStatus.UNCHANGED_SATISFIED;
            }
            bindings.setTypeVariable(this.typeParameter, (Type)commonSuperType.get());
            return SolverReturnStatus.CHANGED;
        }

        private boolean satisfiesConstraints(Type type) {
            if (this.comparableRequired && !type.isComparable()) {
                return false;
            }
            if (this.orderableRequired && !type.isOrderable()) {
                return false;
            }
            return !this.requiredBaseName.isPresent() || UnknownType.UNKNOWN.equals(type) || this.requiredBaseName.get().equals(type.getTypeSignature().getBase());
        }
    }

    private class SolverReturnStatusMerger {
        private SolverReturnStatus current = SolverReturnStatus.UNCHANGED_SATISFIED;

        private SolverReturnStatusMerger() {
        }

        public void add(SolverReturnStatus newStatus) {
            switch (newStatus) {
                case UNCHANGED_SATISFIED: {
                    break;
                }
                case UNCHANGED_NOT_SATISFIED: {
                    if (this.current != SolverReturnStatus.UNCHANGED_SATISFIED) break;
                    this.current = SolverReturnStatus.UNCHANGED_NOT_SATISFIED;
                    break;
                }
                case CHANGED: {
                    if (this.current != SolverReturnStatus.UNCHANGED_SATISFIED && this.current != SolverReturnStatus.UNCHANGED_NOT_SATISFIED) break;
                    this.current = SolverReturnStatus.CHANGED;
                    break;
                }
                case UNSOLVABLE: {
                    this.current = SolverReturnStatus.UNSOLVABLE;
                }
            }
        }

        public SolverReturnStatus getCurrent() {
            return this.current;
        }
    }

    private static enum SolverReturnStatus {
        UNCHANGED_SATISFIED,
        UNCHANGED_NOT_SATISFIED,
        CHANGED,
        UNSOLVABLE;

    }

    private static interface TypeConstraintSolver {
        public SolverReturnStatus update(BoundVariables.Builder var1);
    }
}

