/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.ByteArrayBlock;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;

public class EnforceSingleRowOperator
implements Operator {
    private static final Page SINGLE_NULL_VALUE_PAGE = new Page(1, new Block[]{new ByteArrayBlock(1, Optional.of(new boolean[]{true}), new byte[1])});
    private final OperatorContext operatorContext;
    private boolean finishing;
    private Page page;

    public EnforceSingleRowOperator(OperatorContext operatorContext) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public void finish() {
        if (!this.finishing && this.page == null) {
            this.page = SINGLE_NULL_VALUE_PAGE;
        }
        this.finishing = true;
    }

    @Override
    public boolean isFinished() {
        return this.finishing && this.page == null;
    }

    @Override
    public boolean needsInput() {
        return !this.finishing;
    }

    @Override
    public void addInput(Page page) {
        Objects.requireNonNull(page, "page is null");
        Preconditions.checkState((boolean)this.needsInput(), (Object)"Operator did not expect any more data");
        if (page.getPositionCount() == 0) {
            return;
        }
        if (this.page != null || page.getPositionCount() > 1) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.SUBQUERY_MULTIPLE_ROWS, "Scalar sub-query has returned multiple rows");
        }
        this.page = page;
    }

    @Override
    public Page getOutput() {
        if (!this.finishing) {
            return null;
        }
        Preconditions.checkState((this.page != null ? 1 : 0) != 0, (Object)"Operator is already done");
        Page pageToReturn = this.page;
        this.page = null;
        return pageToReturn;
    }

    public static class EnforceSingleRowOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private boolean closed;

        public EnforceSingleRowOperatorFactory(int operatorId, PlanNodeId planNodeId) {
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, this.planNodeId, EnforceSingleRowOperator.class.getSimpleName());
            return new EnforceSingleRowOperator(operatorContext);
        }

        @Override
        public void noMoreOperators() {
            this.closed = true;
        }

        @Override
        public OperatorFactory duplicate() {
            return new EnforceSingleRowOperatorFactory(this.operatorId, this.planNodeId);
        }
    }
}

