/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.memory.context.AggregatedMemoryContext;
import com.facebook.presto.operator.DriverYieldSignal;
import com.facebook.presto.operator.HashGenerator;
import com.facebook.presto.operator.InterpretedHashGenerator;
import com.facebook.presto.operator.PageWithPositionComparator;
import com.facebook.presto.operator.WorkProcessor;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.util.MergeSortedPages;
import com.google.common.collect.ImmutableList;
import java.io.Closeable;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.stream.IntStream;

public class MergeHashSort
implements Closeable {
    private final AggregatedMemoryContext memoryContext;

    public MergeHashSort(AggregatedMemoryContext memoryContext) {
        this.memoryContext = memoryContext;
    }

    public WorkProcessor<Page> merge(List<Type> keyTypes, List<Type> allTypes, List<WorkProcessor<Page>> channels, DriverYieldSignal driverYieldSignal) {
        InterpretedHashGenerator hashGenerator = MergeHashSort.createHashGenerator(keyTypes);
        return MergeSortedPages.mergeSortedPages(channels, MergeHashSort.createHashPageWithPositionComparator(hashGenerator), (List)IntStream.range(0, allTypes.size()).boxed().collect(ImmutableList.toImmutableList()), allTypes, MergeHashSort.keepSameHashValuesWithinSinglePage(hashGenerator), true, this.memoryContext, driverYieldSignal);
    }

    @Override
    public void close() {
        this.memoryContext.close();
    }

    private static BiPredicate<PageBuilder, MergeSortedPages.PageWithPosition> keepSameHashValuesWithinSinglePage(InterpretedHashGenerator hashGenerator) {
        return (pageBuilder, pageWithPosition) -> {
            long hash = hashGenerator.hashPosition(pageWithPosition.getPosition(), pageWithPosition.getPage());
            if (pageBuilder.isEmpty()) return false;
            if (hashGenerator.hashPosition(pageBuilder.getPositionCount() - 1, arg_0 -> ((PageBuilder)pageBuilder).getBlockBuilder(arg_0)) == hash) return false;
            if (!pageBuilder.isFull()) return false;
            return true;
        };
    }

    private static PageWithPositionComparator createHashPageWithPositionComparator(HashGenerator hashGenerator) {
        return (leftPage, leftPosition, rightPage, rightPosition) -> {
            long leftHash = hashGenerator.hashPosition(leftPosition, leftPage);
            long rightHash = hashGenerator.hashPosition(rightPosition, rightPage);
            return Long.compare(leftHash, rightHash);
        };
    }

    private static InterpretedHashGenerator createHashGenerator(List<Type> keyTypes) {
        int[] hashChannels = new int[keyTypes.size()];
        for (int i = 0; i < keyTypes.size(); ++i) {
            hashChannels[i] = i;
        }
        return new InterpretedHashGenerator(keyTypes, hashChannels);
    }
}

