/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.PagesHashStrategy;
import com.facebook.presto.operator.PositionLinks;
import com.facebook.presto.operator.SyntheticAddress;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.util.HashCollisionsEstimator;
import io.airlift.slice.SizeOf;
import io.airlift.units.DataSize;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.util.Arrays;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;

public final class PagesHash {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(PagesHash.class).instanceSize();
    private static final DataSize CACHE_SIZE = new DataSize(128.0, DataSize.Unit.KILOBYTE);
    private final LongArrayList addresses;
    private final PagesHashStrategy pagesHashStrategy;
    private final int channelCount;
    private final int mask;
    private final int[] key;
    private final long size;
    private final byte[] positionToHashes;
    private final long hashCollisions;
    private final double expectedHashCollisions;

    public PagesHash(LongArrayList addresses, PagesHashStrategy pagesHashStrategy, PositionLinks.FactoryBuilder positionLinks) {
        this.addresses = Objects.requireNonNull(addresses, "addresses is null");
        this.pagesHashStrategy = Objects.requireNonNull(pagesHashStrategy, "pagesHashStrategy is null");
        this.channelCount = pagesHashStrategy.getChannelCount();
        int hashSize = HashCommon.arraySize((int)addresses.size(), (float)0.75f);
        this.mask = hashSize - 1;
        this.key = new int[hashSize];
        Arrays.fill(this.key, -1);
        this.positionToHashes = new byte[addresses.size()];
        int positionsInStep = Math.min(addresses.size() + 1, (int)CACHE_SIZE.toBytes() / 32);
        long[] positionToFullHashes = new long[positionsInStep];
        long hashCollisionsLocal = 0L;
        int step = 0;
        while (step * positionsInStep <= addresses.size()) {
            long hash;
            int realPosition;
            int position;
            int stepBeginPosition = step * positionsInStep;
            int stepEndPosition = Math.min((step + 1) * positionsInStep, addresses.size());
            int stepSize = stepEndPosition - stepBeginPosition;
            for (position = 0; position < stepSize; ++position) {
                realPosition = position + stepBeginPosition;
                positionToFullHashes[position] = hash = this.readHashPosition(realPosition);
                this.positionToHashes[realPosition] = (byte)hash;
            }
            for (position = 0; position < stepSize; ++position) {
                realPosition = position + stepBeginPosition;
                if (this.isPositionNull(realPosition)) continue;
                hash = positionToFullHashes[position];
                int pos = PagesHash.getHashPosition(hash, this.mask);
                while (this.key[pos] != -1) {
                    int currentKey = this.key[pos];
                    if ((byte)hash == this.positionToHashes[currentKey] && this.positionEqualsPositionIgnoreNulls(currentKey, realPosition)) {
                        realPosition = positionLinks.link(realPosition, currentKey);
                        break;
                    }
                    pos = pos + 1 & this.mask;
                    ++hashCollisionsLocal;
                }
                this.key[pos] = realPosition;
            }
            ++step;
        }
        this.size = SizeOf.sizeOf((long[])addresses.elements()) + pagesHashStrategy.getSizeInBytes() + SizeOf.sizeOf((int[])this.key) + SizeOf.sizeOf((byte[])this.positionToHashes);
        this.hashCollisions = hashCollisionsLocal;
        this.expectedHashCollisions = HashCollisionsEstimator.estimateNumberOfHashCollisions(addresses.size(), hashSize);
    }

    public final int getChannelCount() {
        return this.channelCount;
    }

    public int getPositionCount() {
        return this.addresses.size();
    }

    public long getInMemorySizeInBytes() {
        return (long)INSTANCE_SIZE + this.size;
    }

    public long getHashCollisions() {
        return this.hashCollisions;
    }

    public double getExpectedHashCollisions() {
        return this.expectedHashCollisions;
    }

    public int getAddressIndex(int position, Page hashChannelsPage) {
        return this.getAddressIndex(position, hashChannelsPage, this.pagesHashStrategy.hashRow(position, hashChannelsPage));
    }

    public int getAddressIndex(int rightPosition, Page hashChannelsPage, long rawHash) {
        int pos = PagesHash.getHashPosition(rawHash, this.mask);
        while (this.key[pos] != -1) {
            if (this.positionEqualsCurrentRowIgnoreNulls(this.key[pos], (byte)rawHash, rightPosition, hashChannelsPage)) {
                return this.key[pos];
            }
            pos = pos + 1 & this.mask;
        }
        return -1;
    }

    public void appendTo(long position, PageBuilder pageBuilder, int outputChannelOffset) {
        long pageAddress = this.addresses.getLong(Math.toIntExact(position));
        int blockIndex = SyntheticAddress.decodeSliceIndex(pageAddress);
        int blockPosition = SyntheticAddress.decodePosition(pageAddress);
        this.pagesHashStrategy.appendTo(blockIndex, blockPosition, pageBuilder, outputChannelOffset);
    }

    private boolean isPositionNull(int position) {
        long pageAddress = this.addresses.getLong(position);
        int blockIndex = SyntheticAddress.decodeSliceIndex(pageAddress);
        int blockPosition = SyntheticAddress.decodePosition(pageAddress);
        return this.pagesHashStrategy.isPositionNull(blockIndex, blockPosition);
    }

    private long readHashPosition(int position) {
        long pageAddress = this.addresses.getLong(position);
        int blockIndex = SyntheticAddress.decodeSliceIndex(pageAddress);
        int blockPosition = SyntheticAddress.decodePosition(pageAddress);
        return this.pagesHashStrategy.hashPosition(blockIndex, blockPosition);
    }

    private boolean positionEqualsCurrentRowIgnoreNulls(int leftPosition, byte rawHash, int rightPosition, Page rightPage) {
        if (this.positionToHashes[leftPosition] != rawHash) {
            return false;
        }
        long pageAddress = this.addresses.getLong(leftPosition);
        int blockIndex = SyntheticAddress.decodeSliceIndex(pageAddress);
        int blockPosition = SyntheticAddress.decodePosition(pageAddress);
        return this.pagesHashStrategy.positionEqualsRowIgnoreNulls(blockIndex, blockPosition, rightPosition, rightPage);
    }

    private boolean positionEqualsPositionIgnoreNulls(int leftPosition, int rightPosition) {
        long leftPageAddress = this.addresses.getLong(leftPosition);
        int leftBlockIndex = SyntheticAddress.decodeSliceIndex(leftPageAddress);
        int leftBlockPosition = SyntheticAddress.decodePosition(leftPageAddress);
        long rightPageAddress = this.addresses.getLong(rightPosition);
        int rightBlockIndex = SyntheticAddress.decodeSliceIndex(rightPageAddress);
        int rightBlockPosition = SyntheticAddress.decodePosition(rightPageAddress);
        return this.pagesHashStrategy.positionEqualsPositionIgnoreNulls(leftBlockIndex, leftBlockPosition, rightBlockIndex, rightBlockPosition);
    }

    private static int getHashPosition(long rawHash, long mask) {
        rawHash ^= rawHash >>> 33;
        rawHash *= -49064778989728563L;
        rawHash ^= rawHash >>> 33;
        rawHash *= -4265267296055464877L;
        rawHash ^= rawHash >>> 33;
        return (int)(rawHash & mask);
    }
}

