/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.PagesSpatialIndex;
import com.facebook.presto.operator.ReferenceCount;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class PagesSpatialIndexFactory {
    private final List<Type> types;
    private final List<Type> outputTypes;
    @GuardedBy(value="this")
    private final List<SettableFuture<PagesSpatialIndex>> pagesSpatialIndexFutures = new ArrayList<SettableFuture<PagesSpatialIndex>>();
    @Nullable
    @GuardedBy(value="this")
    private Supplier<PagesSpatialIndex> pagesSpatialIndex;
    private final ReferenceCount activeProbeOperators = new ReferenceCount(1);

    public PagesSpatialIndexFactory(List<Type> types, List<Type> outputTypes) {
        this.types = ImmutableList.copyOf(types);
        this.outputTypes = ImmutableList.copyOf(outputTypes);
    }

    public List<Type> getTypes() {
        return this.types;
    }

    public List<Type> getOutputTypes() {
        return this.outputTypes;
    }

    public synchronized ListenableFuture<PagesSpatialIndex> createPagesSpatialIndex() {
        this.activeProbeOperators.retain();
        if (this.pagesSpatialIndex != null) {
            return Futures.immediateFuture((Object)this.pagesSpatialIndex.get());
        }
        SettableFuture future = SettableFuture.create();
        this.pagesSpatialIndexFutures.add((SettableFuture<PagesSpatialIndex>)future);
        return future;
    }

    public synchronized void addProbeOperatorFactory() {
        this.activeProbeOperators.retain();
    }

    public synchronized void noMoreProbeOperators() {
        this.activeProbeOperators.release();
        if (this.activeProbeOperators.getFreeFuture().isDone()) {
            this.pagesSpatialIndex = null;
        }
    }

    public synchronized void probeOperatorFinished() {
        this.activeProbeOperators.release();
        if (this.activeProbeOperators.getFreeFuture().isDone()) {
            this.pagesSpatialIndex = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<?> lendPagesSpatialIndex(Supplier<PagesSpatialIndex> pagesSpatialIndex) {
        ImmutableList settableFutures;
        Objects.requireNonNull(pagesSpatialIndex, "pagesSpatialIndex is null");
        if (this.activeProbeOperators.getFreeFuture().isDone()) {
            return Operator.NOT_BLOCKED;
        }
        PagesSpatialIndexFactory pagesSpatialIndexFactory = this;
        synchronized (pagesSpatialIndexFactory) {
            Verify.verify((this.pagesSpatialIndex == null ? 1 : 0) != 0);
            this.pagesSpatialIndex = pagesSpatialIndex;
            settableFutures = ImmutableList.copyOf(this.pagesSpatialIndexFutures);
            this.pagesSpatialIndexFutures.clear();
        }
        for (SettableFuture settableFuture : settableFutures) {
            settableFuture.set((Object)pagesSpatialIndex.get());
        }
        return this.activeProbeOperators.getFreeFuture();
    }
}

