/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.spi.plan.PlanNodeId;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class StageExecutionDescriptor {
    private final StageExecutionStrategy stageExecutionStrategy;
    private final Set<PlanNodeId> groupedExecutionScanNodes;
    private final int totalLifespans;

    private StageExecutionDescriptor(StageExecutionStrategy stageExecutionStrategy, Set<PlanNodeId> groupedExecutionScanNodes, int totalLifespans) {
        switch (stageExecutionStrategy) {
            case UNGROUPED_EXECUTION: {
                Preconditions.checkArgument((boolean)groupedExecutionScanNodes.isEmpty(), (Object)"groupedExecutionScanNodes must be empty if stage execution strategy is ungrouped execution");
                break;
            }
            case FIXED_LIFESPAN_SCHEDULE_GROUPED_EXECUTION: 
            case DYNAMIC_LIFESPAN_SCHEDULE_GROUPED_EXECUTION: 
            case RECOVERABLE_GROUPED_EXECUTION: {
                Preconditions.checkArgument((!groupedExecutionScanNodes.isEmpty() ? 1 : 0) != 0, (Object)"groupedExecutionScanNodes cannot be empty if stage execution strategy is grouped execution");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported stage execution strategy: " + (Object)((Object)stageExecutionStrategy));
            }
        }
        this.stageExecutionStrategy = Objects.requireNonNull(stageExecutionStrategy, "stageExecutionStrategy is null");
        this.groupedExecutionScanNodes = Objects.requireNonNull(groupedExecutionScanNodes, "groupedExecutionScanNodes is null");
        this.totalLifespans = totalLifespans;
    }

    public static StageExecutionDescriptor ungroupedExecution() {
        return new StageExecutionDescriptor(StageExecutionStrategy.UNGROUPED_EXECUTION, (Set<PlanNodeId>)ImmutableSet.of(), 1);
    }

    public static StageExecutionDescriptor fixedLifespanScheduleGroupedExecution(List<PlanNodeId> capableScanNodes, int totalLifespans) {
        Objects.requireNonNull(capableScanNodes, "capableScanNodes is null");
        Preconditions.checkArgument((!capableScanNodes.isEmpty() ? 1 : 0) != 0, (Object)"capableScanNodes cannot be empty if stage execution strategy is grouped execution");
        return new StageExecutionDescriptor(StageExecutionStrategy.FIXED_LIFESPAN_SCHEDULE_GROUPED_EXECUTION, (Set<PlanNodeId>)ImmutableSet.copyOf(capableScanNodes), totalLifespans);
    }

    public static StageExecutionDescriptor dynamicLifespanScheduleGroupedExecution(List<PlanNodeId> capableScanNodes, int totalLifespans) {
        Objects.requireNonNull(capableScanNodes, "capableScanNodes is null");
        Preconditions.checkArgument((!capableScanNodes.isEmpty() ? 1 : 0) != 0, (Object)"capableScanNodes cannot be empty if stage execution strategy is grouped execution");
        return new StageExecutionDescriptor(StageExecutionStrategy.DYNAMIC_LIFESPAN_SCHEDULE_GROUPED_EXECUTION, (Set<PlanNodeId>)ImmutableSet.copyOf(capableScanNodes), totalLifespans);
    }

    public static StageExecutionDescriptor recoverableGroupedExecution(List<PlanNodeId> capableScanNodes, int totalLifespans) {
        Objects.requireNonNull(capableScanNodes, "capableScanNodes is null");
        Preconditions.checkArgument((!capableScanNodes.isEmpty() ? 1 : 0) != 0, (Object)"capableScanNodes cannot be empty if stage execution strategy is grouped execution");
        return new StageExecutionDescriptor(StageExecutionStrategy.RECOVERABLE_GROUPED_EXECUTION, (Set<PlanNodeId>)ImmutableSet.copyOf(capableScanNodes), totalLifespans);
    }

    public StageExecutionStrategy getStageExecutionStrategy() {
        return this.stageExecutionStrategy;
    }

    public boolean isStageGroupedExecution() {
        return this.stageExecutionStrategy != StageExecutionStrategy.UNGROUPED_EXECUTION;
    }

    public boolean isDynamicLifespanSchedule() {
        return this.stageExecutionStrategy == StageExecutionStrategy.DYNAMIC_LIFESPAN_SCHEDULE_GROUPED_EXECUTION || this.stageExecutionStrategy == StageExecutionStrategy.RECOVERABLE_GROUPED_EXECUTION;
    }

    public boolean isScanGroupedExecution(PlanNodeId scanNodeId) {
        return this.groupedExecutionScanNodes.contains(scanNodeId);
    }

    public boolean isRecoverableGroupedExecution() {
        return this.stageExecutionStrategy == StageExecutionStrategy.RECOVERABLE_GROUPED_EXECUTION;
    }

    @JsonCreator
    public static StageExecutionDescriptor jsonCreator(@JsonProperty(value="stageExecutionStrategy") StageExecutionStrategy stageExecutionStrategy, @JsonProperty(value="groupedExecutionScanNodes") Set<PlanNodeId> groupedExecutionCapableScanNodes, @JsonProperty(value="totalLifespans") int totalLifespans) {
        return new StageExecutionDescriptor(Objects.requireNonNull(stageExecutionStrategy, "stageExecutionStrategy is null"), (Set<PlanNodeId>)ImmutableSet.copyOf((Collection)Objects.requireNonNull(groupedExecutionCapableScanNodes, "groupedExecutionScanNodes is null")), totalLifespans);
    }

    @JsonProperty(value="stageExecutionStrategy")
    public StageExecutionStrategy getJsonSerializableStageExecutionStrategy() {
        return this.stageExecutionStrategy;
    }

    @JsonProperty(value="groupedExecutionScanNodes")
    public Set<PlanNodeId> getJsonSerializableGroupedExecutionScanNodes() {
        return this.groupedExecutionScanNodes;
    }

    @JsonProperty(value="totalLifespans")
    public int getTotalLifespans() {
        return this.totalLifespans;
    }

    public static enum StageExecutionStrategy {
        UNGROUPED_EXECUTION,
        FIXED_LIFESPAN_SCHEDULE_GROUPED_EXECUTION,
        DYNAMIC_LIFESPAN_SCHEDULE_GROUPED_EXECUTION,
        RECOVERABLE_GROUPED_EXECUTION;

    }
}

