/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.exchange;

import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.PageWithPositionComparator;
import com.facebook.presto.operator.WorkProcessor;
import com.facebook.presto.operator.exchange.LocalExchange;
import com.facebook.presto.operator.exchange.LocalExchangeSource;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.block.SortOrder;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.gen.OrderingCompiler;
import com.facebook.presto.util.MergeSortedPages;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.IntStream;

public class LocalMergeSourceOperator
implements Operator {
    private final OperatorContext operatorContext;
    private final List<LocalExchangeSource> sources;
    private final WorkProcessor<Page> mergedPages;

    public LocalMergeSourceOperator(OperatorContext operatorContext, List<LocalExchangeSource> sources, List<Type> types, PageWithPositionComparator comparator) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.sources = Objects.requireNonNull(sources, "sources is null");
        List pageProducers = (List)sources.stream().map(LocalExchangeSource::pages).collect(ImmutableList.toImmutableList());
        this.mergedPages = MergeSortedPages.mergeSortedPages(pageProducers, Objects.requireNonNull(comparator, "comparator is null"), types, operatorContext.aggregateUserMemoryContext(), operatorContext.getDriverContext().getYieldSignal());
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public void finish() {
        this.sources.forEach(LocalExchangeSource::finish);
    }

    @Override
    public boolean isFinished() {
        return this.mergedPages.isFinished();
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        if (this.mergedPages.isBlocked()) {
            return this.mergedPages.getBlockedFuture();
        }
        return NOT_BLOCKED;
    }

    @Override
    public boolean needsInput() {
        return false;
    }

    @Override
    public void addInput(Page page) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Page getOutput() {
        if (!this.mergedPages.process() || this.mergedPages.isFinished()) {
            return null;
        }
        Page page = this.mergedPages.getResult();
        this.operatorContext.recordProcessedInput(page.getSizeInBytes(), page.getPositionCount());
        return page;
    }

    @Override
    public void close() throws IOException {
        this.sources.forEach(LocalExchangeSource::close);
    }

    public static class LocalMergeSourceOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final LocalExchange.LocalExchangeFactory localExchangeFactory;
        private final List<Type> types;
        private final OrderingCompiler orderingCompiler;
        private final List<Integer> sortChannels;
        private final List<SortOrder> orderings;
        private boolean closed;

        public LocalMergeSourceOperatorFactory(int operatorId, PlanNodeId planNodeId, LocalExchange.LocalExchangeFactory localExchangeFactory, List<Type> types, OrderingCompiler orderingCompiler, List<Integer> sortChannels, List<SortOrder> orderings) {
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            this.localExchangeFactory = Objects.requireNonNull(localExchangeFactory, "exchange is null");
            this.types = ImmutableList.copyOf((Collection)Objects.requireNonNull(types, "types is null"));
            this.orderingCompiler = Objects.requireNonNull(orderingCompiler, "orderingCompiler is null");
            this.sortChannels = ImmutableList.copyOf((Collection)Objects.requireNonNull(sortChannels, "sortChannels is null"));
            this.orderings = ImmutableList.copyOf((Collection)Objects.requireNonNull(orderings, "orderings is null"));
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            LocalExchange localExchange = this.localExchangeFactory.getLocalExchange(driverContext.getLifespan());
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, this.planNodeId, LocalMergeSourceOperator.class.getSimpleName());
            PageWithPositionComparator comparator = this.orderingCompiler.compilePageWithPositionComparator(this.types, this.sortChannels, this.orderings);
            List sources = (List)IntStream.range(0, localExchange.getBufferCount()).boxed().map(index -> localExchange.getNextSource()).collect(ImmutableList.toImmutableList());
            return new LocalMergeSourceOperator(operatorContext, sources, this.types, comparator);
        }

        @Override
        public void noMoreOperators() {
            this.closed = true;
        }

        @Override
        public OperatorFactory duplicate() {
            throw new UnsupportedOperationException("Source operator factories can not be duplicated");
        }
    }
}

