/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.index;

import com.facebook.presto.Session;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.LookupSource;
import com.facebook.presto.operator.PagesIndex;
import com.facebook.presto.operator.index.IndexSnapshot;
import com.facebook.presto.operator.index.UnloadedIndexKeyRecordSet;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.gen.JoinFilterFunctionCompiler;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import io.airlift.units.DataSize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;

public class IndexSnapshotBuilder {
    private final Session session;
    private final int expectedPositions;
    private final List<Type> outputTypes;
    private final List<Type> missingKeysTypes;
    private final List<Integer> keyOutputChannels;
    private final OptionalInt keyOutputHashChannel;
    private final List<Integer> missingKeysChannels;
    private final PagesIndex.Factory pagesIndexFactory;
    private final long maxMemoryInBytes;
    private PagesIndex outputPagesIndex;
    private PagesIndex missingKeysIndex;
    private LookupSource missingKeys;
    private final List<Page> pages = new ArrayList<Page>();
    private long memoryInBytes;
    private final PageBuilder missingKeysPageBuilder;

    public IndexSnapshotBuilder(List<Type> outputTypes, List<Integer> keyOutputChannels, OptionalInt keyOutputHashChannel, DriverContext driverContext, DataSize maxMemoryInBytes, int expectedPositions, PagesIndex.Factory pagesIndexFactory) {
        Objects.requireNonNull(outputTypes, "outputTypes is null");
        Objects.requireNonNull(keyOutputChannels, "keyOutputChannels is null");
        Objects.requireNonNull(keyOutputHashChannel, "keyOutputHashChannel is null");
        Objects.requireNonNull(driverContext, "driverContext is null");
        Objects.requireNonNull(maxMemoryInBytes, "maxMemoryInBytes is null");
        Objects.requireNonNull(pagesIndexFactory, "pagesIndexFactory is null");
        Preconditions.checkArgument((expectedPositions > 0 ? 1 : 0) != 0, (Object)"expectedPositions must be greater than zero");
        this.pagesIndexFactory = pagesIndexFactory;
        this.session = driverContext.getSession();
        this.outputTypes = ImmutableList.copyOf(outputTypes);
        this.expectedPositions = expectedPositions;
        this.keyOutputChannels = ImmutableList.copyOf(keyOutputChannels);
        this.keyOutputHashChannel = keyOutputHashChannel;
        this.maxMemoryInBytes = maxMemoryInBytes.toBytes();
        ImmutableList.Builder missingKeysTypes = ImmutableList.builder();
        ImmutableList.Builder missingKeysChannels = ImmutableList.builder();
        for (int i = 0; i < keyOutputChannels.size(); ++i) {
            Integer keyOutputChannel = keyOutputChannels.get(i);
            missingKeysTypes.add((Object)outputTypes.get(keyOutputChannel));
            missingKeysChannels.add((Object)i);
        }
        this.missingKeysTypes = missingKeysTypes.build();
        this.missingKeysChannels = missingKeysChannels.build();
        this.outputPagesIndex = pagesIndexFactory.newPagesIndex(outputTypes, expectedPositions);
        this.missingKeysIndex = pagesIndexFactory.newPagesIndex((List<Type>)missingKeysTypes.build(), expectedPositions);
        this.missingKeys = this.missingKeysIndex.createLookupSourceSupplier(this.session, this.missingKeysChannels).get();
        this.missingKeysPageBuilder = new PageBuilder(this.missingKeysIndex.getTypes());
    }

    public List<Type> getOutputTypes() {
        return this.outputTypes;
    }

    public long getMemoryInBytes() {
        return this.memoryInBytes;
    }

    public boolean isMemoryExceeded() {
        return this.memoryInBytes > this.maxMemoryInBytes;
    }

    public boolean tryAddPage(Page page) {
        this.memoryInBytes += page.getSizeInBytes();
        if (this.isMemoryExceeded()) {
            return false;
        }
        this.pages.add(page);
        return true;
    }

    public IndexSnapshot createIndexSnapshot(UnloadedIndexKeyRecordSet indexKeysRecordSet) {
        Preconditions.checkArgument((boolean)indexKeysRecordSet.getColumnTypes().equals(this.missingKeysTypes), (Object)"indexKeysRecordSet must have same schema as missingKeys");
        Preconditions.checkState((!this.isMemoryExceeded() ? 1 : 0) != 0, (Object)"Max memory exceeded");
        for (Page page : this.pages) {
            this.outputPagesIndex.addPage(page);
        }
        this.pages.clear();
        LookupSource lookupSource = (LookupSource)this.outputPagesIndex.createLookupSourceSupplier(this.session, this.keyOutputChannels, this.keyOutputHashChannel, Optional.empty(), Optional.empty(), (List<JoinFilterFunctionCompiler.JoinFilterFunctionFactory>)ImmutableList.of()).get();
        Verify.verify((boolean)this.missingKeysPageBuilder.isEmpty());
        UnloadedIndexKeyRecordSet.UnloadedIndexKeyRecordCursor indexKeysRecordCursor = indexKeysRecordSet.cursor();
        while (indexKeysRecordCursor.advanceNextPosition()) {
            Page page = indexKeysRecordCursor.getPage();
            int position = indexKeysRecordCursor.getPosition();
            if (lookupSource.getJoinPosition(position, page, page) >= 0L) continue;
            this.missingKeysPageBuilder.declarePosition();
            for (int i = 0; i < page.getChannelCount(); ++i) {
                Block block = page.getBlock(i);
                Type type = indexKeysRecordCursor.getType(i);
                type.appendTo(block, position, this.missingKeysPageBuilder.getBlockBuilder(i));
            }
        }
        Page missingKeysPage = this.missingKeysPageBuilder.build();
        if (!this.missingKeysPageBuilder.isEmpty()) {
            this.missingKeysPageBuilder.reset();
        }
        this.memoryInBytes += missingKeysPage.getSizeInBytes();
        if (this.isMemoryExceeded()) {
            return null;
        }
        if (missingKeysPage.getPositionCount() != 0) {
            this.missingKeysIndex.addPage(missingKeysPage);
            this.missingKeys = this.missingKeysIndex.createLookupSourceSupplier(this.session, this.missingKeysChannels).get();
        }
        return new IndexSnapshot(lookupSource, this.missingKeys);
    }

    public void reset() {
        this.memoryInBytes = 0L;
        this.pages.clear();
        this.outputPagesIndex = this.pagesIndexFactory.newPagesIndex(this.outputTypes, this.expectedPositions);
        this.missingKeysIndex = this.pagesIndexFactory.newPagesIndex(this.missingKeysTypes, this.expectedPositions);
    }
}

