/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.repartition;

import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.ColumnarArray;
import com.facebook.presto.spi.block.ColumnarMap;
import com.facebook.presto.spi.block.ColumnarRow;
import java.util.List;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;

class DecodedBlockNode {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(DecodedBlockNode.class).instanceSize();
    private final Object decodedBlock;
    private final List<DecodedBlockNode> children;

    public DecodedBlockNode(Object decodedBlock, List<DecodedBlockNode> children) {
        this.decodedBlock = Objects.requireNonNull(decodedBlock, "decodedBlock is null");
        this.children = Objects.requireNonNull(children, "children is null");
    }

    public Object getDecodedBlock() {
        return this.decodedBlock;
    }

    public List<DecodedBlockNode> getChildren() {
        return this.children;
    }

    public long getRetainedSizeInBytes() {
        long size = INSTANCE_SIZE;
        if (this.decodedBlock instanceof Block) {
            size += ((Block)this.decodedBlock).getRetainedSizeInBytes();
        } else if (this.decodedBlock instanceof ColumnarArray) {
            size += ((ColumnarArray)this.decodedBlock).getRetainedSizeInBytes();
        } else if (this.decodedBlock instanceof ColumnarMap) {
            size += ((ColumnarMap)this.decodedBlock).getRetainedSizeInBytes();
        } else if (this.decodedBlock instanceof ColumnarRow) {
            size += ((ColumnarRow)this.decodedBlock).getRetainedSizeInBytes();
        }
        for (DecodedBlockNode child : this.children) {
            size += child.getRetainedSizeInBytes();
        }
        return size;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DecodedBlockNode{");
        sb.append("decodedBlock=").append(this.decodedBlock.toString()).append(",");
        sb.append("childrenCount=").append(this.children.size()).append(",");
        for (int i = 0; i < this.children.size(); ++i) {
            sb.append("fieldBuffer_").append(i).append("=").append(this.children.get(i).toString()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }
}

