/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.repartition;

import com.facebook.presto.array.Arrays;
import com.facebook.presto.operator.UncheckedByteArrays;
import com.facebook.presto.operator.repartition.AbstractBlockEncodingBuffer;
import com.google.common.annotations.VisibleForTesting;
import io.airlift.slice.SizeOf;
import io.airlift.slice.SliceOutput;
import org.openjdk.jol.info.ClassLayout;
import sun.misc.Unsafe;

public class LongArrayBlockEncodingBuffer
extends AbstractBlockEncodingBuffer {
    @VisibleForTesting
    static final int POSITION_SIZE = 9;
    private static final String NAME = "LONG_ARRAY";
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(LongArrayBlockEncodingBuffer.class).instanceSize();
    private byte[] valuesBuffer;
    private int valuesBufferIndex;

    @Override
    public void accumulateSerializedRowSizes(int[] serializedRowSizes) {
        throw new UnsupportedOperationException("accumulateSerializedRowSizes is not supported for fixed width types");
    }

    @Override
    public void appendDataInBatch() {
        if (this.batchSize == 0) {
            return;
        }
        this.appendValuesToBuffer();
        this.appendNulls();
        this.bufferedPositionCount += this.batchSize;
    }

    @Override
    public void serializeTo(SliceOutput output) {
        LongArrayBlockEncodingBuffer.writeLengthPrefixedString(output, NAME);
        output.writeInt(this.bufferedPositionCount);
        this.serializeNullsTo(output);
        if (this.valuesBufferIndex > 0) {
            output.appendBytes(this.valuesBuffer, 0, this.valuesBufferIndex);
        }
    }

    @Override
    public void resetBuffers() {
        this.bufferedPositionCount = 0;
        this.valuesBufferIndex = 0;
        this.resetNullsBuffer();
    }

    @Override
    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + this.getPositionsRetainedSizeInBytes() + SizeOf.sizeOf((byte[])this.valuesBuffer) + this.getNullsBufferRetainedSizeInBytes();
    }

    @Override
    public long getSerializedSizeInBytes() {
        return (long)(NAME.length() + 4 + 4) + this.getNullsBufferSerializedSizeInBytes() + (long)this.valuesBufferIndex;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append("{");
        sb.append("valuesBufferCapacity=").append(this.valuesBuffer == null ? 0 : this.valuesBuffer.length).append(",");
        sb.append("valuesBufferIndex=").append(this.valuesBufferIndex).append("}");
        return sb.toString();
    }

    @Override
    protected void accumulateSerializedRowSizes(int[] positionOffsets, int positionCount, int[] serializedRowSizes) {
        for (int i = 0; i < positionCount; ++i) {
            int n = i;
            serializedRowSizes[n] = serializedRowSizes[n] + (positionOffsets[i + 1] - positionOffsets[i]) * 9;
        }
    }

    private void appendValuesToBuffer() {
        this.valuesBuffer = Arrays.ensureCapacity((byte[])this.valuesBuffer, (int)(this.valuesBufferIndex + this.batchSize * Unsafe.ARRAY_LONG_INDEX_SCALE), (Arrays.ExpansionFactor)Arrays.ExpansionFactor.LARGE, (Arrays.ExpansionOption)Arrays.ExpansionOption.PRESERVE);
        int[] positions = this.getPositions();
        if (this.decodedBlock.mayHaveNull()) {
            for (int i = this.positionsOffset; i < this.positionsOffset + this.batchSize; ++i) {
                int position = positions[i];
                int newIndex = UncheckedByteArrays.setLongUnchecked(this.valuesBuffer, this.valuesBufferIndex, this.decodedBlock.getLong(position));
                if (this.decodedBlock.isNull(position)) continue;
                this.valuesBufferIndex = newIndex;
            }
        } else {
            for (int i = this.positionsOffset; i < this.positionsOffset + this.batchSize; ++i) {
                this.valuesBufferIndex = UncheckedByteArrays.setLongUnchecked(this.valuesBuffer, this.valuesBufferIndex, this.decodedBlock.getLong(positions[i]));
            }
        }
    }
}

