/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.repartition;

import com.facebook.presto.execution.buffer.OutputBuffer;
import com.facebook.presto.execution.buffer.PageSplitterUtil;
import com.facebook.presto.execution.buffer.PagesSerde;
import com.facebook.presto.execution.buffer.PagesSerdeFactory;
import com.facebook.presto.memory.context.LocalMemoryContext;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.OutputFactory;
import com.facebook.presto.operator.PartitionFunction;
import com.facebook.presto.operator.repartition.PartitionedOutputInfo;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.RunLengthEncodedBlock;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.OutputPartitioning;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.units.DataSize;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;

public class PartitionedOutputOperator
implements Operator {
    private final OperatorContext operatorContext;
    private final Function<Page, Page> pagePreprocessor;
    private final PagePartitioner partitionFunction;
    private final LocalMemoryContext systemMemoryContext;
    private final long partitionsInitialRetainedSize;
    private boolean finished;

    public PartitionedOutputOperator(OperatorContext operatorContext, List<Type> sourceTypes, Function<Page, Page> pagePreprocessor, PartitionFunction partitionFunction, List<Integer> partitionChannels, List<Optional<ConstantExpression>> partitionConstants, boolean replicatesAnyRow, OptionalInt nullChannel, OutputBuffer outputBuffer, PagesSerdeFactory serdeFactory, DataSize maxMemory) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.pagePreprocessor = Objects.requireNonNull(pagePreprocessor, "pagePreprocessor is null");
        this.partitionFunction = new PagePartitioner(partitionFunction, partitionChannels, partitionConstants, replicatesAnyRow, nullChannel, outputBuffer, serdeFactory, sourceTypes, maxMemory, operatorContext);
        operatorContext.setInfoSupplier(this::getInfo);
        this.systemMemoryContext = operatorContext.newLocalSystemMemoryContext(PartitionedOutputOperator.class.getSimpleName());
        this.partitionsInitialRetainedSize = this.partitionFunction.getRetainedSizeInBytes();
        this.systemMemoryContext.setBytes(this.partitionsInitialRetainedSize);
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    public PartitionedOutputInfo getInfo() {
        return this.partitionFunction.getInfo();
    }

    @Override
    public void finish() {
        this.finished = true;
        this.partitionFunction.flush(true);
    }

    @Override
    public boolean isFinished() {
        return this.finished && this.isBlocked().isDone();
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        ListenableFuture<?> blocked = this.partitionFunction.isFull();
        return blocked.isDone() ? NOT_BLOCKED : blocked;
    }

    @Override
    public boolean needsInput() {
        return !this.finished && this.isBlocked().isDone();
    }

    @Override
    public void addInput(Page page) {
        Objects.requireNonNull(page, "page is null");
        if (page.getPositionCount() == 0) {
            return;
        }
        page = this.pagePreprocessor.apply(page);
        this.partitionFunction.partitionPage(page);
        long partitionsSizeInBytes = this.partitionFunction.getSizeInBytes();
        this.systemMemoryContext.setBytes(partitionsSizeInBytes + this.partitionsInitialRetainedSize);
    }

    @Override
    public Page getOutput() {
        return null;
    }

    private static class PagePartitioner {
        private final OutputBuffer outputBuffer;
        private final List<Type> sourceTypes;
        private final PartitionFunction partitionFunction;
        private final List<Integer> partitionChannels;
        private final List<Optional<Block>> partitionConstants;
        private final PagesSerde serde;
        private final PageBuilder[] pageBuilders;
        private final boolean replicatesAnyRow;
        private final OptionalInt nullChannel;
        private final AtomicLong rowsAdded = new AtomicLong();
        private final AtomicLong pagesAdded = new AtomicLong();
        private boolean hasAnyRowBeenReplicated;
        private final OperatorContext operatorContext;

        public PagePartitioner(PartitionFunction partitionFunction, List<Integer> partitionChannels, List<Optional<ConstantExpression>> partitionConstants, boolean replicatesAnyRow, OptionalInt nullChannel, OutputBuffer outputBuffer, PagesSerdeFactory serdeFactory, List<Type> sourceTypes, DataSize maxMemory, OperatorContext operatorContext) {
            this.partitionFunction = Objects.requireNonNull(partitionFunction, "partitionFunction is null");
            this.partitionChannels = Objects.requireNonNull(partitionChannels, "partitionChannels is null");
            this.partitionConstants = (List)Objects.requireNonNull(partitionConstants, "partitionConstants is null").stream().map(constant -> constant.map(ConstantExpression::getValueBlock)).collect(ImmutableList.toImmutableList());
            this.replicatesAnyRow = replicatesAnyRow;
            this.nullChannel = Objects.requireNonNull(nullChannel, "nullChannel is null");
            this.outputBuffer = Objects.requireNonNull(outputBuffer, "outputBuffer is null");
            this.sourceTypes = Objects.requireNonNull(sourceTypes, "sourceTypes is null");
            this.serde = Objects.requireNonNull(serdeFactory, "serdeFactory is null").createPagesSerde();
            this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
            int partitionCount = partitionFunction.getPartitionCount();
            int pageSize = Math.min(0x100000, (int)maxMemory.toBytes() / partitionCount);
            pageSize = Math.max(1, pageSize);
            this.pageBuilders = new PageBuilder[partitionCount];
            for (int i = 0; i < partitionCount; ++i) {
                this.pageBuilders[i] = PageBuilder.withMaxPageSize((int)pageSize, sourceTypes);
            }
        }

        public ListenableFuture<?> isFull() {
            return this.outputBuffer.isFull();
        }

        public long getSizeInBytes() {
            long sizeInBytes = this.serde.getSizeInBytes();
            for (PageBuilder pageBuilder : this.pageBuilders) {
                sizeInBytes += pageBuilder.getSizeInBytes();
            }
            return sizeInBytes;
        }

        public long getRetainedSizeInBytes() {
            long sizeInBytes = this.serde.getRetainedSizeInBytes();
            for (PageBuilder pageBuilder : this.pageBuilders) {
                sizeInBytes += pageBuilder.getRetainedSizeInBytes();
            }
            return sizeInBytes;
        }

        public PartitionedOutputInfo getInfo() {
            return new PartitionedOutputInfo(this.rowsAdded.get(), this.pagesAdded.get(), this.outputBuffer.getPeakMemoryUsage());
        }

        public void partitionPage(Page page) {
            Objects.requireNonNull(page, "page is null");
            Page partitionFunctionArgs = this.getPartitionFunctionArguments(page);
            for (int position = 0; position < page.getPositionCount(); ++position) {
                boolean shouldReplicate;
                boolean bl = shouldReplicate = this.replicatesAnyRow && !this.hasAnyRowBeenReplicated || this.nullChannel.isPresent() && page.getBlock(this.nullChannel.getAsInt()).isNull(position);
                if (shouldReplicate) {
                    for (PageBuilder pageBuilder : this.pageBuilders) {
                        this.appendRow(pageBuilder, page, position);
                    }
                    this.hasAnyRowBeenReplicated = true;
                    continue;
                }
                int partition = this.partitionFunction.getPartition(partitionFunctionArgs, position);
                this.appendRow(this.pageBuilders[partition], page, position);
            }
            this.flush(false);
        }

        private Page getPartitionFunctionArguments(Page page) {
            Block[] blocks = new Block[this.partitionChannels.size()];
            for (int i = 0; i < blocks.length; ++i) {
                Optional<Block> partitionConstant = this.partitionConstants.get(i);
                blocks[i] = partitionConstant.isPresent() ? new RunLengthEncodedBlock(partitionConstant.get(), page.getPositionCount()) : page.getBlock(this.partitionChannels.get(i).intValue());
            }
            return new Page(page.getPositionCount(), blocks);
        }

        private void appendRow(PageBuilder pageBuilder, Page page, int position) {
            pageBuilder.declarePosition();
            for (int channel = 0; channel < this.sourceTypes.size(); ++channel) {
                Type type = this.sourceTypes.get(channel);
                type.appendTo(page.getBlock(channel), position, pageBuilder.getBlockBuilder(channel));
            }
        }

        public void flush(boolean force) {
            for (int partition = 0; partition < this.pageBuilders.length; ++partition) {
                PageBuilder partitionPageBuilder = this.pageBuilders[partition];
                if (partitionPageBuilder.isEmpty() || !force && !partitionPageBuilder.isFull()) continue;
                Page pagePartition = partitionPageBuilder.build();
                partitionPageBuilder.reset();
                this.operatorContext.recordOutput(pagePartition.getSizeInBytes(), pagePartition.getPositionCount());
                List serializedPages = (List)PageSplitterUtil.splitPage(pagePartition, 0x100000L).stream().map(this.serde::serialize).collect(ImmutableList.toImmutableList());
                this.outputBuffer.enqueue(this.operatorContext.getDriverContext().getLifespan(), partition, serializedPages);
                this.pagesAdded.incrementAndGet();
                this.rowsAdded.addAndGet(pagePartition.getPositionCount());
            }
        }
    }

    public static class PartitionedOutputOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final List<Type> sourceTypes;
        private final Function<Page, Page> pagePreprocessor;
        private final PartitionFunction partitionFunction;
        private final List<Integer> partitionChannels;
        private final List<Optional<ConstantExpression>> partitionConstants;
        private final boolean replicatesAnyRow;
        private final OptionalInt nullChannel;
        private final OutputBuffer outputBuffer;
        private final PagesSerdeFactory serdeFactory;
        private final DataSize maxMemory;

        public PartitionedOutputOperatorFactory(int operatorId, PlanNodeId planNodeId, List<Type> sourceTypes, Function<Page, Page> pagePreprocessor, PartitionFunction partitionFunction, List<Integer> partitionChannels, List<Optional<ConstantExpression>> partitionConstants, boolean replicatesAnyRow, OptionalInt nullChannel, OutputBuffer outputBuffer, PagesSerdeFactory serdeFactory, DataSize maxMemory) {
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            this.sourceTypes = Objects.requireNonNull(sourceTypes, "sourceTypes is null");
            this.pagePreprocessor = Objects.requireNonNull(pagePreprocessor, "pagePreprocessor is null");
            this.partitionFunction = Objects.requireNonNull(partitionFunction, "partitionFunction is null");
            this.partitionChannels = Objects.requireNonNull(partitionChannels, "partitionChannels is null");
            this.partitionConstants = Objects.requireNonNull(partitionConstants, "partitionConstants is null");
            this.replicatesAnyRow = replicatesAnyRow;
            this.nullChannel = Objects.requireNonNull(nullChannel, "nullChannel is null");
            this.outputBuffer = Objects.requireNonNull(outputBuffer, "outputBuffer is null");
            this.serdeFactory = Objects.requireNonNull(serdeFactory, "serdeFactory is null");
            this.maxMemory = Objects.requireNonNull(maxMemory, "maxMemory is null");
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, this.planNodeId, PartitionedOutputOperator.class.getSimpleName());
            return new PartitionedOutputOperator(operatorContext, this.sourceTypes, this.pagePreprocessor, this.partitionFunction, this.partitionChannels, this.partitionConstants, this.replicatesAnyRow, this.nullChannel, this.outputBuffer, this.serdeFactory, this.maxMemory);
        }

        @Override
        public void noMoreOperators() {
        }

        @Override
        public OperatorFactory duplicate() {
            return new PartitionedOutputOperatorFactory(this.operatorId, this.planNodeId, this.sourceTypes, this.pagePreprocessor, this.partitionFunction, this.partitionChannels, this.partitionConstants, this.replicatesAnyRow, this.nullChannel, this.outputBuffer, this.serdeFactory, this.maxMemory);
        }
    }

    public static class PartitionedOutputFactory
    implements OutputFactory {
        private final OutputBuffer outputBuffer;
        private final DataSize maxMemory;

        public PartitionedOutputFactory(OutputBuffer outputBuffer, DataSize maxMemory) {
            this.outputBuffer = Objects.requireNonNull(outputBuffer, "outputBuffer is null");
            this.maxMemory = Objects.requireNonNull(maxMemory, "maxMemory is null");
        }

        @Override
        public OperatorFactory createOutputOperator(int operatorId, PlanNodeId planNodeId, List<Type> types, Function<Page, Page> pagePreprocessor, Optional<OutputPartitioning> outputPartitioning, PagesSerdeFactory serdeFactory) {
            Preconditions.checkArgument((boolean)outputPartitioning.isPresent(), (Object)"outputPartitioning is not present");
            return new PartitionedOutputOperatorFactory(operatorId, planNodeId, types, pagePreprocessor, outputPartitioning.get().getPartitionFunction(), outputPartitioning.get().getPartitionChannels(), outputPartitioning.get().getPartitionConstants(), outputPartitioning.get().isReplicateNullsAndAny(), outputPartitioning.get().getNullChannel(), this.outputBuffer, serdeFactory, this.maxMemory);
        }
    }
}

