/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.operator.aggregation.TypedSet;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.function.Description;
import com.facebook.presto.spi.function.ScalarFunction;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.function.TypeParameter;
import com.facebook.presto.spi.type.Type;

@ScalarFunction(value="array_except")
@Description(value="Returns an array of elements that are in the first array but not the second, without duplicates.")
public final class ArrayExceptFunction {
    private ArrayExceptFunction() {
    }

    @TypeParameter(value="E")
    @SqlType(value="array(E)")
    public static Block except(@TypeParameter(value="E") Type type, @SqlType(value="array(E)") Block leftArray, @SqlType(value="array(E)") Block rightArray) {
        int i;
        int leftPositionCount = leftArray.getPositionCount();
        int rightPositionCount = rightArray.getPositionCount();
        if (leftPositionCount == 0) {
            return leftArray;
        }
        TypedSet typedSet = new TypedSet(type, leftPositionCount + rightPositionCount, "array_except");
        BlockBuilder distinctElementBlockBuilder = type.createBlockBuilder(null, leftPositionCount);
        for (i = 0; i < rightPositionCount; ++i) {
            typedSet.add(rightArray, i);
        }
        for (i = 0; i < leftPositionCount; ++i) {
            if (!typedSet.add(leftArray, i)) continue;
            type.appendTo(leftArray, i, distinctElementBlockBuilder);
        }
        return distinctElementBlockBuilder.build();
    }
}

