/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.operator.aggregation.TypedSet;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.function.Description;
import com.facebook.presto.spi.function.ScalarFunction;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.function.TypeParameter;
import com.facebook.presto.spi.type.Type;

@ScalarFunction(value="array_intersect")
@Description(value="Intersects elements of the two given arrays")
public final class ArrayIntersectFunction {
    private ArrayIntersectFunction() {
    }

    @TypeParameter(value="E")
    @SqlType(value="array(E)")
    public static Block intersect(@TypeParameter(value="E") Type type, @SqlType(value="array(E)") Block leftArray, @SqlType(value="array(E)") Block rightArray) {
        if (leftArray.getPositionCount() < rightArray.getPositionCount()) {
            Block tempArray = leftArray;
            leftArray = rightArray;
            rightArray = tempArray;
        }
        int leftPositionCount = leftArray.getPositionCount();
        int rightPositionCount = rightArray.getPositionCount();
        if (rightPositionCount == 0) {
            return rightArray;
        }
        TypedSet rightTypedSet = new TypedSet(type, rightPositionCount, "array_intersect");
        for (int i = 0; i < rightPositionCount; ++i) {
            rightTypedSet.add(rightArray, i);
        }
        BlockBuilder blockBuilder = type.createBlockBuilder(null, Math.min(leftPositionCount, rightPositionCount));
        TypedSet intersectTypedSet = new TypedSet(type, blockBuilder, rightPositionCount, "array_intersect");
        for (int i = 0; i < leftPositionCount; ++i) {
            if (!rightTypedSet.contains(leftArray, i)) continue;
            intersectTypedSet.add(leftArray, i);
        }
        return blockBuilder.build();
    }
}

