/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.operator.scalar.ArrayAnyMatchFunction;
import com.facebook.presto.operator.scalar.BlockToBooleanFunction;
import com.facebook.presto.operator.scalar.BooleanToBooleanFunction;
import com.facebook.presto.operator.scalar.DoubleToBooleanFunction;
import com.facebook.presto.operator.scalar.LongToBooleanFunction;
import com.facebook.presto.operator.scalar.SliceToBooleanFunction;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.function.Description;
import com.facebook.presto.spi.function.ScalarFunction;
import com.facebook.presto.spi.function.SqlNullable;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.function.TypeParameter;
import com.facebook.presto.spi.function.TypeParameterSpecialization;
import com.facebook.presto.spi.type.Type;
import io.airlift.slice.Slice;

@Description(value="Returns true if all elements of the array don't match the given predicate")
@ScalarFunction(value="none_match")
public final class ArrayNoneMatchFunction {
    private ArrayNoneMatchFunction() {
    }

    @TypeParameter(value="T")
    @TypeParameterSpecialization(name="T", nativeContainerType=Block.class)
    @SqlType(value="boolean")
    @SqlNullable
    public static Boolean noneMatchBlock(@TypeParameter(value="T") Type elementType, @SqlType(value="array(T)") Block arrayBlock, @SqlType(value="function(T, boolean)") BlockToBooleanFunction function) {
        Boolean anyMatchResult = ArrayAnyMatchFunction.anyMatchBlock(elementType, arrayBlock, function);
        if (anyMatchResult == null) {
            return null;
        }
        return anyMatchResult == false;
    }

    @TypeParameter(value="T")
    @TypeParameterSpecialization(name="T", nativeContainerType=Slice.class)
    @SqlType(value="boolean")
    @SqlNullable
    public static Boolean noneMatchSlice(@TypeParameter(value="T") Type elementType, @SqlType(value="array(T)") Block arrayBlock, @SqlType(value="function(T, boolean)") SliceToBooleanFunction function) {
        Boolean anyMatchResult = ArrayAnyMatchFunction.anyMatchSlice(elementType, arrayBlock, function);
        if (anyMatchResult == null) {
            return null;
        }
        return anyMatchResult == false;
    }

    @TypeParameter(value="T")
    @TypeParameterSpecialization(name="T", nativeContainerType=long.class)
    @SqlType(value="boolean")
    @SqlNullable
    public static Boolean noneMatchLong(@TypeParameter(value="T") Type elementType, @SqlType(value="array(T)") Block arrayBlock, @SqlType(value="function(T, boolean)") LongToBooleanFunction function) {
        Boolean anyMatchResult = ArrayAnyMatchFunction.anyMatchLong(elementType, arrayBlock, function);
        if (anyMatchResult == null) {
            return null;
        }
        return anyMatchResult == false;
    }

    @TypeParameter(value="T")
    @TypeParameterSpecialization(name="T", nativeContainerType=double.class)
    @SqlType(value="boolean")
    @SqlNullable
    public static Boolean noneMatchDouble(@TypeParameter(value="T") Type elementType, @SqlType(value="array(T)") Block arrayBlock, @SqlType(value="function(T, boolean)") DoubleToBooleanFunction function) {
        Boolean anyMatchResult = ArrayAnyMatchFunction.anyMatchDouble(elementType, arrayBlock, function);
        if (anyMatchResult == null) {
            return null;
        }
        return anyMatchResult == false;
    }

    @TypeParameter(value="T")
    @TypeParameterSpecialization(name="T", nativeContainerType=boolean.class)
    @SqlType(value="boolean")
    @SqlNullable
    public static Boolean noneMatchBoolean(@TypeParameter(value="T") Type elementType, @SqlType(value="array(T)") Block arrayBlock, @SqlType(value="function(T, boolean)") BooleanToBooleanFunction function) {
        Boolean anyMatchResult = ArrayAnyMatchFunction.anyMatchBoolean(elementType, arrayBlock, function);
        if (anyMatchResult == null) {
            return null;
        }
        return anyMatchResult == false;
    }
}

