/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import io.airlift.slice.Slice;

public class FnvHash {
    private static final long FNV_64_OFFSET_BASIS = -3750763034362895579L;
    private static final long FNV_64_PRIME = 1099511628211L;
    private static final int FNV_32_OFFSET_BASIS = -2128831035;
    private static final int FNV_32_PRIME = 16777619;

    private FnvHash() {
    }

    public static int fnv1Hash32(Slice data) {
        int hash = -2128831035;
        for (int i = 0; i < data.length(); ++i) {
            short dataByte = data.getUnsignedByte(i);
            hash *= 16777619;
            hash ^= dataByte;
        }
        return hash;
    }

    public static long fnv1Hash64(Slice data) {
        long hash = -3750763034362895579L;
        for (int i = 0; i < data.length(); ++i) {
            long dataByte = data.getUnsignedByte(i);
            hash *= 1099511628211L;
            hash ^= dataByte;
        }
        return hash;
    }

    public static int fnv1aHash32(Slice data) {
        int hash = -2128831035;
        for (int i = 0; i < data.length(); ++i) {
            short dataByte = data.getUnsignedByte(i);
            hash ^= dataByte;
            hash *= 16777619;
        }
        return hash;
    }

    public static long fnv1aHash64(Slice data) {
        long hash = -3750763034362895579L;
        for (int i = 0; i < data.length(); ++i) {
            long dataByte = data.getUnsignedByte(i);
            hash ^= dataByte;
            hash *= 1099511628211L;
        }
        return hash;
    }
}

