/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.FunctionInvoker;
import com.facebook.presto.metadata.FunctionManager;
import com.facebook.presto.metadata.SqlOperator;
import com.facebook.presto.operator.scalar.BuiltInScalarFunctionImplementation;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.function.InvocationConvention;
import com.facebook.presto.spi.function.LongVariableConstraint;
import com.facebook.presto.spi.function.OperatorType;
import com.facebook.presto.spi.function.Signature;
import com.facebook.presto.spi.function.TypeVariableConstraint;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.spi.type.TypeUtils;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.util.Failures;
import com.facebook.presto.util.Reflection;
import com.google.common.base.Defaults;
import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Optional;

public class RowDistinctFromOperator
extends SqlOperator {
    public static final RowDistinctFromOperator ROW_DISTINCT_FROM = new RowDistinctFromOperator();
    private static final MethodHandle METHOD_HANDLE_NULL_FLAG = Reflection.methodHandle(RowDistinctFromOperator.class, "isDistinctFrom", Type.class, List.class, Block.class, Boolean.TYPE, Block.class, Boolean.TYPE);
    private static final MethodHandle METHOD_HANDLE_BLOCK_POSITION = Reflection.methodHandle(RowDistinctFromOperator.class, "isDistinctFrom", Type.class, List.class, Block.class, Integer.TYPE, Block.class, Integer.TYPE);

    private RowDistinctFromOperator() {
        super(OperatorType.IS_DISTINCT_FROM, (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.comparableWithVariadicBound((String)"T", (String)"row")), (List<LongVariableConstraint>)ImmutableList.of(), TypeSignature.parseTypeSignature((String)"boolean"), (List<TypeSignature>)ImmutableList.of((Object)TypeSignature.parseTypeSignature((String)"T"), (Object)TypeSignature.parseTypeSignature((String)"T")));
    }

    @Override
    public BuiltInScalarFunctionImplementation specialize(BoundVariables boundVariables, int arity, TypeManager typeManager, FunctionManager functionManager) {
        ImmutableList.Builder argumentMethods = ImmutableList.builder();
        Type type = boundVariables.getTypeVariable("T");
        for (Type parameterType : type.getTypeParameters()) {
            FunctionHandle operatorHandle = functionManager.resolveOperator(OperatorType.IS_DISTINCT_FROM, TypeSignatureProvider.fromTypes(parameterType, parameterType));
            FunctionInvoker functionInvoker = functionManager.getFunctionInvokerProvider().createFunctionInvoker(operatorHandle, Optional.of(new InvocationConvention((List)ImmutableList.of((Object)InvocationConvention.InvocationArgumentConvention.NULL_FLAG, (Object)InvocationConvention.InvocationArgumentConvention.NULL_FLAG), InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, false)));
            argumentMethods.add((Object)functionInvoker.methodHandle());
        }
        return new BuiltInScalarFunctionImplementation((List<BuiltInScalarFunctionImplementation.ScalarImplementationChoice>)ImmutableList.of((Object)new BuiltInScalarFunctionImplementation.ScalarImplementationChoice(false, (List<BuiltInScalarFunctionImplementation.ArgumentProperty>)ImmutableList.of((Object)BuiltInScalarFunctionImplementation.ArgumentProperty.valueTypeArgumentProperty(BuiltInScalarFunctionImplementation.NullConvention.USE_NULL_FLAG), (Object)BuiltInScalarFunctionImplementation.ArgumentProperty.valueTypeArgumentProperty(BuiltInScalarFunctionImplementation.NullConvention.USE_NULL_FLAG)), BuiltInScalarFunctionImplementation.ReturnPlaceConvention.STACK, METHOD_HANDLE_NULL_FLAG.bindTo(type).bindTo(argumentMethods.build()), Optional.empty()), (Object)new BuiltInScalarFunctionImplementation.ScalarImplementationChoice(false, (List<BuiltInScalarFunctionImplementation.ArgumentProperty>)ImmutableList.of((Object)BuiltInScalarFunctionImplementation.ArgumentProperty.valueTypeArgumentProperty(BuiltInScalarFunctionImplementation.NullConvention.BLOCK_AND_POSITION), (Object)BuiltInScalarFunctionImplementation.ArgumentProperty.valueTypeArgumentProperty(BuiltInScalarFunctionImplementation.NullConvention.BLOCK_AND_POSITION)), BuiltInScalarFunctionImplementation.ReturnPlaceConvention.STACK, METHOD_HANDLE_BLOCK_POSITION.bindTo(type).bindTo(argumentMethods.build()), Optional.empty())));
    }

    public static boolean isDistinctFrom(Type rowType, List<MethodHandle> argumentMethods, Block leftRow, boolean leftNull, Block rightRow, boolean rightNull) {
        if (leftNull != rightNull) {
            return true;
        }
        if (leftNull) {
            return false;
        }
        List fieldTypes = rowType.getTypeParameters();
        for (int i = 0; i < leftRow.getPositionCount(); ++i) {
            Object rightValue;
            boolean rightValueNull;
            boolean leftValueNull;
            Type type = (Type)fieldTypes.get(i);
            Object leftValue = TypeUtils.readNativeValue((Type)type, (Block)leftRow, (int)i);
            boolean bl = leftValueNull = leftValue == null;
            if (leftValueNull) {
                leftValue = Defaults.defaultValue((Class)type.getJavaType());
            }
            boolean bl2 = rightValueNull = (rightValue = TypeUtils.readNativeValue((Type)type, (Block)rightRow, (int)i)) == null;
            if (rightValueNull) {
                rightValue = Defaults.defaultValue((Class)type.getJavaType());
            }
            try {
                if (!argumentMethods.get(i).invoke(leftValue, leftValueNull, rightValue, rightValueNull)) continue;
                return true;
            }
            catch (Throwable t) {
                throw Failures.internalError(t);
            }
        }
        return false;
    }

    public static boolean isDistinctFrom(Type rowType, List<MethodHandle> argumentMethods, Block leftRow, int leftPosition, Block rightRow, int rightPosition) {
        return RowDistinctFromOperator.isDistinctFrom(rowType, argumentMethods, (Block)rowType.getObject(leftRow, leftPosition), leftRow.isNull(leftPosition), (Block)rowType.getObject(rightRow, rightPosition), rightRow.isNull(rightPosition));
    }
}

