/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.BuiltInFunctionNamespaceManager;
import com.facebook.presto.metadata.CastType;
import com.facebook.presto.metadata.FunctionManager;
import com.facebook.presto.metadata.SqlScalarFunction;
import com.facebook.presto.operator.scalar.BuiltInScalarFunctionImplementation;
import com.facebook.presto.spi.CatalogSchemaName;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.function.FunctionKind;
import com.facebook.presto.spi.function.QualifiedFunctionName;
import com.facebook.presto.spi.function.Signature;
import com.facebook.presto.spi.function.SqlFunctionVisibility;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Primitives;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.List;

public class TryCastFunction
extends SqlScalarFunction {
    public static final TryCastFunction TRY_CAST = new TryCastFunction();
    public static final String TRY_CAST_NAME = "TRY_CAST";

    public TryCastFunction() {
        super(new Signature(QualifiedFunctionName.of((CatalogSchemaName)BuiltInFunctionNamespaceManager.DEFAULT_NAMESPACE, (String)TRY_CAST_NAME), FunctionKind.SCALAR, (List)ImmutableList.of((Object)Signature.typeVariable((String)"F"), (Object)Signature.typeVariable((String)"T")), (List)ImmutableList.of(), TypeSignature.parseTypeSignature((String)"T"), (List)ImmutableList.of((Object)TypeSignature.parseTypeSignature((String)"F")), false));
    }

    public final SqlFunctionVisibility getVisibility() {
        return SqlFunctionVisibility.HIDDEN;
    }

    public boolean isDeterministic() {
        return true;
    }

    public String getDescription() {
        return "";
    }

    @Override
    public BuiltInScalarFunctionImplementation specialize(BoundVariables boundVariables, int arity, TypeManager typeManager, FunctionManager functionManager) {
        Type fromType = boundVariables.getTypeVariable("F");
        Type toType = boundVariables.getTypeVariable("T");
        Class returnType = Primitives.wrap((Class)toType.getJavaType());
        FunctionHandle functionHandle = functionManager.lookupCast(CastType.CAST, fromType.getTypeSignature(), toType.getTypeSignature());
        BuiltInScalarFunctionImplementation implementation = functionManager.getBuiltInScalarFunctionImplementation(functionHandle);
        ImmutableList argumentProperties = ImmutableList.of((Object)implementation.getArgumentProperty(0));
        MethodHandle coercion = implementation.getMethodHandle();
        coercion = coercion.asType(MethodType.methodType(returnType, coercion.type()));
        MethodHandle exceptionHandler = MethodHandles.dropArguments(MethodHandles.constant(returnType, null), 0, new Class[]{RuntimeException.class});
        MethodHandle tryCastHandle = MethodHandles.catchException(coercion, RuntimeException.class, exceptionHandler);
        return new BuiltInScalarFunctionImplementation(true, (List<BuiltInScalarFunctionImplementation.ArgumentProperty>)argumentProperties, tryCastHandle);
    }
}

