/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.Description;
import com.facebook.presto.spi.function.LiteralParameters;
import com.facebook.presto.spi.function.ScalarFunction;
import com.facebook.presto.spi.function.SqlNullable;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.type.Constraint;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.escape.Escaper;
import com.google.common.net.UrlEscapers;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import javax.annotation.Nullable;

public final class UrlFunctions {
    private static final Splitter QUERY_SPLITTER = Splitter.on((char)'&');
    private static final Splitter ARG_SPLITTER = Splitter.on((char)'=').limit(2);

    private UrlFunctions() {
    }

    @SqlNullable
    @Description(value="extract protocol from url")
    @ScalarFunction
    @LiteralParameters(value={"x"})
    @SqlType(value="varchar(x)")
    public static Slice urlExtractProtocol(@SqlType(value="varchar(x)") Slice url) {
        URI uri = UrlFunctions.parseUrl(url);
        return uri == null ? null : UrlFunctions.slice(uri.getScheme());
    }

    @SqlNullable
    @Description(value="extract host from url")
    @ScalarFunction
    @LiteralParameters(value={"x"})
    @SqlType(value="varchar(x)")
    public static Slice urlExtractHost(@SqlType(value="varchar(x)") Slice url) {
        URI uri = UrlFunctions.parseUrl(url);
        return uri == null ? null : UrlFunctions.slice(uri.getHost());
    }

    @SqlNullable
    @Description(value="extract port from url")
    @ScalarFunction
    @LiteralParameters(value={"x"})
    @SqlType(value="bigint")
    public static Long urlExtractPort(@SqlType(value="varchar(x)") Slice url) {
        URI uri = UrlFunctions.parseUrl(url);
        if (uri == null || uri.getPort() < 0) {
            return null;
        }
        return uri.getPort();
    }

    @SqlNullable
    @Description(value="extract part from url")
    @ScalarFunction
    @LiteralParameters(value={"x"})
    @SqlType(value="varchar(x)")
    public static Slice urlExtractPath(@SqlType(value="varchar(x)") Slice url) {
        URI uri = UrlFunctions.parseUrl(url);
        return uri == null ? null : UrlFunctions.slice(uri.getPath());
    }

    @SqlNullable
    @Description(value="extract query from url")
    @ScalarFunction
    @LiteralParameters(value={"x"})
    @SqlType(value="varchar(x)")
    public static Slice urlExtractQuery(@SqlType(value="varchar(x)") Slice url) {
        URI uri = UrlFunctions.parseUrl(url);
        return uri == null ? null : UrlFunctions.slice(uri.getQuery());
    }

    @SqlNullable
    @Description(value="extract fragment from url")
    @ScalarFunction
    @LiteralParameters(value={"x"})
    @SqlType(value="varchar(x)")
    public static Slice urlExtractFragment(@SqlType(value="varchar(x)") Slice url) {
        URI uri = UrlFunctions.parseUrl(url);
        return uri == null ? null : UrlFunctions.slice(uri.getFragment());
    }

    @SqlNullable
    @Description(value="extract query parameter from url")
    @ScalarFunction
    @LiteralParameters(value={"x", "y"})
    @SqlType(value="varchar(x)")
    public static Slice urlExtractParameter(@SqlType(value="varchar(x)") Slice url, @SqlType(value="varchar(y)") Slice parameterName) {
        URI uri = UrlFunctions.parseUrl(url);
        if (uri == null || uri.getQuery() == null) {
            return null;
        }
        Slice query = UrlFunctions.slice(uri.getQuery());
        String parameter = parameterName.toStringUtf8();
        Iterable queryArgs = QUERY_SPLITTER.split((CharSequence)query.toStringUtf8());
        for (String queryArg : queryArgs) {
            Iterator arg = ARG_SPLITTER.split((CharSequence)queryArg).iterator();
            if (!((String)arg.next()).equals(parameter)) continue;
            if (arg.hasNext()) {
                return Slices.utf8Slice((String)((String)arg.next()));
            }
            return Slices.EMPTY_SLICE;
        }
        return null;
    }

    @Description(value="escape a string for use in URL query parameter names and values")
    @ScalarFunction
    @LiteralParameters(value={"x", "y"})
    @Constraint(variable="y", expression="min(2147483647, x * 12)")
    @SqlType(value="varchar(y)")
    public static Slice urlEncode(@SqlType(value="varchar(x)") Slice value) {
        Escaper escaper = UrlEscapers.urlFormParameterEscaper();
        return UrlFunctions.slice(escaper.escape(value.toStringUtf8()));
    }

    @Description(value="unescape a URL-encoded string")
    @ScalarFunction
    @LiteralParameters(value={"x"})
    @SqlType(value="varchar(x)")
    public static Slice urlDecode(@SqlType(value="varchar(x)") Slice value) {
        try {
            return UrlFunctions.slice(URLDecoder.decode(value.toStringUtf8(), StandardCharsets.UTF_8.name()));
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
        catch (IllegalArgumentException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, (Throwable)e);
        }
    }

    private static Slice slice(@Nullable String s) {
        return Slices.utf8Slice((String)Strings.nullToEmpty((String)s));
    }

    @Nullable
    private static URI parseUrl(Slice url) {
        try {
            return new URI(url.toStringUtf8());
        }
        catch (URISyntaxException e) {
            return null;
        }
    }
}

