/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.airlift.http.client.HttpRequestFilter;
import com.facebook.airlift.http.client.Request;
import com.google.common.annotations.VisibleForTesting;
import java.util.Locale;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;

public class GenerateTraceTokenRequestFilter
implements HttpRequestFilter {
    private final String prefix = UUID.randomUUID().toString().toLowerCase(Locale.ENGLISH).replace("-", "");
    private final AtomicLong sequence = new AtomicLong();

    public Request filterRequest(Request request) {
        Objects.requireNonNull(request, "request is null");
        String newToken = this.createToken(this.sequence.getAndIncrement());
        return Request.Builder.fromRequest((Request)request).setHeader("X-Airlift-Tracetoken", newToken).build();
    }

    private String createToken(long value) {
        return this.prefix + String.format("%010x", value);
    }

    @VisibleForTesting
    String getLastToken() {
        long value = this.sequence.get();
        return this.createToken(value - 1L);
    }
}

