/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server.security;

import com.facebook.airlift.configuration.AbstractConfigurationAwareModule;
import com.facebook.airlift.configuration.ConfigBinder;
import com.facebook.airlift.http.server.TheServlet;
import com.facebook.presto.server.security.AuthenticationFilter;
import com.facebook.presto.server.security.Authenticator;
import com.facebook.presto.server.security.CertificateAuthenticator;
import com.facebook.presto.server.security.JsonWebTokenAuthenticator;
import com.facebook.presto.server.security.JsonWebTokenConfig;
import com.facebook.presto.server.security.KerberosAuthenticator;
import com.facebook.presto.server.security.KerberosConfig;
import com.facebook.presto.server.security.PasswordAuthenticator;
import com.facebook.presto.server.security.PasswordAuthenticatorManager;
import com.facebook.presto.server.security.SecurityConfig;
import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.multibindings.Multibinder;
import java.util.List;
import java.util.Set;
import javax.servlet.Filter;

public class ServerSecurityModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        Multibinder.newSetBinder((Binder)binder, Filter.class, TheServlet.class).addBinding().to(AuthenticationFilter.class).in(Scopes.SINGLETON);
        binder.bind(PasswordAuthenticatorManager.class).in(Scopes.SINGLETON);
        List<SecurityConfig.AuthenticationType> authTypes = ((SecurityConfig)this.buildConfigObject(SecurityConfig.class)).getAuthenticationTypes();
        Multibinder authBinder = Multibinder.newSetBinder((Binder)binder, Authenticator.class);
        for (SecurityConfig.AuthenticationType authType : authTypes) {
            if (authType == SecurityConfig.AuthenticationType.CERTIFICATE) {
                authBinder.addBinding().to(CertificateAuthenticator.class).in(Scopes.SINGLETON);
                continue;
            }
            if (authType == SecurityConfig.AuthenticationType.KERBEROS) {
                ConfigBinder.configBinder((Binder)binder).bindConfig(KerberosConfig.class);
                authBinder.addBinding().to(KerberosAuthenticator.class).in(Scopes.SINGLETON);
                continue;
            }
            if (authType == SecurityConfig.AuthenticationType.PASSWORD) {
                authBinder.addBinding().to(PasswordAuthenticator.class).in(Scopes.SINGLETON);
                continue;
            }
            if (authType == SecurityConfig.AuthenticationType.JWT) {
                ConfigBinder.configBinder((Binder)binder).bindConfig(JsonWebTokenConfig.class);
                authBinder.addBinding().to(JsonWebTokenAuthenticator.class).in(Scopes.SINGLETON);
                continue;
            }
            throw new AssertionError((Object)("Unhandled auth type: " + (Object)((Object)authType)));
        }
    }

    @Provides
    List<Authenticator> getAuthenticatorList(Set<Authenticator> authenticators) {
        return ImmutableList.copyOf(authenticators);
    }
}

