/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql;

import com.facebook.presto.metadata.FunctionManager;
import com.facebook.presto.operator.scalar.BuiltInScalarFunctionImplementation;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.function.FunctionHandle;
import com.google.common.base.Defaults;
import com.google.common.base.Throwables;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleProxies;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class InterpretedFunctionInvoker {
    private final FunctionManager functionManager;

    public InterpretedFunctionInvoker(FunctionManager functionManager) {
        this.functionManager = Objects.requireNonNull(functionManager, "registry is null");
    }

    public Object invoke(FunctionHandle functionHandle, ConnectorSession session, Object ... arguments) {
        return this.invoke(functionHandle, session, Arrays.asList(arguments));
    }

    public Object invoke(FunctionHandle functionHandle, ConnectorSession session, List<Object> arguments) {
        return this.invoke(this.functionManager.getBuiltInScalarFunctionImplementation(functionHandle), session, arguments);
    }

    private Object invoke(BuiltInScalarFunctionImplementation function, ConnectorSession session, List<Object> arguments) {
        MethodHandle method = function.getMethodHandle();
        if ((method = InterpretedFunctionInvoker.bindInstanceFactory(method, function)).type().parameterCount() > 0 && method.type().parameterType(0) == ConnectorSession.class) {
            method = method.bindTo(session);
        }
        ArrayList<Object> actualArguments = new ArrayList<Object>();
        for (int i = 0; i < arguments.size(); ++i) {
            Object argument = arguments.get(i);
            BuiltInScalarFunctionImplementation.ArgumentProperty argumentProperty = function.getArgumentProperty(i);
            if (argumentProperty.getArgumentType() == BuiltInScalarFunctionImplementation.ArgumentType.VALUE_TYPE) {
                if (function.getArgumentProperty(i).getNullConvention() == BuiltInScalarFunctionImplementation.NullConvention.RETURN_NULL_ON_NULL) {
                    if (argument == null) {
                        return null;
                    }
                    actualArguments.add(argument);
                    continue;
                }
                if (function.getArgumentProperty(i).getNullConvention() == BuiltInScalarFunctionImplementation.NullConvention.USE_NULL_FLAG) {
                    boolean isNull;
                    boolean bl = isNull = argument == null;
                    if (isNull) {
                        argument = Defaults.defaultValue((Class)method.type().parameterType(actualArguments.size()));
                    }
                    actualArguments.add(argument);
                    actualArguments.add(isNull);
                    continue;
                }
                actualArguments.add(argument);
                continue;
            }
            argument = MethodHandleProxies.asInterfaceInstance(argumentProperty.getLambdaInterface(), (MethodHandle)argument);
            actualArguments.add(argument);
        }
        try {
            return method.invokeWithArguments(actualArguments);
        }
        catch (Throwable throwable) {
            throw InterpretedFunctionInvoker.propagate(throwable);
        }
    }

    private static MethodHandle bindInstanceFactory(MethodHandle method, BuiltInScalarFunctionImplementation implementation) {
        if (!implementation.getInstanceFactory().isPresent()) {
            return method;
        }
        try {
            return method.bindTo(implementation.getInstanceFactory().get().invoke());
        }
        catch (Throwable throwable) {
            throw InterpretedFunctionInvoker.propagate(throwable);
        }
    }

    private static RuntimeException propagate(Throwable throwable) {
        if (throwable instanceof InterruptedException) {
            Thread.currentThread().interrupt();
        }
        Throwables.throwIfUnchecked((Throwable)throwable);
        throw new RuntimeException(throwable);
    }
}

