/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.execution.warnings.WarningCollector;
import com.facebook.presto.spi.PrestoWarning;
import com.facebook.presto.spi.StandardWarningCode;
import com.facebook.presto.spi.WarningCodeSupplier;
import com.facebook.presto.sql.parser.ParsingOptions;

public class ParsingUtil {
    private ParsingUtil() {
    }

    public static ParsingOptions createParsingOptions(Session session) {
        return ParsingUtil.createParsingOptions(session, WarningCollector.NOOP);
    }

    public static ParsingOptions createParsingOptions(Session session, WarningCollector warningCollector) {
        return ParsingOptions.builder().setDecimalLiteralTreatment(SystemSessionProperties.isParseDecimalLiteralsAsDouble(session) ? ParsingOptions.DecimalLiteralTreatment.AS_DOUBLE : ParsingOptions.DecimalLiteralTreatment.AS_DECIMAL).setWarningConsumer(warning -> warningCollector.add(new PrestoWarning((WarningCodeSupplier)StandardWarningCode.PARSER_WARNING, warning.getMessage()))).build();
    }
}

