/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.expressions.LogicalRowExpressions;
import com.facebook.presto.expressions.RowExpressionNodeInliner;
import com.facebook.presto.expressions.RowExpressionRewriter;
import com.facebook.presto.expressions.RowExpressionTreeRewriter;
import com.facebook.presto.metadata.FunctionManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.function.OperatorType;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.SpecialFormExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.sql.planner.NullabilityAnalyzer;
import com.facebook.presto.sql.planner.VariablesExtractor;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.sql.relational.RowExpressionDeterminismEvaluator;
import com.facebook.presto.util.DisjointSet;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import com.google.common.collect.SetMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class RowExpressionEqualityInference {
    private static final Ordering<RowExpression> CANONICAL_ORDERING = Ordering.from((expression1, expression2) -> ComparisonChain.start().compare(VariablesExtractor.extractAll(expression1).size(), VariablesExtractor.extractAll(expression2).size()).compare(Expressions.uniqueSubExpressions(expression1).size(), Expressions.uniqueSubExpressions(expression2).size()).compare((Comparable)((Object)expression1.toString()), (Comparable)((Object)expression2.toString())).result());
    private final SetMultimap<RowExpression, RowExpression> equalitySets;
    private final Map<RowExpression, RowExpression> canonicalMap;
    private final Set<RowExpression> derivedExpressions;
    private final RowExpressionDeterminismEvaluator determinismEvaluator;
    private final FunctionManager functionManager;

    private RowExpressionEqualityInference(Iterable<Set<RowExpression>> equalityGroups, Set<RowExpression> derivedExpressions, RowExpressionDeterminismEvaluator determinismEvaluator, FunctionManager functionManager) {
        this.determinismEvaluator = determinismEvaluator;
        this.functionManager = functionManager;
        ImmutableSetMultimap.Builder setBuilder = ImmutableSetMultimap.builder();
        for (Set<RowExpression> equalityGroup : equalityGroups) {
            if (equalityGroup.isEmpty()) continue;
            setBuilder.putAll(CANONICAL_ORDERING.min(equalityGroup), equalityGroup);
        }
        this.equalitySets = setBuilder.build();
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        for (Map.Entry entry : this.equalitySets.entries()) {
            RowExpression canonical = (RowExpression)entry.getKey();
            RowExpression expression = (RowExpression)entry.getValue();
            mapBuilder.put((Object)expression, (Object)canonical);
        }
        this.canonicalMap = mapBuilder.build();
        this.derivedExpressions = ImmutableSet.copyOf(derivedExpressions);
    }

    public static RowExpressionEqualityInference createEqualityInference(Metadata metadata, RowExpression ... equalityInferences) {
        return new Builder(metadata).addEqualityInference(equalityInferences).build();
    }

    public RowExpression rewriteExpression(RowExpression expression, Predicate<VariableReferenceExpression> variableScope) {
        Preconditions.checkArgument((boolean)this.determinismEvaluator.isDeterministic(expression), (Object)"Only deterministic expressions may be considered for rewrite");
        return this.rewriteExpression(expression, variableScope, true);
    }

    public RowExpression rewriteExpressionAllowNonDeterministic(RowExpression expression, Predicate<VariableReferenceExpression> variableScope) {
        return this.rewriteExpression(expression, variableScope, true);
    }

    private RowExpression rewriteExpression(RowExpression expression, Predicate<VariableReferenceExpression> variableScope, boolean allowFullReplacement) {
        Iterable<Object> subExpressions = Expressions.uniqueSubExpressions(expression);
        if (!allowFullReplacement) {
            subExpressions = Iterables.filter(subExpressions, (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)expression)));
        }
        ImmutableMap.Builder expressionRemap = ImmutableMap.builder();
        for (RowExpression subExpression : subExpressions) {
            RowExpression canonical = this.getScopedCanonical(subExpression, variableScope);
            if (canonical == null) continue;
            expressionRemap.put((Object)subExpression, (Object)canonical);
        }
        RowExpression rewritten = RowExpressionTreeRewriter.rewriteWith((RowExpressionRewriter)new RowExpressionNodeInliner((Map)expressionRemap.build()), (RowExpression)expression);
        if (!RowExpressionEqualityInference.variableToExpressionPredicate(variableScope).apply((Object)rewritten)) {
            return null;
        }
        return rewritten;
    }

    public EqualityPartition generateEqualitiesPartitionedBy(Predicate<VariableReferenceExpression> variableScope) {
        ImmutableSet.Builder scopeEqualities = ImmutableSet.builder();
        ImmutableSet.Builder scopeComplementEqualities = ImmutableSet.builder();
        ImmutableSet.Builder scopeStraddlingEqualities = ImmutableSet.builder();
        for (Collection equalitySet : this.equalitySets.asMap().values()) {
            LinkedHashSet<RowExpression> scopeExpressions = new LinkedHashSet<RowExpression>();
            LinkedHashSet<RowExpression> scopeComplementExpressions = new LinkedHashSet<RowExpression>();
            LinkedHashSet<Object> scopeStraddlingExpressions = new LinkedHashSet<Object>();
            for (Object expression : Iterables.filter((Iterable)equalitySet, (Predicate)Predicates.not(this.derivedExpressions::contains))) {
                RowExpression scopeComplementRewritten;
                RowExpression scopeRewritten = this.rewriteExpression((RowExpression)expression, variableScope, false);
                if (scopeRewritten != null) {
                    scopeExpressions.add(scopeRewritten);
                }
                if ((scopeComplementRewritten = this.rewriteExpression((RowExpression)expression, (Predicate<VariableReferenceExpression>)Predicates.not(variableScope), false)) != null) {
                    scopeComplementExpressions.add(scopeComplementRewritten);
                }
                if (scopeRewritten != null || scopeComplementRewritten != null) continue;
                scopeStraddlingExpressions.add(expression);
            }
            RowExpression matchingCanonical = RowExpressionEqualityInference.getCanonical(scopeExpressions);
            if (scopeExpressions.size() >= 2) {
                Object expression;
                expression = Iterables.filter(scopeExpressions, (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)matchingCanonical))).iterator();
                while (expression.hasNext()) {
                    RowExpression expression2 = (RowExpression)expression.next();
                    scopeEqualities.add((Object)RowExpressionEqualityInference.buildEqualsExpression(this.functionManager, matchingCanonical, expression2));
                }
            }
            RowExpression complementCanonical = RowExpressionEqualityInference.getCanonical(scopeComplementExpressions);
            if (scopeComplementExpressions.size() >= 2) {
                for (RowExpression expression : Iterables.filter(scopeComplementExpressions, (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)complementCanonical)))) {
                    scopeComplementEqualities.add((Object)RowExpressionEqualityInference.buildEqualsExpression(this.functionManager, complementCanonical, expression));
                }
            }
            ImmutableList connectingExpressions = new ArrayList();
            connectingExpressions.add(matchingCanonical);
            connectingExpressions.add(complementCanonical);
            connectingExpressions.addAll(scopeStraddlingExpressions);
            RowExpression connectingCanonical = RowExpressionEqualityInference.getCanonical((Iterable<RowExpression>)(connectingExpressions = ImmutableList.copyOf((Iterable)Iterables.filter(connectingExpressions, (Predicate)Predicates.notNull()))));
            if (connectingCanonical == null) continue;
            for (RowExpression expression : Iterables.filter((Iterable)connectingExpressions, (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)connectingCanonical)))) {
                scopeStraddlingEqualities.add((Object)RowExpressionEqualityInference.buildEqualsExpression(this.functionManager, connectingCanonical, expression));
            }
        }
        return new EqualityPartition((Iterable<RowExpression>)scopeEqualities.build(), (Iterable<RowExpression>)scopeComplementEqualities.build(), (Iterable<RowExpression>)scopeStraddlingEqualities.build());
    }

    private static RowExpression getCanonical(Iterable<RowExpression> expressions) {
        if (Iterables.isEmpty(expressions)) {
            return null;
        }
        return (RowExpression)CANONICAL_ORDERING.min(expressions);
    }

    @VisibleForTesting
    RowExpression getScopedCanonical(RowExpression expression, Predicate<VariableReferenceExpression> variableScope) {
        RowExpression canonicalIndex = this.canonicalMap.get(expression);
        if (canonicalIndex == null) {
            return null;
        }
        return RowExpressionEqualityInference.getCanonical(Iterables.filter((Iterable)this.equalitySets.get((Object)canonicalIndex), RowExpressionEqualityInference.variableToExpressionPredicate(variableScope)));
    }

    private static Predicate<RowExpression> variableToExpressionPredicate(Predicate<VariableReferenceExpression> variableScope) {
        return expression -> Iterables.all(VariablesExtractor.extractUnique(expression), (Predicate)variableScope);
    }

    private static RowExpression getLeft(RowExpression expression) {
        Preconditions.checkArgument((expression instanceof CallExpression && ((CallExpression)expression).getArguments().size() == 2 ? 1 : 0) != 0, (Object)"must be binary call expression");
        return (RowExpression)((CallExpression)expression).getArguments().get(0);
    }

    private static RowExpression getRight(RowExpression expression) {
        Preconditions.checkArgument((expression instanceof CallExpression && ((CallExpression)expression).getArguments().size() == 2 ? 1 : 0) != 0, (Object)"must be binary call expression");
        return (RowExpression)((CallExpression)expression).getArguments().get(1);
    }

    private static boolean isInPredicate(RowExpression expression) {
        if (expression instanceof SpecialFormExpression) {
            return ((SpecialFormExpression)expression).getForm() == SpecialFormExpression.Form.IN;
        }
        return false;
    }

    private static CallExpression buildEqualsExpression(FunctionManager functionManager, RowExpression left, RowExpression right) {
        return RowExpressionEqualityInference.binaryOperation(functionManager, OperatorType.EQUAL, left, right);
    }

    private static CallExpression binaryOperation(FunctionManager functionManager, OperatorType type, RowExpression left, RowExpression right) {
        return Expressions.call(type.getFunctionName().getFunctionName(), functionManager.resolveOperator(type, TypeSignatureProvider.fromTypes(left.getType(), right.getType())), (Type)BooleanType.BOOLEAN, left, right);
    }

    public static class Builder {
        private final DisjointSet<RowExpression> equalities = new DisjointSet();
        private final Set<RowExpression> derivedExpressions = new LinkedHashSet<RowExpression>();
        private final FunctionManager functionManager;
        private final NullabilityAnalyzer nullabilityAnalyzer;
        private final RowExpressionDeterminismEvaluator determinismEvaluator;

        public Builder(FunctionManager functionManager, TypeManager typeManager) {
            this.determinismEvaluator = new RowExpressionDeterminismEvaluator(functionManager);
            this.functionManager = functionManager;
            this.nullabilityAnalyzer = new NullabilityAnalyzer(functionManager, typeManager);
        }

        public Builder(Metadata metadata) {
            this(metadata.getFunctionManager(), metadata.getTypeManager());
        }

        public Predicate<RowExpression> isInferenceCandidate() {
            return expression -> {
                if (this.isOperation(expression = this.normalizeInPredicateToEquality((RowExpression)expression), OperatorType.EQUAL) && this.determinismEvaluator.isDeterministic((RowExpression)expression) && !this.nullabilityAnalyzer.mayReturnNullOnNonNullInput((RowExpression)expression)) {
                    return !RowExpressionEqualityInference.getLeft(expression).equals((Object)RowExpressionEqualityInference.getRight(expression));
                }
                return false;
            };
        }

        public static Predicate<RowExpression> isInferenceCandidate(Metadata metadata) {
            return new Builder(metadata).isInferenceCandidate();
        }

        private RowExpression normalizeInPredicateToEquality(RowExpression expression) {
            if (RowExpressionEqualityInference.isInPredicate(expression)) {
                int size = ((SpecialFormExpression)expression).getArguments().size() - 1;
                Preconditions.checkArgument((size >= 1 ? 1 : 0) != 0, (Object)"InList cannot be empty");
                if (size == 1) {
                    RowExpression leftValue = (RowExpression)((SpecialFormExpression)expression).getArguments().get(0);
                    RowExpression rightValue = (RowExpression)((SpecialFormExpression)expression).getArguments().get(1);
                    return RowExpressionEqualityInference.buildEqualsExpression(this.functionManager, leftValue, rightValue);
                }
            }
            return expression;
        }

        public Iterable<RowExpression> nonInferrableConjuncts(RowExpression expression) {
            return Iterables.filter((Iterable)LogicalRowExpressions.extractConjuncts((RowExpression)expression), (Predicate)Predicates.not(this.isInferenceCandidate()));
        }

        public static Iterable<RowExpression> nonInferrableConjuncts(Metadata metadata, RowExpression expression) {
            return new Builder(metadata).nonInferrableConjuncts(expression);
        }

        public Builder addEqualityInference(RowExpression ... expressions) {
            for (RowExpression expression : expressions) {
                this.extractInferenceCandidates(expression);
            }
            return this;
        }

        public Builder extractInferenceCandidates(RowExpression expression) {
            return this.addAllEqualities(Iterables.filter((Iterable)LogicalRowExpressions.extractConjuncts((RowExpression)expression), this.isInferenceCandidate()));
        }

        public Builder addAllEqualities(Iterable<RowExpression> expressions) {
            for (RowExpression expression : expressions) {
                this.addEquality(expression);
            }
            return this;
        }

        public Builder addEquality(RowExpression expression) {
            expression = this.normalizeInPredicateToEquality(expression);
            Preconditions.checkArgument((boolean)this.isInferenceCandidate().apply((Object)expression), (Object)("RowExpression must be a simple equality: " + expression));
            this.addEquality(RowExpressionEqualityInference.getLeft(expression), RowExpressionEqualityInference.getRight(expression));
            return this;
        }

        public Builder addEquality(RowExpression expression1, RowExpression expression2) {
            Preconditions.checkArgument((!expression1.equals((Object)expression2) ? 1 : 0) != 0, (Object)"Need to provide equality between different expressions");
            Preconditions.checkArgument((boolean)this.determinismEvaluator.isDeterministic(expression1), (Object)("RowExpression must be deterministic: " + expression1));
            Preconditions.checkArgument((boolean)this.determinismEvaluator.isDeterministic(expression2), (Object)("RowExpression must be deterministic: " + expression2));
            this.equalities.findAndUnion(expression1, expression2);
            return this;
        }

        private void generateMoreEquivalences() {
            Collection<Set<RowExpression>> equivalentClasses = this.equalities.getEquivalentClasses();
            ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
            for (Set<RowExpression> expressions : equivalentClasses) {
                expressions.forEach(expression -> mapBuilder.put(expression, (Object)expressions));
            }
            ImmutableMap map = mapBuilder.build();
            for (RowExpression expression2 : map.keySet()) {
                if (this.derivedExpressions.contains(expression2)) continue;
                for (RowExpression subExpression : Iterables.filter(Expressions.uniqueSubExpressions(expression2), (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)expression2)))) {
                    Set equivalentSubExpressions = (Set)map.get(subExpression);
                    if (equivalentSubExpressions == null) continue;
                    for (RowExpression equivalentSubExpression : Iterables.filter((Iterable)equivalentSubExpressions, (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)subExpression)))) {
                        RowExpression rewritten = RowExpressionTreeRewriter.rewriteWith((RowExpressionRewriter)new RowExpressionNodeInliner((Map)ImmutableMap.of((Object)subExpression, (Object)equivalentSubExpression)), (RowExpression)expression2);
                        this.equalities.findAndUnion(expression2, rewritten);
                        this.derivedExpressions.add(rewritten);
                    }
                }
            }
        }

        public RowExpressionEqualityInference build() {
            this.generateMoreEquivalences();
            return new RowExpressionEqualityInference(this.equalities.getEquivalentClasses(), this.derivedExpressions, this.determinismEvaluator, this.functionManager);
        }

        private boolean isOperation(RowExpression expression, OperatorType type) {
            CallExpression call;
            Optional expressionOperatorType;
            if (expression instanceof CallExpression && (expressionOperatorType = this.functionManager.getFunctionMetadata((call = (CallExpression)expression).getFunctionHandle()).getOperatorType()).isPresent()) {
                return expressionOperatorType.get() == type;
            }
            return false;
        }
    }

    public static class EqualityPartition {
        private final List<RowExpression> scopeEqualities;
        private final List<RowExpression> scopeComplementEqualities;
        private final List<RowExpression> scopeStraddlingEqualities;

        public EqualityPartition(Iterable<RowExpression> scopeEqualities, Iterable<RowExpression> scopeComplementEqualities, Iterable<RowExpression> scopeStraddlingEqualities) {
            this.scopeEqualities = ImmutableList.copyOf(Objects.requireNonNull(scopeEqualities, "scopeEqualities is null"));
            this.scopeComplementEqualities = ImmutableList.copyOf(Objects.requireNonNull(scopeComplementEqualities, "scopeComplementEqualities is null"));
            this.scopeStraddlingEqualities = ImmutableList.copyOf(Objects.requireNonNull(scopeStraddlingEqualities, "scopeStraddlingEqualities is null"));
        }

        public List<RowExpression> getScopeEqualities() {
            return this.scopeEqualities;
        }

        public List<RowExpression> getScopeComplementEqualities() {
            return this.scopeComplementEqualities;
        }

        public List<RowExpression> getScopeStraddlingEqualities() {
            return this.scopeStraddlingEqualities;
        }
    }
}

