/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.airlift.concurrent.MoreFutures;
import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.execution.Lifespan;
import com.facebook.presto.expressions.RowExpressionNodeInliner;
import com.facebook.presto.geospatial.KdbTree;
import com.facebook.presto.geospatial.KdbTreeUtils;
import com.facebook.presto.matching.Capture;
import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.metadata.CastType;
import com.facebook.presto.metadata.FunctionManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.QualifiedObjectName;
import com.facebook.presto.metadata.Split;
import com.facebook.presto.metadata.TableLayoutResult;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.Constraint;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.connector.ConnectorSplitManager;
import com.facebook.presto.spi.connector.NotPartitionedPartitionHandle;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.function.FunctionMetadata;
import com.facebook.presto.spi.function.OperatorType;
import com.facebook.presto.spi.plan.Assignments;
import com.facebook.presto.spi.plan.FilterNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.spi.type.ArrayType;
import com.facebook.presto.spi.type.IntegerType;
import com.facebook.presto.spi.type.KdbTreeType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.split.PageSourceManager;
import com.facebook.presto.split.SplitManager;
import com.facebook.presto.split.SplitSource;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.sql.planner.VariablesExtractor;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.facebook.presto.sql.planner.plan.SpatialJoinNode;
import com.facebook.presto.sql.planner.plan.UnnestNode;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.util.SpatialJoinUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import io.airlift.slice.Slices;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Future;

public class ExtractSpatialJoins {
    private static final TypeSignature SPHERICAL_GEOGRAPHY_TYPE_SIGNATURE = TypeSignature.parseTypeSignature((String)"SphericalGeography");
    private final Metadata metadata;
    private final SplitManager splitManager;
    private final PageSourceManager pageSourceManager;

    public ExtractSpatialJoins(Metadata metadata, SplitManager splitManager, PageSourceManager pageSourceManager) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.splitManager = Objects.requireNonNull(splitManager, "splitManager is null");
        this.pageSourceManager = Objects.requireNonNull(pageSourceManager, "pageSourceManager is null");
    }

    public Set<Rule<?>> rules() {
        return ImmutableSet.of((Object)new ExtractSpatialInnerJoin(this.metadata, this.splitManager, this.pageSourceManager), (Object)new ExtractSpatialLeftJoin(this.metadata, this.splitManager, this.pageSourceManager));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Rule.Result tryCreateSpatialJoin(Rule.Context context, JoinNode joinNode, RowExpression filter, PlanNodeId nodeId, List<VariableReferenceExpression> outputVariables, CallExpression spatialComparison, Metadata metadata, SplitManager splitManager, PageSourceManager pageSourceManager) {
        CallExpression newComparison;
        Optional<VariableReferenceExpression> newRadiusVariable;
        Set<VariableReferenceExpression> radiusVariables;
        RowExpression radius;
        FunctionMetadata spatialComparisonMetadata = metadata.getFunctionManager().getFunctionMetadata(spatialComparison.getFunctionHandle());
        Preconditions.checkArgument((spatialComparison.getArguments().size() == 2 && spatialComparisonMetadata.getOperatorType().isPresent() ? 1 : 0) != 0);
        PlanNode leftNode = joinNode.getLeft();
        PlanNode rightNode = joinNode.getRight();
        List leftVariables = leftNode.getOutputVariables();
        List rightVariables = rightNode.getOutputVariables();
        if (spatialComparisonMetadata.getOperatorType().get() == OperatorType.LESS_THAN || spatialComparisonMetadata.getOperatorType().get() == OperatorType.LESS_THAN_OR_EQUAL) {
            radius = (RowExpression)spatialComparison.getArguments().get(1);
            radiusVariables = VariablesExtractor.extractUnique(radius);
            if (!radiusVariables.isEmpty() && (!rightVariables.containsAll(radiusVariables) || !ExtractSpatialJoins.containsNone(leftVariables, radiusVariables))) return Rule.Result.empty();
            newRadiusVariable = ExtractSpatialJoins.newRadiusVariable(context, radius);
            newComparison = new CallExpression(spatialComparison.getDisplayName(), spatialComparison.getFunctionHandle(), spatialComparison.getType(), (List)ImmutableList.of(spatialComparison.getArguments().get(0), (Object)ExtractSpatialJoins.mapToExpression(newRadiusVariable, radius)));
        } else {
            radius = (RowExpression)spatialComparison.getArguments().get(0);
            radiusVariables = VariablesExtractor.extractUnique(radius);
            if (!radiusVariables.isEmpty() && (!rightVariables.containsAll(radiusVariables) || !ExtractSpatialJoins.containsNone(leftVariables, radiusVariables))) return Rule.Result.empty();
            newRadiusVariable = ExtractSpatialJoins.newRadiusVariable(context, radius);
            OperatorType flippedOperatorType = SpatialJoinUtils.flip((OperatorType)spatialComparisonMetadata.getOperatorType().get());
            FunctionHandle flippedHandle = SpatialJoinUtils.getFlippedFunctionHandle(spatialComparison, metadata.getFunctionManager());
            newComparison = new CallExpression(flippedOperatorType.getOperator(), flippedHandle, spatialComparison.getType(), (List)ImmutableList.of(spatialComparison.getArguments().get(1), (Object)ExtractSpatialJoins.mapToExpression(newRadiusVariable, radius)));
        }
        RowExpression newFilter = RowExpressionNodeInliner.replaceExpression((RowExpression)filter, (Map)ImmutableMap.of((Object)spatialComparison, (Object)newComparison));
        PlanNode newRightNode = newRadiusVariable.map(variable -> ExtractSpatialJoins.addProjection(context, rightNode, variable, radius)).orElse(rightNode);
        JoinNode newJoinNode = new JoinNode(joinNode.getId(), joinNode.getType(), leftNode, newRightNode, joinNode.getCriteria(), joinNode.getOutputVariables(), Optional.of(newFilter), joinNode.getLeftHashVariable(), joinNode.getRightHashVariable(), joinNode.getDistributionType());
        return ExtractSpatialJoins.tryCreateSpatialJoin(context, newJoinNode, newFilter, nodeId, outputVariables, (CallExpression)newComparison.getArguments().get(0), Optional.of(newComparison.getArguments().get(1)), metadata, splitManager, pageSourceManager);
    }

    private static Rule.Result tryCreateSpatialJoin(Rule.Context context, JoinNode joinNode, RowExpression filter, PlanNodeId nodeId, List<VariableReferenceExpression> outputVariables, CallExpression spatialFunction, Optional<RowExpression> radius, Metadata metadata, SplitManager splitManager, PageSourceManager pageSourceManager) {
        PlanNode newRightNode;
        PlanNode newLeftNode;
        Optional<String> spatialPartitioningTableName = joinNode.getType() == JoinNode.Type.INNER ? SystemSessionProperties.getSpatialPartitioningTableName(context.getSession()) : Optional.empty();
        Optional<KdbTree> kdbTree = spatialPartitioningTableName.map(tableName -> ExtractSpatialJoins.loadKdbTree(tableName, context.getSession(), metadata, splitManager, pageSourceManager));
        FunctionManager functionManager = metadata.getFunctionManager();
        List arguments = spatialFunction.getArguments();
        Verify.verify((arguments.size() == 2 ? 1 : 0) != 0);
        RowExpression firstArgument = (RowExpression)arguments.get(0);
        RowExpression secondArgument = (RowExpression)arguments.get(1);
        Type sphericalGeographyType = metadata.getType(SPHERICAL_GEOGRAPHY_TYPE_SIGNATURE);
        if (firstArgument.getType().equals(sphericalGeographyType) || secondArgument.getType().equals(sphericalGeographyType)) {
            return Rule.Result.empty();
        }
        Set<VariableReferenceExpression> firstVariables = VariablesExtractor.extractUnique(firstArgument);
        Set<VariableReferenceExpression> secondVariables = VariablesExtractor.extractUnique(secondArgument);
        if (firstVariables.isEmpty() || secondVariables.isEmpty()) {
            return Rule.Result.empty();
        }
        Optional<VariableReferenceExpression> newFirstVariable = ExtractSpatialJoins.newGeometryVariable(context, firstArgument, metadata);
        Optional<VariableReferenceExpression> newSecondVariable = ExtractSpatialJoins.newGeometryVariable(context, secondArgument, metadata);
        PlanNode leftNode = joinNode.getLeft();
        PlanNode rightNode = joinNode.getRight();
        int alignment = ExtractSpatialJoins.checkAlignment(joinNode, firstVariables, secondVariables);
        if (alignment > 0) {
            newLeftNode = newFirstVariable.map(variable -> ExtractSpatialJoins.addProjection(context, leftNode, variable, firstArgument)).orElse(leftNode);
            newRightNode = newSecondVariable.map(variable -> ExtractSpatialJoins.addProjection(context, rightNode, variable, secondArgument)).orElse(rightNode);
        } else if (alignment < 0) {
            newLeftNode = newSecondVariable.map(variable -> ExtractSpatialJoins.addProjection(context, leftNode, variable, secondArgument)).orElse(leftNode);
            newRightNode = newFirstVariable.map(variable -> ExtractSpatialJoins.addProjection(context, rightNode, variable, firstArgument)).orElse(rightNode);
        } else {
            return Rule.Result.empty();
        }
        RowExpression newFirstArgument = ExtractSpatialJoins.mapToExpression(newFirstVariable, firstArgument);
        RowExpression newSecondArgument = ExtractSpatialJoins.mapToExpression(newSecondVariable, secondArgument);
        Optional<Object> leftPartitionVariable = Optional.empty();
        Optional<Object> rightPartitionVariable = Optional.empty();
        if (kdbTree.isPresent()) {
            leftPartitionVariable = Optional.of(context.getVariableAllocator().newVariable("pid", (Type)IntegerType.INTEGER));
            rightPartitionVariable = Optional.of(context.getVariableAllocator().newVariable("pid", (Type)IntegerType.INTEGER));
            if (alignment > 0) {
                newLeftNode = ExtractSpatialJoins.addPartitioningNodes(context, functionManager, newLeftNode, (VariableReferenceExpression)leftPartitionVariable.get(), kdbTree.get(), newFirstArgument, Optional.empty());
                newRightNode = ExtractSpatialJoins.addPartitioningNodes(context, functionManager, newRightNode, (VariableReferenceExpression)rightPartitionVariable.get(), kdbTree.get(), newSecondArgument, radius);
            } else {
                newLeftNode = ExtractSpatialJoins.addPartitioningNodes(context, functionManager, newLeftNode, (VariableReferenceExpression)leftPartitionVariable.get(), kdbTree.get(), newSecondArgument, Optional.empty());
                newRightNode = ExtractSpatialJoins.addPartitioningNodes(context, functionManager, newRightNode, (VariableReferenceExpression)rightPartitionVariable.get(), kdbTree.get(), newFirstArgument, radius);
            }
        }
        CallExpression newSpatialFunction = new CallExpression(spatialFunction.getDisplayName(), spatialFunction.getFunctionHandle(), spatialFunction.getType(), (List)ImmutableList.of((Object)newFirstArgument, (Object)newSecondArgument));
        RowExpression newFilter = RowExpressionNodeInliner.replaceExpression((RowExpression)filter, (Map)ImmutableMap.of((Object)spatialFunction, (Object)newSpatialFunction));
        return Rule.Result.ofPlanNode(new SpatialJoinNode(nodeId, SpatialJoinNode.Type.fromJoinNodeType(joinNode.getType()), newLeftNode, newRightNode, outputVariables, newFilter, leftPartitionVariable, rightPartitionVariable, kdbTree.map(KdbTreeUtils::toJson)));
    }

    private static KdbTree loadKdbTree(String tableName, Session session, Metadata metadata, SplitManager splitManager, PageSourceManager pageSourceManager) {
        QualifiedObjectName name = ExtractSpatialJoins.toQualifiedObjectName(tableName, session.getCatalog().get(), session.getSchema().get());
        TableHandle tableHandle = metadata.getTableHandle(session, name).orElseThrow(() -> new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SPATIAL_PARTITIONING, String.format("Table not found: %s", name)));
        Map<String, ColumnHandle> columnHandles = metadata.getColumnHandles(session, tableHandle);
        List visibleColumnHandles = (List)columnHandles.values().stream().filter(handle -> !metadata.getColumnMetadata(session, tableHandle, (ColumnHandle)handle).isHidden()).collect(ImmutableList.toImmutableList());
        ExtractSpatialJoins.checkSpatialPartitioningTable(visibleColumnHandles.size() == 1, "Expected single column for table %s, but found %s columns", name, columnHandles.size());
        ColumnHandle kdbTreeColumn = (ColumnHandle)Iterables.getOnlyElement((Iterable)visibleColumnHandles);
        TableLayoutResult layout = metadata.getLayout(session, tableHandle, (Constraint<ColumnHandle>)Constraint.alwaysTrue(), Optional.of(ImmutableSet.of((Object)kdbTreeColumn)));
        TableHandle newTableHandle = layout.getLayout().getNewTableHandle();
        Optional<Object> kdbTree = Optional.empty();
        try (SplitSource splitSource = splitManager.getSplits(session, newTableHandle, ConnectorSplitManager.SplitSchedulingStrategy.UNGROUPED_SCHEDULING);){
            while (!Thread.currentThread().isInterrupted()) {
                SplitSource.SplitBatch splitBatch = (SplitSource.SplitBatch)MoreFutures.getFutureValue(splitSource.getNextBatch(NotPartitionedPartitionHandle.NOT_PARTITIONED, Lifespan.taskWide(), 1000));
                List<Split> splits = splitBatch.getSplits();
                for (Split split : splits) {
                    try {
                        ConnectorPageSource pageSource = pageSourceManager.createPageSource(session, split, newTableHandle, (List<ColumnHandle>)ImmutableList.of((Object)kdbTreeColumn));
                        Throwable throwable = null;
                        try {
                            do {
                                MoreFutures.getFutureValue((Future)pageSource.isBlocked());
                                Page page = pageSource.getNextPage();
                                if (page == null || page.getPositionCount() <= 0) continue;
                                ExtractSpatialJoins.checkSpatialPartitioningTable(!kdbTree.isPresent(), "Expected exactly one row for table %s, but found more", name);
                                ExtractSpatialJoins.checkSpatialPartitioningTable(page.getPositionCount() == 1, "Expected exactly one row for table %s, but found %s rows", name, page.getPositionCount());
                                String kdbTreeJson = VarcharType.VARCHAR.getSlice(page.getBlock(0), 0).toStringUtf8();
                                try {
                                    kdbTree = Optional.of(KdbTreeUtils.fromJson((String)kdbTreeJson));
                                }
                                catch (IllegalArgumentException e) {
                                    ExtractSpatialJoins.checkSpatialPartitioningTable(false, "Invalid JSON string for KDB tree: %s", e.getMessage());
                                }
                            } while (!pageSource.isFinished());
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (pageSource == null) continue;
                            if (throwable != null) {
                                try {
                                    pageSource.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            pageSource.close();
                        }
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
                if (!splitBatch.isLastBatch()) continue;
                break;
            }
        }
        ExtractSpatialJoins.checkSpatialPartitioningTable(kdbTree.isPresent(), "Expected exactly one row for table %s, but got none", name);
        return (KdbTree)kdbTree.get();
    }

    private static void checkSpatialPartitioningTable(boolean condition, String message, Object ... arguments) {
        if (!condition) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SPATIAL_PARTITIONING, String.format(message, arguments));
        }
    }

    private static QualifiedObjectName toQualifiedObjectName(String name, String catalog, String schema) {
        ImmutableList ids = ImmutableList.copyOf((Iterable)Splitter.on((char)'.').split((CharSequence)name));
        if (ids.size() == 3) {
            return new QualifiedObjectName((String)ids.get(0), (String)ids.get(1), (String)ids.get(2));
        }
        if (ids.size() == 2) {
            return new QualifiedObjectName(catalog, (String)ids.get(0), (String)ids.get(1));
        }
        if (ids.size() == 1) {
            return new QualifiedObjectName(catalog, schema, (String)ids.get(0));
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SPATIAL_PARTITIONING, String.format("Invalid name: %s", name));
    }

    private static int checkAlignment(JoinNode joinNode, Set<VariableReferenceExpression> maybeLeftVariables, Set<VariableReferenceExpression> maybeRightVariables) {
        List leftVariables = joinNode.getLeft().getOutputVariables();
        List rightVariables = joinNode.getRight().getOutputVariables();
        if (leftVariables.containsAll(maybeLeftVariables) && ExtractSpatialJoins.containsNone(leftVariables, maybeRightVariables) && rightVariables.containsAll(maybeRightVariables) && ExtractSpatialJoins.containsNone(rightVariables, maybeLeftVariables)) {
            return 1;
        }
        if (leftVariables.containsAll(maybeRightVariables) && ExtractSpatialJoins.containsNone(leftVariables, maybeLeftVariables) && rightVariables.containsAll(maybeLeftVariables) && ExtractSpatialJoins.containsNone(rightVariables, maybeRightVariables)) {
            return -1;
        }
        return 0;
    }

    private static RowExpression mapToExpression(Optional<VariableReferenceExpression> optionalVariable, RowExpression defaultExpression) {
        return optionalVariable.map(RowExpression.class::cast).orElse(defaultExpression);
    }

    private static Optional<VariableReferenceExpression> newGeometryVariable(Rule.Context context, RowExpression expression, Metadata metadata) {
        if (expression instanceof VariableReferenceExpression) {
            return Optional.empty();
        }
        return Optional.of(context.getVariableAllocator().newVariable(expression));
    }

    private static Optional<VariableReferenceExpression> newRadiusVariable(Rule.Context context, RowExpression expression) {
        if (expression instanceof VariableReferenceExpression) {
            return Optional.empty();
        }
        return Optional.of(context.getVariableAllocator().newVariable(expression));
    }

    private static PlanNode addProjection(Rule.Context context, PlanNode node, VariableReferenceExpression variable, RowExpression expression) {
        Assignments.Builder projections = Assignments.builder();
        for (VariableReferenceExpression outputVariable : node.getOutputVariables()) {
            projections.put(outputVariable, (RowExpression)outputVariable);
        }
        projections.put(variable, expression);
        return new ProjectNode(context.getIdAllocator().getNextId(), node, projections.build());
    }

    private static PlanNode addPartitioningNodes(Rule.Context context, FunctionManager functionManager, PlanNode node, VariableReferenceExpression partitionVariable, KdbTree kdbTree, RowExpression geometry, Optional<RowExpression> radius) {
        Assignments.Builder projections = Assignments.builder();
        for (VariableReferenceExpression outputVariable : node.getOutputVariables()) {
            projections.put(outputVariable, (RowExpression)outputVariable);
        }
        FunctionHandle castFunctionHandle = functionManager.lookupCast(CastType.CAST, VarcharType.VARCHAR.getTypeSignature(), KdbTreeType.KDB_TREE.getTypeSignature());
        ImmutableList.Builder partitioningArgumentsBuilder = ImmutableList.builder().add((Object)new CallExpression(CastType.CAST.name(), castFunctionHandle, (Type)KdbTreeType.KDB_TREE, (List)ImmutableList.of((Object)Expressions.constant(Slices.utf8Slice((String)KdbTreeUtils.toJson((KdbTree)kdbTree)), (Type)VarcharType.VARCHAR)))).add((Object)geometry);
        radius.map(arg_0 -> ((ImmutableList.Builder)partitioningArgumentsBuilder).add(arg_0));
        ImmutableList partitioningArguments = partitioningArgumentsBuilder.build();
        String spatialPartitionsFunctionName = "spatial_partitions";
        FunctionHandle functionHandle = functionManager.lookupFunction(spatialPartitionsFunctionName, TypeSignatureProvider.fromTypes((List)partitioningArguments.stream().map(RowExpression::getType).collect(ImmutableList.toImmutableList())));
        CallExpression partitioningFunction = new CallExpression(spatialPartitionsFunctionName, functionHandle, (Type)new ArrayType((Type)IntegerType.INTEGER), (List)partitioningArguments);
        VariableReferenceExpression partitionsVariable = context.getVariableAllocator().newVariable((RowExpression)partitioningFunction);
        projections.put(partitionsVariable, (RowExpression)partitioningFunction);
        return new UnnestNode(context.getIdAllocator().getNextId(), (PlanNode)new ProjectNode(context.getIdAllocator().getNextId(), node, projections.build()), node.getOutputVariables(), (Map<VariableReferenceExpression, List<VariableReferenceExpression>>)ImmutableMap.of((Object)partitionsVariable, (Object)ImmutableList.of((Object)partitionVariable)), Optional.empty());
    }

    private static boolean containsNone(Collection<VariableReferenceExpression> values, Collection<VariableReferenceExpression> testValues) {
        return values.stream().noneMatch(arg_0 -> ((ImmutableSet)ImmutableSet.copyOf(testValues)).contains(arg_0));
    }

    @VisibleForTesting
    public static final class ExtractSpatialLeftJoin
    implements Rule<JoinNode> {
        private static final Pattern<JoinNode> PATTERN = Patterns.join().matching(node -> node.getCriteria().isEmpty() && node.getFilter().isPresent() && node.getType() == JoinNode.Type.LEFT);
        private final Metadata metadata;
        private final SplitManager splitManager;
        private final PageSourceManager pageSourceManager;
        private final FunctionManager functionManager;

        public ExtractSpatialLeftJoin(Metadata metadata, SplitManager splitManager, PageSourceManager pageSourceManager) {
            this.metadata = Objects.requireNonNull(metadata, "metadata is null");
            this.splitManager = Objects.requireNonNull(splitManager, "splitManager is null");
            this.pageSourceManager = Objects.requireNonNull(pageSourceManager, "pageSourceManager is null");
            this.functionManager = metadata.getFunctionManager();
        }

        @Override
        public boolean isEnabled(Session session) {
            return SystemSessionProperties.isSpatialJoinEnabled(session);
        }

        @Override
        public Pattern<JoinNode> getPattern() {
            return PATTERN;
        }

        @Override
        public Rule.Result apply(JoinNode joinNode, Captures captures, Rule.Context context) {
            Preconditions.checkArgument((boolean)joinNode.getFilter().isPresent());
            RowExpression filter = joinNode.getFilter().get();
            List<CallExpression> spatialFunctions = SpatialJoinUtils.extractSupportedSpatialFunctions(filter, this.functionManager);
            for (CallExpression spatialFunction : spatialFunctions) {
                Rule.Result result = ExtractSpatialJoins.tryCreateSpatialJoin(context, joinNode, filter, joinNode.getId(), joinNode.getOutputVariables(), spatialFunction, Optional.empty(), this.metadata, this.splitManager, this.pageSourceManager);
                if (result.isEmpty()) continue;
                return result;
            }
            List<CallExpression> spatialComparisons = SpatialJoinUtils.extractSupportedSpatialComparisons(filter, this.functionManager);
            for (CallExpression spatialComparison : spatialComparisons) {
                Rule.Result result = ExtractSpatialJoins.tryCreateSpatialJoin(context, joinNode, filter, joinNode.getId(), joinNode.getOutputVariables(), spatialComparison, this.metadata, this.splitManager, this.pageSourceManager);
                if (result.isEmpty()) continue;
                return result;
            }
            return Rule.Result.empty();
        }
    }

    @VisibleForTesting
    public static final class ExtractSpatialInnerJoin
    implements Rule<FilterNode> {
        private static final Capture<JoinNode> JOIN = Capture.newCapture();
        private static final Pattern<FilterNode> PATTERN = Patterns.filter().with(Patterns.source().matching(Patterns.join().capturedAs(JOIN).matching(JoinNode::isCrossJoin)));
        private final Metadata metadata;
        private final SplitManager splitManager;
        private final PageSourceManager pageSourceManager;
        private final FunctionManager functionManager;

        public ExtractSpatialInnerJoin(Metadata metadata, SplitManager splitManager, PageSourceManager pageSourceManager) {
            this.metadata = Objects.requireNonNull(metadata, "metadata is null");
            this.splitManager = Objects.requireNonNull(splitManager, "splitManager is null");
            this.pageSourceManager = Objects.requireNonNull(pageSourceManager, "pageSourceManager is null");
            this.functionManager = metadata.getFunctionManager();
        }

        @Override
        public boolean isEnabled(Session session) {
            return SystemSessionProperties.isSpatialJoinEnabled(session);
        }

        @Override
        public Pattern<FilterNode> getPattern() {
            return PATTERN;
        }

        @Override
        public Rule.Result apply(FilterNode node, Captures captures, Rule.Context context) {
            JoinNode joinNode = (JoinNode)((Object)captures.get(JOIN));
            RowExpression filter = node.getPredicate();
            List<CallExpression> spatialFunctions = SpatialJoinUtils.extractSupportedSpatialFunctions(filter, this.functionManager);
            for (CallExpression spatialFunction : spatialFunctions) {
                Rule.Result result = ExtractSpatialJoins.tryCreateSpatialJoin(context, joinNode, filter, node.getId(), node.getOutputVariables(), spatialFunction, Optional.empty(), this.metadata, this.splitManager, this.pageSourceManager);
                if (result.isEmpty()) continue;
                return result;
            }
            List<CallExpression> spatialComparisons = SpatialJoinUtils.extractSupportedSpatialComparisons(filter, this.functionManager);
            for (CallExpression spatialComparison : spatialComparisons) {
                Rule.Result result = ExtractSpatialJoins.tryCreateSpatialJoin(context, joinNode, filter, node.getId(), node.getOutputVariables(), spatialComparison, this.metadata, this.splitManager, this.pageSourceManager);
                if (result.isEmpty()) continue;
                return result;
            }
            return Rule.Result.empty();
        }
    }
}

