/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.sql.planner.iterative.Lookup;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.optimizations.QueryCardinalityUtil;
import com.facebook.presto.sql.planner.plan.LateralJoinNode;
import com.facebook.presto.sql.planner.plan.Patterns;

public class RemoveUnreferencedScalarLateralNodes
implements Rule<LateralJoinNode> {
    private static final Pattern<LateralJoinNode> PATTERN = Patterns.lateralJoin();

    @Override
    public Pattern<LateralJoinNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(LateralJoinNode lateralJoinNode, Captures captures, Rule.Context context) {
        PlanNode input = lateralJoinNode.getInput();
        PlanNode subquery = lateralJoinNode.getSubquery();
        if (this.isUnreferencedScalar(input, context.getLookup())) {
            return Rule.Result.ofPlanNode(subquery);
        }
        if (this.isUnreferencedScalar(subquery, context.getLookup())) {
            return Rule.Result.ofPlanNode(input);
        }
        return Rule.Result.empty();
    }

    private boolean isUnreferencedScalar(PlanNode planNode, Lookup lookup) {
        return planNode.getOutputVariables().isEmpty() && QueryCardinalityUtil.isScalar(planNode, lookup);
    }
}

