/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.relational;

import com.facebook.presto.metadata.FunctionManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.spi.relation.DeterminismEvaluator;
import com.facebook.presto.spi.relation.InputReferenceExpression;
import com.facebook.presto.spi.relation.LambdaDefinitionExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.RowExpressionVisitor;
import com.facebook.presto.spi.relation.SpecialFormExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import java.util.Objects;
import javax.inject.Inject;

public class RowExpressionDeterminismEvaluator
implements DeterminismEvaluator {
    private final FunctionManager functionManager;

    @Inject
    public RowExpressionDeterminismEvaluator(Metadata metadata) {
        this(Objects.requireNonNull(metadata, "metadata is null").getFunctionManager());
    }

    public RowExpressionDeterminismEvaluator(FunctionManager functionManager) {
        this.functionManager = Objects.requireNonNull(functionManager, "functionManager is null");
    }

    public boolean isDeterministic(RowExpression expression) {
        return (Boolean)expression.accept((RowExpressionVisitor)new Visitor(this.functionManager), null);
    }

    private static class Visitor
    implements RowExpressionVisitor<Boolean, Void> {
        private final FunctionManager functionManager;

        public Visitor(FunctionManager functionManager) {
            this.functionManager = functionManager;
        }

        public Boolean visitInputReference(InputReferenceExpression reference, Void context) {
            return true;
        }

        public Boolean visitConstant(ConstantExpression literal, Void context) {
            return true;
        }

        public Boolean visitCall(CallExpression call, Void context) {
            block3: {
                FunctionHandle functionHandle = call.getFunctionHandle();
                try {
                    if (!this.functionManager.getFunctionMetadata(functionHandle).isDeterministic()) {
                        return false;
                    }
                }
                catch (PrestoException e) {
                    if (e.getErrorCode().getCode() == StandardErrorCode.FUNCTION_IMPLEMENTATION_MISSING.toErrorCode().getCode()) break block3;
                    throw e;
                }
            }
            return call.getArguments().stream().allMatch(expression -> (Boolean)expression.accept((RowExpressionVisitor)this, (Object)context));
        }

        public Boolean visitLambda(LambdaDefinitionExpression lambda, Void context) {
            return (Boolean)lambda.getBody().accept((RowExpressionVisitor)this, (Object)context);
        }

        public Boolean visitVariableReference(VariableReferenceExpression reference, Void context) {
            return true;
        }

        public Boolean visitSpecialForm(SpecialFormExpression specialForm, Void context) {
            return specialForm.getArguments().stream().allMatch(expression -> (Boolean)expression.accept((RowExpressionVisitor)this, (Object)context));
        }
    }
}

