/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.testing;

import com.facebook.presto.execution.warnings.WarningCollector;
import com.facebook.presto.execution.warnings.WarningCollectorConfig;
import com.facebook.presto.spi.PrestoWarning;
import com.facebook.presto.spi.WarningCode;
import com.facebook.presto.testing.TestingWarningCollectorConfig;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class TestingWarningCollector
implements WarningCollector {
    @GuardedBy(value="this")
    private final Map<WarningCode, PrestoWarning> warnings = new LinkedHashMap<WarningCode, PrestoWarning>();
    private final WarningCollectorConfig config;
    private final boolean addWarnings;
    private final AtomicInteger warningCode = new AtomicInteger();

    public TestingWarningCollector(WarningCollectorConfig config, TestingWarningCollectorConfig testConfig) {
        this.config = Objects.requireNonNull(config, "config is null");
        Objects.requireNonNull(testConfig, "testConfig is null");
        this.addWarnings = testConfig.getAddWarnings();
        for (int warningCode = 1; warningCode <= testConfig.getPreloadedWarnings(); ++warningCode) {
            this.add(TestingWarningCollector.createTestWarning(warningCode));
        }
        this.warningCode.set(testConfig.getPreloadedWarnings());
    }

    @Override
    public synchronized void add(PrestoWarning warning) {
        Objects.requireNonNull(warning, "warning is null");
        if (this.warnings.size() < this.config.getMaxWarnings()) {
            this.warnings.putIfAbsent(warning.getWarningCode(), warning);
        }
    }

    @Override
    public synchronized List<PrestoWarning> getWarnings() {
        if (this.addWarnings) {
            this.add(TestingWarningCollector.createTestWarning(this.warningCode.incrementAndGet()));
        }
        return ImmutableList.copyOf(this.warnings.values());
    }

    @VisibleForTesting
    public static PrestoWarning createTestWarning(int code) {
        return new PrestoWarning(new WarningCode(code, String.format("015%02d", code % 100)), "Test warning " + code);
    }
}

