/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.util;

import com.facebook.presto.spi.type.DateTimeEncoding;
import com.facebook.presto.spi.type.TimeZoneKey;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.chrono.ISOChronology;

public final class DateTimeZoneIndex {
    private static final DateTimeZone[] DATE_TIME_ZONES = new DateTimeZone[TimeZoneKey.MAX_TIME_ZONE_KEY + 1];
    private static final ISOChronology[] CHRONOLOGIES = new ISOChronology[TimeZoneKey.MAX_TIME_ZONE_KEY + 1];
    private static final int[] FIXED_ZONE_OFFSET = new int[TimeZoneKey.MAX_TIME_ZONE_KEY + 1];
    private static final int VARIABLE_ZONE = Integer.MAX_VALUE;

    private DateTimeZoneIndex() {
    }

    public static ISOChronology getChronology(TimeZoneKey zoneKey) {
        return CHRONOLOGIES[zoneKey.getKey()];
    }

    public static ISOChronology unpackChronology(long timestampWithTimeZone) {
        return DateTimeZoneIndex.getChronology(DateTimeEncoding.unpackZoneKey((long)timestampWithTimeZone));
    }

    public static DateTimeZone getDateTimeZone(TimeZoneKey zoneKey) {
        return DATE_TIME_ZONES[zoneKey.getKey()];
    }

    public static DateTimeZone unpackDateTimeZone(long dateTimeWithTimeZone) {
        return DateTimeZoneIndex.getDateTimeZone(DateTimeEncoding.unpackZoneKey((long)dateTimeWithTimeZone));
    }

    public static long packDateTimeWithZone(DateTime dateTime) {
        return DateTimeEncoding.packDateTimeWithZone((long)dateTime.getMillis(), (String)dateTime.getZone().getID());
    }

    public static int extractZoneOffsetMinutes(long dateTimeWithTimeZone) {
        short zoneKey = DateTimeEncoding.unpackZoneKey((long)dateTimeWithTimeZone).getKey();
        if (FIXED_ZONE_OFFSET[zoneKey] == Integer.MAX_VALUE) {
            return DATE_TIME_ZONES[zoneKey].getOffset(DateTimeEncoding.unpackMillisUtc((long)dateTimeWithTimeZone)) / 60000;
        }
        return FIXED_ZONE_OFFSET[zoneKey];
    }

    static {
        for (TimeZoneKey timeZoneKey : TimeZoneKey.getTimeZoneKeys()) {
            DateTimeZone dateTimeZone;
            short zoneKey = timeZoneKey.getKey();
            DateTimeZoneIndex.DATE_TIME_ZONES[zoneKey] = dateTimeZone = DateTimeZone.forID((String)timeZoneKey.getId());
            DateTimeZoneIndex.CHRONOLOGIES[zoneKey] = ISOChronology.getInstance((DateTimeZone)dateTimeZone);
            if (dateTimeZone.isFixed() && dateTimeZone.getOffset(0L) % 60000 == 0) {
                DateTimeZoneIndex.FIXED_ZONE_OFFSET[zoneKey] = dateTimeZone.getOffset(0L) / 60000;
                continue;
            }
            DateTimeZoneIndex.FIXED_ZONE_OFFSET[zoneKey] = Integer.MAX_VALUE;
        }
    }
}

