/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.redis;

import com.facebook.presto.redis.RedisColumnHandle;
import com.facebook.presto.redis.RedisSplit;
import com.facebook.presto.redis.RedisTableHandle;
import com.facebook.presto.redis.RedisTableLayoutHandle;
import com.facebook.presto.redis.RedisTransactionHandle;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorHandleResolver;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.google.common.base.Preconditions;
import java.util.Objects;

public class RedisHandleResolver
implements ConnectorHandleResolver {
    public Class<? extends ConnectorTransactionHandle> getTransactionHandleClass() {
        return RedisTransactionHandle.class;
    }

    public Class<? extends ConnectorTableHandle> getTableHandleClass() {
        return RedisTableHandle.class;
    }

    public Class<? extends ColumnHandle> getColumnHandleClass() {
        return RedisColumnHandle.class;
    }

    public Class<? extends ConnectorSplit> getSplitClass() {
        return RedisSplit.class;
    }

    public Class<? extends ConnectorTableLayoutHandle> getTableLayoutHandleClass() {
        return RedisTableLayoutHandle.class;
    }

    static RedisTableHandle convertTableHandle(ConnectorTableHandle tableHandle) {
        Objects.requireNonNull(tableHandle, "tableHandle is null");
        Preconditions.checkArgument((boolean)(tableHandle instanceof RedisTableHandle), (Object)"tableHandle is not an instance of RedisTableHandle");
        return (RedisTableHandle)tableHandle;
    }

    static RedisColumnHandle convertColumnHandle(ColumnHandle columnHandle) {
        Objects.requireNonNull(columnHandle, "columnHandle is null");
        Preconditions.checkArgument((boolean)(columnHandle instanceof RedisColumnHandle), (Object)"columnHandle is not an instance of RedisColumnHandle");
        return (RedisColumnHandle)columnHandle;
    }

    static RedisSplit convertSplit(ConnectorSplit split) {
        Objects.requireNonNull(split, "split is null");
        Preconditions.checkArgument((boolean)(split instanceof RedisSplit), (Object)"split is not an instance of RedisSplit");
        return (RedisSplit)split;
    }

    static RedisTableLayoutHandle convertLayout(ConnectorTableLayoutHandle layout) {
        Objects.requireNonNull(layout, "layout is null");
        Preconditions.checkArgument((boolean)(layout instanceof RedisTableLayoutHandle), (Object)"layout is not an instance of RedisTableLayoutHandle");
        return (RedisTableLayoutHandle)layout;
    }
}

