/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.thrift.api;

import com.facebook.drift.annotations.ThriftConstructor;
import com.facebook.drift.annotations.ThriftField;
import com.facebook.drift.annotations.ThriftStruct;
import com.facebook.presto.spi.HostAddress;
import com.google.common.base.MoreObjects;
import java.util.Objects;

@ThriftStruct
public final class PrestoThriftHostAddress {
    private final String host;
    private final int port;

    @ThriftConstructor
    public PrestoThriftHostAddress(String host, int port) {
        this.host = Objects.requireNonNull(host, "host is null");
        this.port = port;
    }

    @ThriftField(value=1)
    public String getHost() {
        return this.host;
    }

    @ThriftField(value=2)
    public int getPort() {
        return this.port;
    }

    public HostAddress toHostAddress() {
        return HostAddress.fromParts((String)this.getHost(), (int)this.getPort());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PrestoThriftHostAddress other = (PrestoThriftHostAddress)obj;
        return Objects.equals(this.host, other.host) && this.port == other.port;
    }

    public int hashCode() {
        return Objects.hash(this.host, this.port);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("host", (Object)this.host).add("port", this.port).toString();
    }
}

