/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.thrift.api;

import com.facebook.drift.annotations.ThriftConstructor;
import com.facebook.drift.annotations.ThriftField;
import com.facebook.drift.annotations.ThriftStruct;
import com.facebook.presto.connector.thrift.api.NameValidationUtils;
import com.facebook.presto.spi.SchemaTableName;
import com.google.common.base.MoreObjects;
import java.util.Objects;

@ThriftStruct
public final class PrestoThriftSchemaTableName {
    private final String schemaName;
    private final String tableName;

    @ThriftConstructor
    public PrestoThriftSchemaTableName(String schemaName, String tableName) {
        this.schemaName = NameValidationUtils.checkValidName(schemaName);
        this.tableName = NameValidationUtils.checkValidName(tableName);
    }

    public PrestoThriftSchemaTableName(SchemaTableName schemaTableName) {
        this(schemaTableName.getSchemaName(), schemaTableName.getTableName());
    }

    @ThriftField(value=1)
    public String getSchemaName() {
        return this.schemaName;
    }

    @ThriftField(value=2)
    public String getTableName() {
        return this.tableName;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PrestoThriftSchemaTableName other = (PrestoThriftSchemaTableName)obj;
        return Objects.equals(this.schemaName, other.schemaName) && Objects.equals(this.tableName, other.tableName);
    }

    public int hashCode() {
        return Objects.hash(this.schemaName, this.tableName);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("schemaName", (Object)this.schemaName).add("tableName", (Object)this.tableName).toString();
    }

    public SchemaTableName toSchemaTableName() {
        return new SchemaTableName(this.getSchemaName(), this.getTableName());
    }
}

